/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ProbeWireNode
extends PPath {
    private static final Stroke WIRE_STROKE = new BasicStroke(3.0f);
    private final PNode bodyNode;
    private final PNode probeNode;
    private final Point2D bodyControlPointOffset;
    private final Point2D probeControlPointOffset;
    private final Point2D bodyConnectionOffset;
    private final Point2D probeConnectionOffset;

    public ProbeWireNode(PNode pNode, PNode pNode2, Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, Color color) {
        this.setPickable(false);
        this.setStroke(WIRE_STROKE);
        this.setStrokePaint(color);
        this.bodyNode = pNode;
        this.probeNode = pNode2;
        this.bodyControlPointOffset = point2D;
        this.probeControlPointOffset = point2D2;
        this.bodyConnectionOffset = point2D3;
        this.probeConnectionOffset = point2D4;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fullBounds")) {
                    ProbeWireNode.this.update();
                }
            }
        };
        pNode.addPropertyChangeListener(propertyChangeListener);
        pNode2.addPropertyChangeListener(propertyChangeListener);
    }

    private void update() {
        Point2D point2D = this.getConnectionPoint(this.bodyNode, this.bodyConnectionOffset);
        Point2D point2D2 = this.getConnectionPoint(this.probeNode, this.probeConnectionOffset);
        Point2D.Double double_ = new Point2D.Double(point2D.getX() + this.bodyControlPointOffset.getX(), point2D.getY() + this.bodyControlPointOffset.getY());
        Point2D.Double double_2 = new Point2D.Double(point2D2.getX() + this.probeControlPointOffset.getX(), point2D2.getY() + this.probeControlPointOffset.getY());
        this.setPathTo(new CubicCurve2D.Double(point2D.getX(), point2D.getY(), ((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY(), point2D2.getX(), point2D2.getY()));
    }

    private Point2D getConnectionPoint(PNode pNode, Point2D point2D) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(pNode.getRotation(), pNode.getXOffset(), pNode.getYOffset());
        double d = pNode.getXOffset() + point2D.getX();
        double d2 = pNode.getYOffset() + point2D.getY();
        return affineTransform.transform(new Point2D.Double(d, d2), null);
    }
}

