/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view.meters;

import edu.colorado.phet.capacitorlab.CLImages;
import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.drag.WorldLocationDragHandler;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.meter.EFieldDetector;
import edu.colorado.phet.capacitorlab.view.meters.ZoomButtonNode;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.Vector2DNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PClip;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;

class EFieldDetectorBodyNode
extends PhetPNode {
    private static final Font TITLE_FONT = new PhetFont(1, 18);
    private static final Color TITLE_COLOR = Color.WHITE;
    private static final Color BODY_COLOR = new Color(75, 75, 75);
    private static final PDimension VIEWPORT_SIZE = new PDimension(175.0, 200.0);
    private static final PDimension SIMPLIFIED_VIEWPORT_SIZE = new PDimension(85.0, VIEWPORT_SIZE.getHeight());
    private static final Color VIEWPORT_BACKGROUND = Color.WHITE;
    private static final Dimension VECTOR_ARROW_HEAD_SIZE = new Dimension(30, 20);
    private static final Font VALUE_FONT = new PhetFont(14);
    private static final NumberFormat VALUE_FORMAT = new DecimalFormat("0");
    private static final Color VALUE_COLOR = Color.BLACK;
    private static final Font CONTROL_FONT = new PhetFont(1, 16);
    private static final Color CONTROL_COLOR = Color.WHITE;
    private final ViewportNode viewportNode;
    private final Point2D connectionOffset;
    private final Property<Boolean> zoomInEnabledProperty = new Property<Boolean>(false);
    private final Property<Boolean> zoomOutEnabledProperty = new Property<Boolean>(false);

    public EFieldDetectorBodyNode(final EFieldDetector eFieldDetector, final CLModelViewTransform3D cLModelViewTransform3D, double d, boolean bl) {
        PText pText = new PText(CLStrings.ELECTRIC_FIELD){
            {
                this.setTextPaint(TITLE_COLOR);
                this.setFont(TITLE_FONT);
            }
        };
        PImage pImage = new PImage(CLImages.CLOSE_BUTTON){
            {
                super(image);
                this.addInputEventListener(new CursorHandler());
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mouseReleased(PInputEvent pInputEvent) {
                        eFieldDetector.visibleProperty.set(false);
                    }
                });
            }
        };
        this.viewportNode = new ViewportNode(eFieldDetector, d, this.zoomInEnabledProperty, this.zoomOutEnabledProperty, bl);
        this.viewportNode.setSimplified(bl);
        ControlPanelNode controlPanelNode = new ControlPanelNode(eFieldDetector, this.viewportNode, this.zoomInEnabledProperty, this.zoomOutEnabledProperty, bl);
        double d2 = controlPanelNode.getFullBoundsReference().getWidth() + this.viewportNode.getFullBoundsReference().getWidth() + 10.0 + 2.0;
        double d3 = pText.getFullBoundsReference().getHeight() + 4.0 + Math.max(controlPanelNode.getFullBoundsReference().getHeight(), this.viewportNode.getFullBoundsReference().getHeight()) + 10.0;
        PPath pPath = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d2, d3, 15.0, 15.0));
        pPath.setPaint(BODY_COLOR);
        pPath.setStroke(null);
        this.addChild(pPath);
        this.addChild(pText);
        this.addChild(pImage);
        this.addChild(controlPanelNode);
        this.addChild(this.viewportNode);
        double d4 = 0.0;
        double d5 = 0.0;
        pPath.setOffset(d4, d5);
        d4 = pPath.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0;
        d5 = 5.0;
        pText.setOffset(d4, d5);
        d4 = pPath.getFullBoundsReference().getMaxX() - pImage.getFullBoundsReference().getWidth() - 5.0;
        d5 = pPath.getFullBoundsReference().getMinY() + 5.0;
        pImage.setOffset(d4, d5);
        d4 = 5.0;
        d5 = pText.getFullBoundsReference().getMaxY() + 4.0;
        controlPanelNode.setOffset(d4, d5);
        d4 = controlPanelNode.getFullBoundsReference().getMaxX() + 2.0;
        d5 = controlPanelNode.getYOffset();
        this.viewportNode.setOffset(d4, d5);
        this.connectionOffset = new Point2D.Double(0.0, this.getFullBoundsReference().getHeight() / 2.0);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new WorldLocationDragHandler(eFieldDetector.bodyLocationProperty, this, cLModelViewTransform3D));
        eFieldDetector.bodyLocationProperty.addObserver(new SimpleObserver(){

            public void update() {
                EFieldDetectorBodyNode.this.setOffset(cLModelViewTransform3D.modelToView((Point3D)eFieldDetector.bodyLocationProperty.get()));
            }
        });
    }

    public Point2D getConnectionOffset() {
        return new Point2D.Double(this.connectionOffset.getX(), this.connectionOffset.getY());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ControlPanelNode
    extends PNode {
        public ControlPanelNode(EFieldDetector eFieldDetector, final ViewportNode viewportNode, Property<Boolean> property, Property<Boolean> property2, boolean bl) {
            PSwing pSwing = new PSwing(new ShowVectorsPanel(eFieldDetector));
            pSwing.setVisible(!bl);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    viewportNode.zoom();
                }
            };
            ZoomPanelNode zoomPanelNode = new ZoomPanelNode(actionListener, actionListener, property, property2);
            PSwing pSwing2 = new PSwing(new DetectorCheckBox(CLStrings.SHOW_VALUES, eFieldDetector.valuesVisibleProperty, CONTROL_COLOR));
            this.addChild(pSwing);
            this.addChild(zoomPanelNode);
            this.addChild(pSwing2);
            double d = 0.0;
            double d2 = 0.0;
            pSwing.setOffset(d, d2);
            d = 5.0;
            d2 = pSwing.getFullBoundsReference().getMaxY() + 8.0 - PNodeLayoutUtils.getOriginYOffset(zoomPanelNode);
            zoomPanelNode.setOffset(d, d2);
            d = 5.0;
            d2 = zoomPanelNode.getFullBoundsReference().getMaxY() + 4.0;
            pSwing2.setOffset(d, d2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DetectorCheckBox
    extends PropertyCheckBox {
        public DetectorCheckBox(String string, Property<Boolean> property, Color color) {
            super(string, property);
            this.setOpaque(false);
            this.setFont(CONTROL_FONT);
            this.setForeground(color);
        }
    }

    private static class FieldValueNode
    extends PComposite {
        private final PText labelNode;
        private final PText valueNode;

        public FieldValueNode(String string, Color color) {
            this.labelNode = new PText(string);
            this.labelNode.setPaint(color);
            this.labelNode.setTextPaint(VALUE_COLOR);
            this.labelNode.setFont(VALUE_FONT);
            this.addChild(this.labelNode);
            this.valueNode = new PText();
            this.valueNode.setPaint(color);
            this.valueNode.setTextPaint(VALUE_COLOR);
            this.valueNode.setFont(VALUE_FONT);
            this.addChild(this.valueNode);
            this.setValue(0.0);
        }

        public void setValue(double d) {
            String string = VALUE_FORMAT.format(Math.abs(d));
            this.valueNode.setText(MessageFormat.format(CLStrings.PATTERN_VALUE_UNITS, string, CLStrings.VOLTS_PER_METER));
            this.updateLayout();
        }

        public void setValueVisible(boolean bl) {
            if (bl) {
                this.addChild(this.valueNode);
            } else if (this.indexOfChild(this.valueNode) != -1) {
                this.removeChild(this.valueNode);
            }
        }

        private void updateLayout() {
            double d = -this.labelNode.getFullBoundsReference().getWidth() / 2.0;
            double d2 = 0.0;
            this.labelNode.setOffset(d, d2);
            d = -this.valueNode.getFullBoundsReference().getWidth() / 2.0;
            d2 = this.labelNode.getFullBoundsReference().getMaxY() - 1.0;
            this.valueNode.setOffset(d, d2);
        }
    }

    private static class FieldVectorNode
    extends Vector2DNode {
        public FieldVectorNode(Color color, double d) {
            super(0.0, 0.0, d, 1.0);
            this.setArrowFillPaint(color);
            this.setHeadSize(VECTOR_ARROW_HEAD_SIZE);
            this.setTailWidth(10.0);
        }
    }

    private static class ShowVectorsPanel
    extends GridPanel {
        public ShowVectorsPanel(EFieldDetector eFieldDetector) {
            this.setBackground(BODY_COLOR);
            JLabel jLabel = new JLabel(CLStrings.SHOW_VECTORS){
                {
                    this.setFont(CONTROL_FONT);
                    this.setForeground(CONTROL_COLOR);
                }
            };
            DetectorCheckBox detectorCheckBox = new DetectorCheckBox(CLStrings.PLATE, eFieldDetector.plateVisibleProperty, CLPaints.PLATE_EFIELD_VECTOR);
            DetectorCheckBox detectorCheckBox2 = new DetectorCheckBox(CLStrings.DIELECTRIC, eFieldDetector.dielectricVisibleProperty, CLPaints.DIELECTRIC_EFIELD_VECTOR);
            DetectorCheckBox detectorCheckBox3 = new DetectorCheckBox(CLStrings.SUM, eFieldDetector.sumVisibleProperty, CLPaints.SUM_EFIELD_VECTOR);
            this.setAnchor(GridPanel.Anchor.WEST);
            int n = 0;
            int n2 = 0;
            this.add((Component)jLabel, n++, n2);
            this.add((Component)detectorCheckBox, n++, n2);
            this.add((Component)detectorCheckBox2, n++, n2);
            this.add((Component)detectorCheckBox3, n++, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ViewportNode
    extends PClip {
        private final EFieldDetector detector;
        private final Property<Boolean> zoomInEnabledProperty;
        private final Property<Boolean> zoomOutEnabledProperty;
        private final PComposite sceneNode;
        private final FieldVectorNode plateVectorNode;
        private final FieldVectorNode dielectricVectorNode;
        private final FieldVectorNode sumVectorNode;
        private final FieldValueNode plateValueNode;
        private final FieldValueNode dielectricValueNode;
        private final FieldValueNode sumValueNode;
        private double vectorsScale;
        private boolean simplified;

        public ViewportNode(EFieldDetector eFieldDetector, double d, Property<Boolean> property, Property<Boolean> property2, boolean bl) {
            PDimension pDimension = bl ? SIMPLIFIED_VIEWPORT_SIZE : VIEWPORT_SIZE;
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight()));
            this.setPaint(VIEWPORT_BACKGROUND);
            this.setStroke(null);
            this.detector = eFieldDetector;
            this.zoomInEnabledProperty = property;
            this.zoomOutEnabledProperty = property2;
            this.vectorsScale = 1.0;
            bl = false;
            this.plateVectorNode = new FieldVectorNode(CLPaints.PLATE_EFIELD_VECTOR, d);
            this.dielectricVectorNode = new FieldVectorNode(CLPaints.DIELECTRIC_EFIELD_VECTOR, d);
            this.sumVectorNode = new FieldVectorNode(CLPaints.SUM_EFIELD_VECTOR, d);
            this.plateValueNode = new FieldValueNode(CLStrings.PLATE, CLPaints.PLATE_EFIELD_VECTOR);
            this.dielectricValueNode = new FieldValueNode(CLStrings.DIELECTRIC, CLPaints.DIELECTRIC_EFIELD_VECTOR);
            this.sumValueNode = new FieldValueNode(CLStrings.SUM, CLPaints.SUM_EFIELD_VECTOR);
            this.sceneNode = new PComposite();
            this.addChild(this.sceneNode);
            this.sceneNode.addChild(this.plateVectorNode);
            this.sceneNode.addChild(this.dielectricVectorNode);
            this.sceneNode.addChild(this.sumVectorNode);
            this.sceneNode.addChild(this.plateValueNode);
            this.sceneNode.addChild(this.dielectricValueNode);
            this.sceneNode.addChild(this.sumValueNode);
            SimpleObserver simpleObserver = new SimpleObserver(){

                public void update() {
                    ViewportNode.this.updateVectors();
                }
            };
            eFieldDetector.addPlateVectorObserver(simpleObserver);
            eFieldDetector.addDielectricVectorObserver(simpleObserver);
            eFieldDetector.addSumVectorObserver(simpleObserver);
            RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

                public void update() {
                    ViewportNode.this.updateVisibility();
                }
            };
            richSimpleObserver.observe(eFieldDetector.plateVisibleProperty, eFieldDetector.dielectricVisibleProperty, eFieldDetector.sumVisibleProperty, eFieldDetector.valuesVisibleProperty);
            this.zoom();
        }

        public void setSimplified(boolean bl) {
            if (bl != this.simplified) {
                this.simplified = bl;
                this.updateVisibility();
            }
        }

        private void zoom() {
            double d = this.plateVectorNode.getFullBoundsReference().getHeight();
            double d2 = this.getSceneHeight() - d;
            double d3 = 0.9 * (this.getViewportHeight() - d2) / (this.getSceneHeight() - d2);
            this.vectorsScale *= d3;
            this.updateVectors();
        }

        private boolean canZoomOut() {
            boolean bl = false;
            if (this.isZoomable()) {
                bl = this.getViewportHeight() < this.getSceneHeight();
            }
            return bl;
        }

        private boolean canZoomIn() {
            boolean bl = false;
            if (this.isZoomable()) {
                bl = 0.75 * this.getViewportHeight() > this.getSceneHeight();
            }
            return bl;
        }

        private double getViewportHeight() {
            return this.getFullBoundsReference().getHeight();
        }

        private double getSceneHeight() {
            return this.sceneNode.getFullBoundsReference().getHeight();
        }

        private boolean isZoomable() {
            return this.hasVisibleVector() && this.hasNonZeroVector();
        }

        private boolean hasNonZeroVector() {
            return this.detector.getPlateVector() != 0.0 || this.detector.getDielectricVector() != 0.0 || this.detector.getSumVector() != 0.0;
        }

        private boolean hasVisibleVector() {
            return this.plateVectorNode.isVisible() || this.dielectricVectorNode.isVisible() || this.sumVectorNode.isVisible();
        }

        private void updateVectors() {
            this.plateVectorNode.setXY(0.0, this.vectorsScale * this.detector.getPlateVector());
            this.plateValueNode.setValue(this.detector.getPlateVector());
            this.dielectricVectorNode.setXY(0.0, this.vectorsScale * -this.detector.getDielectricVector());
            this.dielectricValueNode.setValue(this.detector.getDielectricVector());
            this.sumVectorNode.setXY(0.0, this.vectorsScale * this.detector.getSumVector());
            this.sumValueNode.setValue(this.detector.getSumVector());
            this.updateLayout();
        }

        private void updateVisibility() {
            boolean bl = this.detector.plateVisibleProperty.get();
            this.plateVectorNode.setVisible(bl);
            this.plateValueNode.setVisible(bl);
            boolean bl2 = this.detector.dielectricVisibleProperty.get();
            this.dielectricVectorNode.setVisible(bl2);
            this.dielectricValueNode.setVisible(bl2);
            boolean bl3 = this.detector.sumVisibleProperty.get();
            this.sumVectorNode.setVisible(bl3);
            this.sumValueNode.setVisible(bl3);
            boolean bl4 = this.detector.valuesVisibleProperty.get();
            this.plateValueNode.setValueVisible(bl4);
            this.dielectricValueNode.setValueVisible(bl4);
            this.sumValueNode.setValueVisible(bl4);
            if (this.simplified) {
                this.dielectricVectorNode.setVisible(false);
                this.dielectricValueNode.setVisible(false);
                this.sumVectorNode.setVisible(false);
                this.sumValueNode.setVisible(false);
            }
            this.updateLayout();
        }

        private void updateLayout() {
            double d = this.simplified ? 0.0 : this.getBoundsReference().getWidth() / 4.0;
            double d2 = this.getBoundsReference().getCenterX() - d;
            double d3 = this.getBoundsReference().getCenterY() - this.plateVectorNode.getFullBoundsReference().getHeight() / 2.0 - PNodeLayoutUtils.getOriginYOffset(this.plateVectorNode);
            this.plateVectorNode.setOffset(d2, d3);
            d2 = this.getBoundsReference().getCenterX() + d;
            d3 = this.plateVectorNode.getYOffset();
            this.sumVectorNode.setOffset(d2, d3);
            d2 = this.sumVectorNode.getXOffset();
            d3 = this.sumVectorNode.getVector().getY() < 0.0 ? this.sumVectorNode.getFullBoundsReference().getMinY() - this.dielectricVectorNode.getFullBoundsReference().getHeight() : this.sumVectorNode.getFullBoundsReference().getMaxY() + this.dielectricVectorNode.getFullBoundsReference().getHeight();
            this.dielectricVectorNode.setOffset(d2, d3);
            d2 = this.plateVectorNode.getFullBoundsReference().getCenterX();
            d3 = this.plateVectorNode.getVector().getY() >= 0.0 ? this.plateVectorNode.getFullBoundsReference().getMinY() - this.plateValueNode.getFullBoundsReference().getHeight() - 2.0 : this.plateVectorNode.getFullBoundsReference().getMaxY() + 2.0;
            this.plateValueNode.setOffset(d2, d3);
            d2 = this.sumVectorNode.getFullBoundsReference().getCenterX();
            d3 = this.sumVectorNode.getVector().getY() >= 0.0 ? this.sumVectorNode.getFullBoundsReference().getMinY() - this.sumValueNode.getFullBoundsReference().getHeight() - 2.0 : this.sumVectorNode.getFullBoundsReference().getMaxY() + 2.0;
            this.sumValueNode.setOffset(d2, d3);
            d2 = this.dielectricVectorNode.getFullBoundsReference().getCenterX();
            d3 = this.dielectricVectorNode.getVector().getY() > 0.0 || this.dielectricVectorNode.getVector().getY() == 0.0 && this.sumVectorNode.getVector().getY() < 0.0 ? this.dielectricVectorNode.getFullBoundsReference().getMinY() - this.dielectricValueNode.getFullBoundsReference().getHeight() - 2.0 : this.dielectricVectorNode.getFullBoundsReference().getMaxY() + 2.0;
            this.dielectricValueNode.setOffset(d2, d3);
            this.updateZoomEnabled();
        }

        private void updateZoomEnabled() {
            this.zoomInEnabledProperty.set(this.canZoomIn());
            this.zoomOutEnabledProperty.set(this.canZoomOut());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZoomPanelNode
    extends PNode {
        public ZoomPanelNode(ActionListener actionListener, ActionListener actionListener2, final Property<Boolean> property, final Property<Boolean> property2) {
            PText pText = new PText(CLStrings.ZOOM);
            this.addChild(pText);
            pText.setFont(CONTROL_FONT);
            pText.setTextPaint(CONTROL_COLOR);
            final ZoomButtonNode.ZoomInButtonNode zoomInButtonNode = new ZoomButtonNode.ZoomInButtonNode();
            this.addChild(zoomInButtonNode);
            zoomInButtonNode.addActionListener(actionListener);
            final ZoomButtonNode.ZoomOutButtonNode zoomOutButtonNode = new ZoomButtonNode.ZoomOutButtonNode();
            this.addChild(zoomOutButtonNode);
            zoomOutButtonNode.addActionListener(actionListener2);
            double d = pText.getFullBoundsReference().getMaxX() + 4.0;
            double d2 = pText.getFullBoundsReference().getMaxY() - zoomInButtonNode.getFullBoundsReference().getHeight();
            zoomInButtonNode.setOffset(d, d2);
            d2 = zoomInButtonNode.getFullBoundsReference().getMaxY() + 3.0;
            zoomOutButtonNode.setOffset(d, d2);
            property.addObserver(new SimpleObserver(){

                public void update() {
                    zoomInButtonNode.setEnabled((Boolean)property.get());
                }
            });
            property2.addObserver(new SimpleObserver(){

                public void update() {
                    zoomOutButtonNode.setEnabled((Boolean)property2.get());
                }
            });
        }
    }
}

