/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.view;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.CLPaints;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public class EFieldNode
extends PhetPNode {
    private final Capacitor capacitor;
    private final CLModelViewTransform3D mvt;
    private final PNode parentNode;
    private final double maxEffectiveEField;

    public EFieldNode(Capacitor capacitor, CLModelViewTransform3D cLModelViewTransform3D, double d) {
        this.capacitor = capacitor;
        this.mvt = cLModelViewTransform3D;
        this.maxEffectiveEField = d;
        capacitor.addCapacitorChangeListener(new Capacitor.CapacitorChangeListener(){

            public void capacitorChanged() {
                if (EFieldNode.this.isVisible()) {
                    EFieldNode.this.update();
                }
            }
        });
        this.parentNode = new PComposite();
        this.addChild(this.parentNode);
        this.update();
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            if (bl) {
                this.update();
            }
        }
    }

    private void update() {
        this.parentNode.removeAllChildren();
        double d = this.capacitor.getEffectiveEField();
        double d2 = this.getLineSpacing(d);
        if (d2 > 0.0) {
            double d3;
            double d4 = d3 = this.capacitor.getPlateWidth();
            double d5 = this.capacitor.getPlateSeparation();
            double d6 = this.mvt.modelToViewDelta(0.0, d5, 0.0).getY();
            Direction direction = d >= 0.0 ? Direction.DOWN : Direction.UP;
            for (double d7 = d2 / 2.0; d7 <= d3 / 2.0; d7 += d2) {
                for (double d8 = d2 / 2.0; d8 <= d4 / 2.0; d8 += d2) {
                    EFieldLineNode eFieldLineNode = new EFieldLineNode(d6, direction);
                    EFieldLineNode eFieldLineNode2 = new EFieldLineNode(d6, direction);
                    EFieldLineNode eFieldLineNode3 = new EFieldLineNode(d6, direction);
                    EFieldLineNode eFieldLineNode4 = new EFieldLineNode(d6, direction);
                    this.parentNode.addChild(eFieldLineNode);
                    this.parentNode.addChild(eFieldLineNode2);
                    this.parentNode.addChild(eFieldLineNode3);
                    this.parentNode.addChild(eFieldLineNode4);
                    double d9 = 0.0;
                    eFieldLineNode.setOffset(this.mvt.modelToView(d7, d9, d8));
                    eFieldLineNode2.setOffset(this.mvt.modelToView(-d7, d9, d8));
                    eFieldLineNode3.setOffset(this.mvt.modelToView(d7, d9, -d8));
                    eFieldLineNode4.setOffset(this.mvt.modelToView(-d7, d9, -d8));
                }
            }
        }
    }

    private double getLineSpacing(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        int n = this.getNumberOfLines(d);
        return CLConstants.PLATE_WIDTH_RANGE.getMin() / Math.sqrt(n);
    }

    private int getNumberOfLines(double d) {
        double d2 = Math.abs(d);
        int n = (int)((double)CLConstants.NUMBER_OF_EFIELD_LINES.getMax() * d2 / this.maxEffectiveEField);
        if (d2 > 0.0 && n < CLConstants.NUMBER_OF_EFIELD_LINES.getMin()) {
            n = CLConstants.NUMBER_OF_EFIELD_LINES.getMin();
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction UP = new Direction();
        public static final /* enum */ Direction DOWN = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        static {
            $VALUES = new Direction[]{UP, DOWN};
        }
    }

    private static class EFieldLineNode
    extends PComposite {
        public static final PDimension ARROW_SIZE = new PDimension(10.0, 15.0);
        public static final Stroke LINE_STROKE = new BasicStroke(2.0f);

        public EFieldLineNode(double d, Direction direction) {
            PPath pPath = new PPath(new Line2D.Double(0.0, -d / 2.0, 0.0, d / 2.0));
            pPath.setStroke(LINE_STROKE);
            pPath.setStrokePaint(CLPaints.EFIELD);
            this.addChild(pPath);
            GeneralPath generalPath = new GeneralPath();
            float f = (float)ARROW_SIZE.getWidth();
            float f2 = (float)ARROW_SIZE.getHeight();
            generalPath.moveTo(0.0f, -f2 / 2.0f);
            generalPath.lineTo(f / 2.0f, f2 / 2.0f);
            generalPath.lineTo(-f / 2.0f, f2 / 2.0f);
            generalPath.closePath();
            PPath pPath2 = new PPath(generalPath);
            pPath2.setPaint(CLPaints.EFIELD);
            pPath2.setStroke(null);
            this.addChild(pPath2);
            if (direction == Direction.DOWN) {
                pPath2.rotate(Math.PI);
            }
        }
    }
}

