/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.module.multiplecapacitors;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.CLModel;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.CircuitConfig;
import edu.colorado.phet.capacitorlab.model.DielectricMaterial;
import edu.colorado.phet.capacitorlab.model.circuit.Combination1Circuit;
import edu.colorado.phet.capacitorlab.model.circuit.Combination2Circuit;
import edu.colorado.phet.capacitorlab.model.circuit.ICircuit;
import edu.colorado.phet.capacitorlab.model.circuit.ParallelCircuit;
import edu.colorado.phet.capacitorlab.model.circuit.SeriesCircuit;
import edu.colorado.phet.capacitorlab.model.circuit.SingleCircuit;
import edu.colorado.phet.capacitorlab.model.meter.BarMeter;
import edu.colorado.phet.capacitorlab.model.meter.EFieldDetector;
import edu.colorado.phet.capacitorlab.model.meter.Voltmeter;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleCapacitorsModel
extends CLModel {
    private static final Point3D BATTERY_LOCATION = new Point3D.Double(0.005, 0.03, 0.0);
    private static final DielectricMaterial DIELECTRIC_MATERIAL = new DielectricMaterial.Air();
    private static final double PLATE_SEPARATION = Capacitor.getPlateSeparation(DIELECTRIC_MATERIAL.getDielectricConstant(), 0.0075, CLConstants.CAPACITANCE_RANGE.getMin());
    public static final Point3D CAPACITANCE_METER_LOCATION = new Point3D.Double(0.033, 0.0017, 0.0);
    public static final Point3D PLATE_CHARGE_METER_LOCATION = new Point3D.Double(0.046, 0.0017, 0.0);
    public static final Point3D STORED_ENERGY_METER_LOCATION = new Point3D.Double(0.059, 0.0017, 0.0);
    public static final Point3D EFIELD_DETECTOR_BODY_LOCATION = new Point3D.Double(0.05, 0.041, 0.0);
    public static final Point3D EFIELD_DETECTOR_PROBE_LOCATION = BATTERY_LOCATION;
    public static final Point3D VOLTMETER_BODY_LOCATION = new Point3D.Double(0.04, 0.041, 0.0);
    public static final Point3D VOLTMETER_POSITIVE_PROBE_LOCATION = new Point3D.Double(0.035, 0.042, 0.0);
    public static final Point3D VOLTMETER_NEGATIVE_PROBE_LOCATION = new Point3D.Double(0.038, 0.042, 0.0);
    private final ArrayList<ICircuit> circuits;
    public final Property<ICircuit> currentCircuitProperty;
    public final BarMeter.CapacitanceMeter capacitanceMeter;
    public final BarMeter.PlateChargeMeter plateChargeMeter;
    public final BarMeter.StoredEnergyMeter storedEnergyMeter;
    public final EFieldDetector eFieldDetector;
    public final Voltmeter voltmeter;

    public MultipleCapacitorsModel(IClock iClock, CLModelViewTransform3D cLModelViewTransform3D) {
        final CircuitConfig circuitConfig = new CircuitConfig(iClock, cLModelViewTransform3D, BATTERY_LOCATION, 0.018, 0.016, 0.0075, PLATE_SEPARATION, DIELECTRIC_MATERIAL, 0.0, 5.0E-4, 0.01);
        this.circuits = new ArrayList<ICircuit>(){
            {
                this.add(new SingleCircuit(circuitConfig));
                this.add(new SeriesCircuit(circuitConfig, CLStrings.TWO_IN_SERIES, 2));
                this.add(new SeriesCircuit(circuitConfig, CLStrings.THREE_IN_SERIES, 3));
                this.add(new ParallelCircuit(circuitConfig, CLStrings.TWO_IN_PARALLEL, 2));
                this.add(new ParallelCircuit(circuitConfig, CLStrings.THREE_IN_PARALLEL, 3));
                this.add(new Combination1Circuit(circuitConfig));
                this.add(new Combination2Circuit(circuitConfig));
            }
        };
        this.currentCircuitProperty = new Property<ICircuit>(this.circuits.get(0));
        this.capacitanceMeter = new BarMeter.CapacitanceMeter(this.currentCircuitProperty.get(), this.getWorldBounds(), CAPACITANCE_METER_LOCATION, false);
        this.plateChargeMeter = new BarMeter.PlateChargeMeter(this.currentCircuitProperty.get(), this.getWorldBounds(), PLATE_CHARGE_METER_LOCATION, false);
        this.storedEnergyMeter = new BarMeter.StoredEnergyMeter(this.currentCircuitProperty.get(), this.getWorldBounds(), STORED_ENERGY_METER_LOCATION, false);
        this.eFieldDetector = new EFieldDetector(this.currentCircuitProperty.get(), this.getWorldBounds(), cLModelViewTransform3D, EFIELD_DETECTOR_BODY_LOCATION, EFIELD_DETECTOR_PROBE_LOCATION, false, true, true, true, true);
        this.voltmeter = new Voltmeter(this.currentCircuitProperty.get(), this.getWorldBounds(), cLModelViewTransform3D, VOLTMETER_BODY_LOCATION, VOLTMETER_POSITIVE_PROBE_LOCATION, VOLTMETER_NEGATIVE_PROBE_LOCATION, false);
        this.currentCircuitProperty.addObserver(new SimpleObserver(){

            public void update() {
                ICircuit iCircuit = MultipleCapacitorsModel.this.currentCircuitProperty.get();
                MultipleCapacitorsModel.this.capacitanceMeter.setCircuit(iCircuit);
                MultipleCapacitorsModel.this.plateChargeMeter.setCircuit(iCircuit);
                MultipleCapacitorsModel.this.storedEnergyMeter.setCircuit(iCircuit);
                MultipleCapacitorsModel.this.eFieldDetector.setCircuit(iCircuit);
                MultipleCapacitorsModel.this.voltmeter.setCircuit(iCircuit);
            }
        });
        final Property<Double> property = new Property<Double>(this.currentCircuitProperty.get().getBattery().getVoltage());
        property.addObserver(new SimpleObserver(){

            public void update() {
                for (ICircuit iCircuit : MultipleCapacitorsModel.this.circuits) {
                    iCircuit.getBattery().setVoltage((Double)property.get());
                }
            }
        });
        for (final ICircuit iCircuit : this.circuits) {
            iCircuit.getBattery().addVoltageObserver(new SimpleObserver(){

                public void update() {
                    property.set(iCircuit.getBattery().getVoltage());
                }
            });
        }
    }

    public void reset() {
        this.capacitanceMeter.reset();
        this.plateChargeMeter.reset();
        this.storedEnergyMeter.reset();
        this.eFieldDetector.reset();
        this.voltmeter.reset();
        for (ICircuit iCircuit : this.circuits) {
            iCircuit.reset();
        }
        this.currentCircuitProperty.reset();
    }

    public ArrayList<ICircuit> getCircuits() {
        return new ArrayList<ICircuit>(this.circuits);
    }

    public static double getEFieldReferenceMagnitude() {
        Capacitor capacitor = new Capacitor(new Point3D.Double(), 0.0075, PLATE_SEPARATION, new DielectricMaterial.Air(), 0.0, new CLModelViewTransform3D());
        capacitor.setPlatesVoltage(CLConstants.BATTERY_VOLTAGE_RANGE.getMax());
        return capacitor.getEffectiveEField();
    }
}

