/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.module.introduction;

import edu.colorado.phet.capacitorlab.CLConstants;
import edu.colorado.phet.capacitorlab.CLGlobalProperties;
import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.DielectricMaterial;
import edu.colorado.phet.capacitorlab.module.CLModule;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricCanvas;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricModel;
import edu.colorado.phet.capacitorlab.module.introduction.IntroductionControlPanel;

public class IntroductionModule
extends CLModule {
    private final DielectricModel model;
    private final DielectricCanvas canvas;

    public IntroductionModule(CLGlobalProperties cLGlobalProperties) {
        super(CLStrings.INTRODUCTION);
        CLModelViewTransform3D cLModelViewTransform3D = new CLModelViewTransform3D();
        double d = CLConstants.PLATE_WIDTH_RANGE.getMax() + 1.0;
        this.model = new DielectricModel(this.getClock(), cLModelViewTransform3D, d, new DielectricMaterial[]{new DielectricMaterial.Air()});
        this.canvas = new DielectricCanvas(this.model, cLModelViewTransform3D, cLGlobalProperties, true, false);
        this.setSimulationPanel(this.canvas);
        this.setControlPanel(new IntroductionControlPanel(this, this.model, this.canvas, cLGlobalProperties));
    }

    public void reset() {
        super.reset();
        this.model.reset();
        this.canvas.reset();
    }
}

