/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.model.wire;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.Capacitor;
import edu.colorado.phet.capacitorlab.model.wire.Wire;
import edu.colorado.phet.capacitorlab.model.wire.WireSegment;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ShapeUtils;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WireCapacitorToCapacitors
extends Wire {
    private final Capacitor topCapacitor;

    public WireCapacitorToCapacitors(CLModelViewTransform3D cLModelViewTransform3D, double d, Capacitor capacitor, Capacitor ... capacitorArray) {
        this(cLModelViewTransform3D, d, capacitor, new ArrayList<Capacitor>(Arrays.asList(capacitorArray)));
    }

    public WireCapacitorToCapacitors(CLModelViewTransform3D cLModelViewTransform3D, double d, Capacitor capacitor, ArrayList<Capacitor> arrayList) {
        super(cLModelViewTransform3D, d);
        this.topCapacitor = capacitor;
        this.addSegment(new WireSegment.CapacitorToCapacitorWireSegment(capacitor, arrayList.get(0)));
        if (arrayList.size() > 1) {
            double d2 = this.getCornerOffset();
            double d3 = capacitor.getX() - d2;
            double d4 = arrayList.get(arrayList.size() - 1).getX() + d2;
            double d5 = capacitor.getY() + (arrayList.get(0).getY() - capacitor.getY()) / 2.0;
            this.addSegment(new WireSegment(d3, d5, d4, d5));
            for (int i = 1; i < arrayList.size(); ++i) {
                double d6 = arrayList.get(i).getX();
                this.addSegment(new WireSegment.CapacitorTopWireSegment(arrayList.get(i), (Point2D)new Point2D.Double(d6, d5)));
            }
        }
        capacitor.addPlateSizeObserver(new SimpleObserver(){

            public void update() {
                WireCapacitorToCapacitors.this.setShape(WireCapacitorToCapacitors.this.createShape());
            }
        });
    }

    @Override
    protected Shape createShape() {
        Shape shape = super.createShape();
        if (this.topCapacitor != null) {
            shape = ShapeUtils.subtract(shape, this.topCapacitor.getShapeCreator().createBottomPlateShape());
        }
        return shape;
    }
}

