/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.drag;

import edu.colorado.phet.capacitorlab.model.CLModelViewTransform3D;
import edu.colorado.phet.capacitorlab.model.WorldLocationProperty;
import edu.colorado.phet.common.phetcommon.math.Point3D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

public class WorldLocationDragHandler
extends PDragSequenceEventHandler {
    private final WorldLocationProperty locationProperty;
    private final PNode dragNode;
    private final CLModelViewTransform3D mvt;
    private double clickXOffset;
    private double clickYOffset;

    public WorldLocationDragHandler(WorldLocationProperty worldLocationProperty, PNode pNode, CLModelViewTransform3D cLModelViewTransform3D) {
        this.locationProperty = worldLocationProperty;
        this.dragNode = pNode;
        this.mvt = cLModelViewTransform3D;
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
        Point2D point2D2 = this.mvt.modelToViewDelta((Point3D)this.locationProperty.get());
        this.clickXOffset = point2D.getX() - point2D2.getX();
        this.clickYOffset = point2D.getY() - point2D2.getY();
    }

    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
        double d = point2D.getX() - this.clickXOffset;
        double d2 = point2D.getY() - this.clickYOffset;
        this.locationProperty.set(this.mvt.viewToModel(d, d2));
    }
}

