/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.developer;

import edu.colorado.phet.capacitorlab.developer.DielectricModelValuesDialog;
import edu.colorado.phet.capacitorlab.module.dielectric.DielectricModel;
import edu.colorado.phet.common.phetcommon.view.PhetTitledPanel;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;

public class DeveloperControlPanel
extends PhetTitledPanel {
    private final Frame parentFrame;
    private final DielectricModel model;
    private final JCheckBox modelValuesCheckBox;
    private DielectricModelValuesDialog modelValuesDialog;
    private Point modelValuesDialogLocation;

    public DeveloperControlPanel(Frame frame, DielectricModel dielectricModel) {
        super("Developer");
        this.setTitleColor(Color.RED);
        this.parentFrame = frame;
        this.model = dielectricModel;
        this.modelValuesCheckBox = new JCheckBox("Model Values");
        this.modelValuesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DeveloperControlPanel.this.modelValuesCheckBox.isSelected()) {
                    DeveloperControlPanel.this.openModelValuesDialog();
                } else {
                    DeveloperControlPanel.this.closeModelValuesDialog();
                }
            }
        });
        GridPanel gridPanel = new GridPanel();
        gridPanel.setAnchor(GridPanel.Anchor.WEST);
        gridPanel.setGridX(0);
        gridPanel.add(this.modelValuesCheckBox);
        this.setLayout(new BorderLayout());
        this.add((Component)gridPanel, "West");
    }

    private void openModelValuesDialog() {
        this.closeModelValuesDialog();
        this.modelValuesDialog = new DielectricModelValuesDialog(this.parentFrame, this.model);
        this.modelValuesDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DeveloperControlPanel.this.closeModelValuesDialog();
            }

            public void windowClosed(WindowEvent windowEvent) {
                DeveloperControlPanel.this.modelValuesDialog = null;
                if (DeveloperControlPanel.this.modelValuesCheckBox.isSelected()) {
                    DeveloperControlPanel.this.modelValuesCheckBox.setSelected(false);
                }
            }
        });
        if (this.modelValuesDialogLocation == null) {
            SwingUtils.centerInParent(this.modelValuesDialog);
        } else {
            this.modelValuesDialog.setLocation(this.modelValuesDialogLocation);
        }
        this.modelValuesDialog.setVisible(true);
    }

    private void closeModelValuesDialog() {
        if (this.modelValuesDialog != null) {
            this.modelValuesDialogLocation = this.modelValuesDialog.getLocation();
            this.modelValuesDialog.dispose();
            this.modelValuesDialog = null;
        }
    }
}

