/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.capacitorlab.control;

import edu.colorado.phet.capacitorlab.CLStrings;
import edu.colorado.phet.capacitorlab.model.DielectricMaterial;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DielectricMaterialControl
extends JPanel {
    private final JComboBox comboBox;
    private final ArrayList<ChangeListener> listeners = new ArrayList();

    public DielectricMaterialControl(DielectricMaterial[] dielectricMaterialArray, DielectricMaterial dielectricMaterial) {
        JLabel jLabel = new JLabel(MessageFormat.format(CLStrings.PATTERN_LABEL, CLStrings.MATERIAL));
        this.comboBox = new JComboBox<DielectricMaterial>(dielectricMaterialArray);
        this.comboBox.setRenderer(new DielectricMaterialRenderer());
        this.comboBox.setSelectedItem(dielectricMaterial);
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DielectricMaterialControl.this.fireStateChanged();
                }
            }
        });
        GridPanel gridPanel = new GridPanel();
        gridPanel.setAnchor(GridPanel.Anchor.WEST);
        gridPanel.setFill(GridPanel.Fill.HORIZONTAL);
        gridPanel.setGridY(0);
        gridPanel.add(jLabel);
        gridPanel.add(this.comboBox);
        this.setLayout(new BorderLayout());
        this.add((Component)gridPanel, "West");
    }

    public void setMaterial(DielectricMaterial dielectricMaterial) {
        boolean bl = false;
        for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
            if (this.comboBox.getItemAt(i) != dielectricMaterial) continue;
            this.comboBox.setSelectedIndex(i);
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("material is not one of the combo box items: " + dielectricMaterial.getName());
        }
    }

    public DielectricMaterial getMaterial() {
        return (DielectricMaterial)this.comboBox.getSelectedItem();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : new ArrayList<ChangeListener>(this.listeners)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private static class DielectricMaterialRenderer
    extends JLabel
    implements ListCellRenderer {
        public DielectricMaterialRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(4);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            DielectricMaterial dielectricMaterial = (DielectricMaterial)object;
            this.setText(this.getText(dielectricMaterial));
            this.setIcon(this.getIcon(dielectricMaterial));
            return this;
        }

        public String getText(DielectricMaterial dielectricMaterial) {
            String string = dielectricMaterial instanceof DielectricMaterial.CustomDielectricMaterial ? dielectricMaterial.getName() : MessageFormat.format(CLStrings.PATTERN_MATERIAL_CONSTANT, dielectricMaterial.getName(), dielectricMaterial.getDielectricConstant());
            return string;
        }

        public Icon getIcon(DielectricMaterial dielectricMaterial) {
            PPath pPath = new PPath(new Rectangle2D.Double(0.0, 0.0, 11.0, 11.0));
            pPath.setStroke(null);
            pPath.setPaint(dielectricMaterial.getColor());
            return new ImageIcon(pPath.toImage());
        }
    }
}

