/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.AtomIndexIterator;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.CubeIterator;
import org.jmol.modelset.Atom;

public class AtomIteratorWithinModel
implements AtomIndexIterator {
    private CubeIterator bsptIter;
    private Bspf bspf;
    private boolean threadSafe;
    private boolean hemisphereOnly;
    private boolean isZeroBased;
    private int modelIndex = Integer.MAX_VALUE;
    private int atomIndex = -1;
    private int zeroBase;
    private float distanceSquared;
    private BitSet bsSelected;
    private boolean isGreaterOnly;
    private boolean checkGreater;
    private int iNext;

    void initialize(Bspf bspf, BitSet bitSet, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.bspf = bspf;
        this.bsSelected = bitSet;
        this.isGreaterOnly = bl;
        this.isZeroBased = bl2;
        this.hemisphereOnly = bl3;
        this.threadSafe = bl4;
    }

    public void set(int n, int n2, int n3, Point3f point3f, float f) {
        if (this.threadSafe) {
            n = -1 - n;
        }
        if (n != this.modelIndex || this.bsptIter == null) {
            this.bsptIter = this.bspf.getCubeIterator(n);
            this.modelIndex = n;
        }
        int n4 = this.zeroBase = this.isZeroBased ? n2 : 0;
        if (f == -2.1474836E9f) {
            return;
        }
        this.atomIndex = f < 0.0f ? -1 : n3;
        this.checkGreater = this.isGreaterOnly && n3 != Integer.MAX_VALUE;
        this.set(point3f, f);
    }

    public void set(Point3f point3f, float f) {
        if (this.bsptIter == null) {
            return;
        }
        this.bsptIter.initialize(point3f, f, this.hemisphereOnly);
        this.distanceSquared = f * f;
    }

    public boolean hasNext() {
        if (this.atomIndex >= 0) {
            while (this.bsptIter.hasMoreElements()) {
                Atom atom = (Atom)this.bsptIter.nextElement();
                this.iNext = atom.index;
                if (this.iNext == this.atomIndex || this.checkGreater && this.iNext <= this.atomIndex || this.bsSelected != null && !this.bsSelected.get(this.iNext)) continue;
                return true;
            }
        } else if (this.bsptIter.hasMoreElements()) {
            Atom atom = (Atom)this.bsptIter.nextElement();
            this.iNext = atom.index;
            return true;
        }
        this.iNext = -1;
        return false;
    }

    public int next() {
        return this.iNext - this.zeroBase;
    }

    public float foundDistance2() {
        return this.bsptIter == null ? -1.0f : this.bsptIter.foundDistance2();
    }

    public void addAtoms(BitSet bitSet) {
        while (this.hasNext()) {
            int n = this.next();
            if (n < 0 || !(this.foundDistance2() <= this.distanceSquared)) continue;
            bitSet.set(n);
        }
    }

    public void release() {
        if (this.bsptIter != null) {
            this.bsptIter.release();
            this.bsptIter = null;
        }
    }
}

