/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.Bucket;
import edu.colorado.phet.common.phetcommon.model.IBucketSphere;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SphereBucket<T extends IBucketSphere>
extends Bucket {
    private final ArrayList<T> containedParticles = new ArrayList();
    private final double particleRadius;
    private final double usableWidthProportion;
    private final double yOffset;
    private final IBucketSphere.Adapter<T> particleRemovalListener = new IBucketSphere.Adapter<T>(){

        @Override
        public void grabbedByUser(T t) {
            assert (SphereBucket.this.containedParticles.contains(t));
            SphereBucket.this.containedParticles.remove(t);
            t.removeListener(this);
            final Vector2D vector2D = t.getDestination();
            t.addPositionListener(new SimpleObserver((IBucketSphere)t){
                final /* synthetic */ IBucketSphere val$particle;
                {
                    this.val$particle = iBucketSphere;
                }

                public void update() {
                    if (vector2D.distance(this.val$particle.getDestination()) > this.val$particle.getRadius() * 1.5) {
                        SphereBucket.this.relayoutBucketParticles();
                        this.val$particle.removePositionListener(this);
                    }
                }
            });
        }
    };

    public SphereBucket(Point2D point2D, Dimension2D dimension2D, Color color, String string, double d, double d2, double d3) {
        super(point2D, dimension2D, color, string);
        this.particleRadius = d;
        this.usableWidthProportion = d2;
        this.yOffset = d3;
    }

    public SphereBucket(Point2D point2D, Dimension2D dimension2D, Color color, String string, double d) {
        this(point2D, dimension2D, color, string, d, 1.0, 0.0);
    }

    public void removeParticle(T t) {
        if (!this.containedParticles.contains(t)) {
            System.err.println(this.getClass().getName() + " - Error: Particle not here, can't remove.");
        }
        assert (this.containedParticles.contains(t));
        this.containedParticles.remove(t);
        t.removeListener(this.particleRemovalListener);
    }

    public void addParticleNearestOpen(T t, boolean bl) {
        Point2D point2D = this.getNearestOpenLocation(t.getPosition());
        this.addParticle(t, point2D, bl);
    }

    public void addParticleFirstOpen(T t, boolean bl) {
        Point2D point2D = this.getFirstOpenLocation();
        this.addParticle(t, point2D, bl);
    }

    private void addParticle(T t, Point2D point2D, boolean bl) {
        if (bl) {
            t.setPositionAndDestination(new Vector2D(point2D));
        } else {
            t.setDestination(new Vector2D(point2D));
        }
        t.addListener(this.particleRemovalListener);
        this.containedParticles.add(t);
    }

    public boolean containsParticle(T t) {
        return this.containedParticles.contains(t);
    }

    public ArrayList<T> getParticleList() {
        return this.containedParticles;
    }

    private Point2D getFirstOpenLocation() {
        Point2D.Double double_ = new Point2D.Double();
        double d = this.holeShape.getBounds2D().getWidth() * this.usableWidthProportion - 2.0 * this.particleRadius;
        double d2 = (this.holeShape.getBounds2D().getWidth() - d) / 2.0 + this.particleRadius;
        int n = (int)Math.floor(d / (this.particleRadius * 2.0));
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (!bl) {
            double d3 = this.getYPositionForLayer(n2);
            double d4 = this.getPosition().getX() - this.holeShape.getBounds2D().getWidth() / 2.0 + d2 + (double)(n3 * 2) * this.particleRadius;
            if (this.isPositionOpen(d4, d3)) {
                ((Point2D)double_).setLocation(d4, d3);
                bl = true;
                continue;
            }
            if (++n3 < n) continue;
            ++n2;
            n3 = 0;
            d2 += this.particleRadius;
            if (--n != 0) continue;
            n = 1;
            d2 -= this.particleRadius;
        }
        return double_;
    }

    private Point2D getNearestOpenLocation(Vector2D vector2D) {
        int n = 0;
        for (IBucketSphere iBucketSphere : this.containedParticles) {
            int n2 = this.getLayerForYPosition(iBucketSphere.getPosition().getY());
            if (n2 <= n) continue;
            n = n2;
        }
        ArrayList arrayList = new ArrayList();
        double d = this.holeShape.getBounds2D().getWidth() * this.usableWidthProportion - 2.0 * this.particleRadius;
        double d2 = (this.holeShape.getBounds2D().getWidth() - d) / 2.0 + this.particleRadius;
        int n3 = (int)Math.floor(d / (this.particleRadius * 2.0));
        for (int i = 0; i <= n + 1; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d3 = this.getYPositionForLayer(i);
                double d4 = this.getPosition().getX() - this.holeShape.getBounds2D().getWidth() / 2.0 + d2 + (double)(j * 2) * this.particleRadius;
                if (!this.isPositionOpen(d4, d3) || i != 0 && this.countSupportingParticles(new Point2D.Double(d4, d3)) != 2) continue;
                arrayList.add(new Point2D.Double(d4, d3));
            }
            d2 += this.particleRadius;
            if (--n3 != 0) continue;
            n3 = 1;
            d2 -= this.particleRadius;
        }
        assert (!arrayList.isEmpty());
        Point2D point2D = (Point2D)arrayList.get(0);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Point2D point2D2 = (Point2D)iterator.next();
            if (!(Math.abs(point2D2.getX() - vector2D.getX()) < Math.abs(point2D.getX() - vector2D.getX()))) continue;
            point2D = point2D2;
        }
        return point2D;
    }

    private int getLayerForYPosition(double d) {
        return (int)Math.round((d - this.getPosition().getY() - this.yOffset) / (this.particleRadius * 2.0 * 0.866));
    }

    private double getYPositionForLayer(int n) {
        return this.getPosition().getY() + (double)n * this.particleRadius * 2.0 * 0.866 + this.yOffset;
    }

    private void relayoutBucketParticles() {
        ArrayList<T> arrayList = new ArrayList<T>(this.containedParticles);
        for (IBucketSphere iBucketSphere : arrayList) {
            if (!this.isDangling(iBucketSphere)) continue;
            this.removeParticle(iBucketSphere);
            this.addParticleNearestOpen(iBucketSphere, false);
            this.relayoutBucketParticles();
        }
    }

    private boolean isDangling(T t) {
        boolean bl = t.getDestination().getY() == this.getYPositionForLayer(0);
        return !bl && this.countSupportingParticles(t) < 2;
    }

    private int countSupportingParticles(T t) {
        int n = 0;
        for (IBucketSphere iBucketSphere : this.containedParticles) {
            if (iBucketSphere == t || !(iBucketSphere.getDestination().getY() < t.getDestination().getY()) || !(iBucketSphere.getDestination().distance(t.getDestination()) < t.getRadius() * 3.0)) continue;
            ++n;
        }
        return n;
    }

    private int countSupportingParticles(Point2D point2D) {
        int n = 0;
        for (IBucketSphere iBucketSphere : this.containedParticles) {
            if (iBucketSphere.getPosition().equals(iBucketSphere) || !(iBucketSphere.getDestination().getY() < point2D.getY()) || !(iBucketSphere.getDestination().distance(point2D) < iBucketSphere.getRadius() * 3.0)) continue;
            ++n;
        }
        return n;
    }

    private boolean isPositionOpen(double d, double d2) {
        boolean bl = true;
        for (IBucketSphere iBucketSphere : this.containedParticles) {
            Vector2D vector2D = iBucketSphere.getDestination();
            if (vector2D.getX() != d || vector2D.getY() != d2) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

