/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.tests;

import edu.colorado.phet.buildamolecule.model.CompleteMolecule;
import edu.colorado.phet.buildamolecule.model.MoleculeList;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MoleculeTableDialog
extends JDialog {
    public MoleculeTableDialog(Frame frame) {
        super(frame, false);
        final ArrayList<CompleteMolecule> arrayList = new ArrayList<CompleteMolecule>(MoleculeList.getMasterInstance().getAllCompleteMolecules());
        Collections.sort(arrayList, new Comparator<CompleteMolecule>(){

            @Override
            public int compare(CompleteMolecule completeMolecule, CompleteMolecule completeMolecule2) {
                int n = Double.compare(completeMolecule.getAtoms().size(), completeMolecule2.getAtoms().size());
                if (n == 0) {
                    return completeMolecule.getGeneralFormula().compareToIgnoreCase(completeMolecule2.getGeneralFormula());
                }
                return n;
            }
        });
        JTable jTable = new JTable(new TableModel(){

            @Override
            public int getRowCount() {
                return arrayList.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Formula";
                    }
                    case 2: {
                        return "Pseudo-3D";
                    }
                    case 3: {
                        return "PubChem CID";
                    }
                }
                throw new RuntimeException("unknown column: " + n);
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 2) {
                    return MoleculeCellRenderer.class;
                }
                return JLabel.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return ((CompleteMolecule)arrayList.get(n)).getDisplayName();
                    }
                    case 1: {
                        return "<html>" + ((CompleteMolecule)arrayList.get(n)).getGeneralFormulaFragment() + "</html>";
                    }
                    case 2: {
                        return arrayList.get(n);
                    }
                    case 3: {
                        return String.valueOf(((CompleteMolecule)arrayList.get((int)n)).cid);
                    }
                }
                throw new RuntimeException("unknown column: " + n2);
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
            }

            @Override
            public void addTableModelListener(TableModelListener tableModelListener) {
            }

            @Override
            public void removeTableModelListener(TableModelListener tableModelListener) {
            }
        }){
            {
                this.setRowHeight(75);
            }
        };
        jTable.getColumnModel().getColumn(2).setCellRenderer(new MoleculeCellRenderer());
        this.setContentPane(new JScrollPane(jTable));
        this.pack();
        this.setSize(new Dimension(800, 600));
        SwingUtils.centerInParent(this);
    }

    private static class MoleculeCellRenderer
    extends PhetPCanvas
    implements TableCellRenderer {
        private PNode node = null;

        private MoleculeCellRenderer() {
            this.setBorder(null);
            this.setBackground(new JPanel().getBackground());
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.node != null) {
                this.removeScreenChild(this.node);
            }
            this.node = ((CompleteMolecule)object).createPseudo3DNode();
            Dimension dimension = new Dimension((int)this.node.getFullBounds().getWidth() + 1, (int)this.node.getFullBounds().getHeight() + 1);
            this.setPreferredSize(dimension);
            this.node.centerFullBoundsOnPoint(dimension.getWidth() / 2.0, dimension.getHeight() / 2.0);
            this.addScreenChild(this.node);
            this.paintImmediately();
            return this;
        }
    }
}

