/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.buildamolecule.model;

import edu.colorado.phet.chemistry.model.Atom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bond<T extends Atom> {
    public T a;
    public T b;

    public Bond(T t, T t2) {
        this.a = t;
        this.b = t2;
        assert (t != t2);
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Bond) {
            Bond bond = (Bond)object;
            return this.a == bond.a && this.b == bond.b || this.a == bond.b && this.b == bond.a;
        }
        return false;
    }

    public boolean contains(T t) {
        return t == this.a || t == this.b;
    }

    public T getOtherAtom(T t) {
        assert (this.contains(t));
        return this.a == t ? this.b : this.a;
    }

    public String toSerial2(int n) {
        return String.valueOf(n);
    }
}

