/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.view;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.enums.BSBottomPlotMode;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSEigenstate;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import edu.colorado.phet.boundstates.view.BSEnergyPlot;
import edu.colorado.phet.common.piccolophet.event.ConstrainedDragHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class BSMagnifyingGlass
extends PNode
implements Observer,
PlotChangeListener {
    private Color LENS_COLOR = new Color(0, 0, 0, 0);
    private double _magnification = 10.0;
    private BSModel _model;
    private BSCombinedChartNode _chartNode;
    private PComposite _partsNode;
    private PPath _lensNode;
    private PPath _bezelNode;
    private PPath _handleNode;
    private PComposite _viewNode;
    private ClippedPath _chartBackgroundNode;
    private ClippedPath _chartEdgeNode;
    private ClippedPath _potentialNode;
    private PComposite _eigenstatesParentNode;
    private BSColorScheme _colorScheme;
    private MagnifyingGlassEventHandler _eventHandler;
    private boolean _bandSelectionEnabled;

    public BSMagnifyingGlass(BSCombinedChartNode bSCombinedChartNode, BSColorScheme bSColorScheme) {
        this._chartNode = bSCombinedChartNode;
        this._bandSelectionEnabled = false;
        this.initNodes();
        this.initEventHandling();
        this.setColorScheme(bSColorScheme);
    }

    private void initNodes() {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-50.0, -50.0, 100.0, 100.0);
        this._lensNode = new PPath();
        this._lensNode.setPathTo(double_);
        this._lensNode.setPaint(this.LENS_COLOR);
        this._lensNode.setStrokePaint(this.LENS_COLOR);
        Cloneable cloneable = new Ellipse2D.Double(-58.0, -58.0, 116.0, 116.0);
        Shape shape = new Area((Shape)((Object)cloneable));
        Area area = new Area(double_);
        shape.exclusiveOr(area);
        this._bezelNode = new PPath();
        this._bezelNode.setPathTo(shape);
        cloneable = new RoundRectangle2D.Double(-8.0, 50.0, 16.0, 65.0, 10.0, 10.0);
        this._handleNode = new PPath();
        this._handleNode.setPathTo((Shape)((Object)cloneable));
        this._handleNode.rotate(Math.toRadians(-20.0));
        cloneable = new PPath();
        this._partsNode = new PComposite();
        this._partsNode.addChild(this._handleNode);
        this._partsNode.addChild(this._bezelNode);
        this._partsNode.addChild((PNode)cloneable);
        this._partsNode.addChild(this._lensNode);
        this._chartBackgroundNode = new ClippedPath();
        shape = new Rectangle2D.Double(-50.0, -50.0, 100.0, 100.0);
        this._chartBackgroundNode.setPathTo(shape);
        this._chartEdgeNode = new ClippedPath();
        this._chartEdgeNode.setPaint(BSConstants.CANVAS_BACKGROUND);
        this._potentialNode = new ClippedPath();
        this._potentialNode.setStroke(BSConstants.POTENTIAL_ENERGY_STROKE);
        this._eigenstatesParentNode = new PComposite();
        this._viewNode = new PComposite();
        this._viewNode.addChild(this._chartBackgroundNode);
        this._viewNode.addChild(this._potentialNode);
        this._viewNode.addChild(this._eigenstatesParentNode);
        this._viewNode.addChild(this._chartEdgeNode);
        this.setPickable(false);
        this._viewNode.setPickable(false);
        this._viewNode.setChildrenPickable(false);
        this._partsNode.setPickable(true);
        this._partsNode.setChildrenPickable(true);
        this.addChild(this._viewNode);
        this.addChild(this._partsNode);
    }

    private void initEventHandling() {
        this._partsNode.addInputEventListener(new CursorHandler());
        this._eventHandler = new MagnifyingGlassEventHandler();
        this._partsNode.addInputEventListener(this._eventHandler);
        this._eventHandler.setTreatAsPointEnabled(true);
        this._eventHandler.setNodeCenter(58.0, 58.0);
        BSEnergyPlot bSEnergyPlot = this._chartNode.getCombinedChart().getEnergyPlot();
        bSEnergyPlot.addChangeListener(this);
    }

    public void setMagnification(double d) {
        if (d < 1.0) {
            throw new IllegalArgumentException("magnification must be >= 1");
        }
        this._magnification = d;
        this.updateDisplay();
    }

    private boolean isInitialized() {
        return this._model != null;
    }

    public void setModel(BSModel bSModel) {
        if (this._model != null) {
            this._model.deleteObserver(this);
        }
        this._model = bSModel;
        this._model.addObserver(this);
        this.updateDisplay();
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this._colorScheme = bSColorScheme;
        this._chartBackgroundNode.setPaint(this._colorScheme.getChartColor());
        this._bezelNode.setPaint(this._colorScheme.getMagnifyingGlassBezelColor());
        this._handleNode.setPaint(this._colorScheme.getMagnifyingGlassHandleColor());
        this._potentialNode.setStrokePaint(this._colorScheme.getPotentialEnergyColor());
        this.updateDisplay();
    }

    public void setDragBounds(Rectangle2D rectangle2D) {
        double d = rectangle2D.getX() + 58.0;
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth() - 116.0;
        double d4 = rectangle2D.getHeight();
        this._eventHandler.setDragBounds(d, d2, d3, d4);
        this.updateDisplay();
    }

    public PNode getPartsNode() {
        return this._partsNode;
    }

    public void setMode(BSBottomPlotMode bSBottomPlotMode) {
        this._bandSelectionEnabled = bSBottomPlotMode == BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this._partsNode.setPickable(bl);
        this._partsNode.setChildrenPickable(bl);
        if (bl) {
            this.updateDisplay();
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        this._partsNode.setTransform(affineTransform);
        this._viewNode.setTransform(affineTransform);
    }

    public void setOffset(double d, double d2) {
        throw new UnsupportedOperationException("use setTransform");
    }

    public void setOffset(Point2D point2D) {
        throw new UnsupportedOperationException("use setTransform");
    }

    public void update(Observable observable, Object object) {
        if (object != "particle") {
            this.updateDisplay();
        }
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.updateDisplay();
    }

    public void updateDisplay() {
        double d;
        if (!this.getVisible() || !this.isInitialized()) {
            return;
        }
        Point2D point2D = this.getLensCenter();
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            return;
        }
        Point2D point2D2 = this._lensNode.localToGlobal(new Point2D.Double(-50.0, 50.0));
        Point2D point2D3 = this._chartNode.globalToLocal(point2D2);
        Point2D point2D4 = this._chartNode.nodeToEnergy(point2D3);
        double d4 = point2D4.getX();
        double d5 = point2D4.getY();
        double d6 = d2 + (d2 - d4);
        double d7 = d3 + (d3 - d5);
        double d8 = d2 - (d2 - d4) / this._magnification;
        double d9 = d2 + (d6 - d2) / this._magnification;
        double d10 = d3 - (d3 - d5) / this._magnification;
        double d11 = d3 + (d7 - d3) / this._magnification;
        double d12 = (d9 - d8) / 100.0;
        double d13 = (d11 - d10) / 100.0;
        BSEigenstate[] bSEigenstateArray = this._model.getEigenstates();
        BSSuperpositionCoefficients bSSuperpositionCoefficients = this._model.getSuperpositionCoefficients();
        this._eigenstatesParentNode.removeAllChildren();
        for (int i = 0; i < bSEigenstateArray.length; ++i) {
            double d14 = bSEigenstateArray[i].getEnergy();
            if (!(d14 >= d10) || !(d14 <= d11)) continue;
            d = (d3 - d14) / d13;
            ClippedPath clippedPath = new ClippedPath();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-50.0f, (float)d);
            generalPath.lineTo(50.0f, (float)d);
            clippedPath.setPathTo(generalPath);
            this._eigenstatesParentNode.addChild(clippedPath);
            Stroke stroke = null;
            Color color = null;
            if (i == this._model.getHilitedEigenstateIndex()) {
                stroke = BSConstants.EIGENSTATE_HILITE_STROKE;
                color = this._colorScheme.getEigenstateHiliteColor();
                clippedPath.moveToFront();
            } else if (bSSuperpositionCoefficients.getCoefficient(i) != 0.0) {
                stroke = BSConstants.EIGENSTATE_SELECTION_STROKE;
                color = this._colorScheme.getEigenstateSelectionColor();
                clippedPath.moveToBack();
            } else {
                stroke = BSConstants.EIGENSTATE_NORMAL_STROKE;
                color = this._colorScheme.getEigenstateNormalColor();
                clippedPath.moveToBack();
            }
            clippedPath.setStroke(stroke);
            clippedPath.setStrokePaint(color);
        }
        Observer observer = this._model.getPotential();
        Cloneable cloneable = new GeneralPath();
        for (double d15 = d8; d15 <= d9; d15 += d12) {
            double d16 = ((BSAbstractPotential)observer).getEnergyAt(d15);
            double d17 = (d15 - d2) / d12;
            double d18 = (d3 - d16) / d13;
            if (d18 > 2000.0) {
                d18 = 2000.0;
            } else if (d18 < -2000.0) {
                d18 = -2000.0;
            }
            if (d15 == d8) {
                ((Path2D.Float)cloneable).moveTo((float)d17, (float)d18);
                continue;
            }
            ((Path2D.Float)cloneable).lineTo((float)d17, (float)d18);
        }
        this._potentialNode.setPathTo((Shape)((Object)cloneable));
        observer = this._chartNode.getCombinedChart().getEnergyPlot();
        cloneable = ((XYPlot)((Object)observer)).getRangeAxis();
        Range range = ((ValueAxis)cloneable).getRange();
        d = range.getLowerBound();
        double d19 = range.getUpperBound();
        double d20 = 100.0;
        double d21 = 100.0;
        double d22 = 1.0;
        double d23 = 1.0;
        if (d11 > d19) {
            d20 = -50.0;
            d22 = 100.0;
            d23 = Math.abs(100.0 * (d11 - d19) / (d11 - d10));
            d21 = -50.0;
        } else if (d10 < d) {
            d20 = -50.0;
            d22 = 100.0;
            d23 = Math.abs(100.0 * (d10 - d) / (d11 - d10));
            d21 = 50.0 - d23;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d20, d21, d22, d23);
        this._chartEdgeNode.setPathTo(double_);
    }

    private void selectEigenstate(Point2D point2D) {
        int n = this._model.getHilitedEigenstateIndex();
        if (n != -1) {
            if (!this._bandSelectionEnabled) {
                this._model.getSuperpositionCoefficients().setOneCoefficient(n);
            } else {
                int n2;
                int n3 = n2 = this._model.getPotential().getNumberOfWells();
                int n4 = n / n3;
                this._model.getSuperpositionCoefficients().setBandCoefficients(n4, n3, 1.0);
            }
            this._model.setHilitedEigenstateIndex(-1);
        }
    }

    private void hiliteEigenstate(Point2D point2D) {
        double d;
        double d2;
        Point2D point2D2;
        Point2D point2D3;
        double d3;
        double d4 = this.getLensCenter().getY();
        double d5 = d4 + ((d3 = (point2D3 = this._chartNode.nodeToEnergy(point2D2 = this._chartNode.globalToLocal(point2D))).getY()) - d4) / this._magnification;
        int n = this._model.getClosestEigenstateIndex(d5, d2 = 1.0 / this._magnification);
        if (n != -1 && !this.isInLens(d = this._model.getEigenstate(n).getEnergy())) {
            n = -1;
        }
        this._model.setHilitedEigenstateIndex(n);
    }

    private Point2D getLensCenter() {
        Point2D point2D = this._lensNode.localToGlobal(new Point2D.Double(0.0, 0.0));
        Point2D point2D2 = this._chartNode.globalToLocal(point2D);
        Point2D point2D3 = this._chartNode.nodeToEnergy(point2D2);
        return point2D3;
    }

    private boolean isInLens(Point2D point2D) {
        Rectangle2D rectangle2D = this._partsNode.localToGlobal(this._lensNode.getFullBounds());
        return rectangle2D.contains(point2D);
    }

    private boolean isInLens(double d) {
        Point2D point2D = this.getLensCenter();
        double d2 = point2D.getY();
        Point2D point2D2 = this._lensNode.localToGlobal(new Point2D.Double(-50.0, 50.0));
        Point2D point2D3 = this._chartNode.globalToLocal(point2D2);
        Point2D point2D4 = this._chartNode.nodeToEnergy(point2D3);
        double d3 = point2D4.getY();
        double d4 = d2 + (d2 - d3);
        double d5 = d2 - (d2 - d3) / this._magnification;
        double d6 = d2 + (d4 - d2) / this._magnification;
        return d <= d6 && d >= d5;
    }

    private class ClippedPath
    extends PPath {
        protected void paint(PPaintContext pPaintContext) {
            GeneralPath generalPath = BSMagnifyingGlass.this._lensNode.getPathReference();
            pPaintContext.pushClip(generalPath);
            super.paint(pPaintContext);
            pPaintContext.popClip(generalPath);
        }
    }

    private class MagnifyingGlassEventHandler
    extends ConstrainedDragHandler {
        private boolean _dragging = false;

        public void mouseMoved(PInputEvent pInputEvent) {
            super.mouseMoved(pInputEvent);
            if (!this._dragging) {
                if (BSMagnifyingGlass.this.isInLens(pInputEvent.getPosition())) {
                    BSMagnifyingGlass.this.hiliteEigenstate(pInputEvent.getPosition());
                } else {
                    BSMagnifyingGlass.this._model.setHilitedEigenstateIndex(-1);
                }
            }
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            super.mouseReleased(pInputEvent);
            if (!this._dragging && BSMagnifyingGlass.this.isInLens(pInputEvent.getPosition())) {
                BSMagnifyingGlass.this.selectEigenstate(pInputEvent.getPosition());
            }
            this._dragging = false;
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            this._dragging = true;
            super.mouseDragged(pInputEvent);
            BSMagnifyingGlass.this.updateDisplay();
            BSMagnifyingGlass.this._viewNode.setOffset(BSMagnifyingGlass.this._partsNode.getOffset());
            BSMagnifyingGlass.this.setFullBoundsInvalid(true);
        }

        public void mouseExited(PInputEvent pInputEvent) {
            BSMagnifyingGlass.this._model.setHilitedEigenstateIndex(-1);
        }
    }
}

