/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.module;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.control.BSClockControls;
import edu.colorado.phet.boundstates.control.BSControlPanel;
import edu.colorado.phet.boundstates.control.ZoomControl;
import edu.colorado.phet.boundstates.dialog.BSConfigureDialogFactory;
import edu.colorado.phet.boundstates.dialog.BSSuperpositionStateDialog;
import edu.colorado.phet.boundstates.draghandles.BSAbstractDragManager;
import edu.colorado.phet.boundstates.draghandles.BSAsymmetricDragManager;
import edu.colorado.phet.boundstates.draghandles.BSCoulomb1DDragManager;
import edu.colorado.phet.boundstates.draghandles.BSCoulomb3DDragManager;
import edu.colorado.phet.boundstates.draghandles.BSHarmonicOscillatorDragManager;
import edu.colorado.phet.boundstates.draghandles.BSSquareDragManager;
import edu.colorado.phet.boundstates.enums.BSBottomPlotMode;
import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.model.BSAbstractPotential;
import edu.colorado.phet.boundstates.model.BSAsymmetricPotential;
import edu.colorado.phet.boundstates.model.BSClock;
import edu.colorado.phet.boundstates.model.BSCoulomb1DPotential;
import edu.colorado.phet.boundstates.model.BSCoulomb3DPotential;
import edu.colorado.phet.boundstates.model.BSHarmonicOscillatorPotential;
import edu.colorado.phet.boundstates.model.BSModel;
import edu.colorado.phet.boundstates.model.BSParticle;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.model.BSSuperpositionCoefficients;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.persistence.BSModuleConfig;
import edu.colorado.phet.boundstates.view.BSBottomPlot;
import edu.colorado.phet.boundstates.view.BSCombinedChart;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import edu.colorado.phet.boundstates.view.BSEigenstatesNode;
import edu.colorado.phet.boundstates.view.BSEnergyLegend;
import edu.colorado.phet.boundstates.view.BSEnergyPlot;
import edu.colorado.phet.boundstates.view.BSHilitedEquation;
import edu.colorado.phet.boundstates.view.BSMagnifyingGlass;
import edu.colorado.phet.boundstates.view.BSSelectedEquation;
import edu.colorado.phet.common.jfreechartphet.piccolo.XYPlotNode;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.common.piccolophet.help.DefaultWiggleMe;
import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.colorado.phet.common.piccolophet.help.HelpPane;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public abstract class BSAbstractModule
extends PiccoloModule
implements Observer {
    private static final Dimension CANVAS_RENDERING_SIZE = new Dimension(1000, 1000);
    private BSModel _model;
    private BSParticle _particle;
    private BSSuperpositionCoefficients _superpositionCoefficients;
    private BSAsymmetricPotential _asymmetricPotential;
    private BSCoulomb1DPotential _coulomb1DPotential;
    private BSCoulomb3DPotential _coulomb3DPotential;
    private BSHarmonicOscillatorPotential _harmonicOscillatorPotential;
    private BSSquarePotential _squarePotential;
    private PhetPCanvas _canvas;
    private Dimension _initialCanvasSize;
    private Dimension _previousCanvasSize;
    private PNode _parentNode;
    private BSEnergyLegend _legend;
    private BSCombinedChart _chart;
    private BSCombinedChartNode _chartNode;
    private BSEigenstatesNode _eigenstatesNode;
    private BSSelectedEquation _selectedEquationNode;
    private BSHilitedEquation _hilitedEquationNode;
    private BSMagnifyingGlass _magnifyingGlass;
    private BSEnergyPlot _energyPlot;
    private BSBottomPlot _bottomPlot;
    private XYPlotNode _energyPlotNode;
    private XYPlotNode _bottomPlotNode;
    private BSControlPanel _controlPanel;
    private BSClockControls _clockControls;
    private ZoomControl _energyZoomControl;
    private PSwing _energyZoomControlNode;
    private BSAsymmetricDragManager _asymmetricDragManager;
    private BSCoulomb1DDragManager _coulomb1DDragManager;
    private BSCoulomb3DDragManager _coulomb3DDragManager;
    private BSHarmonicOscillatorDragManager _harmonicOscillatorDragManager;
    private BSSquareDragManager _squareDragManager;
    private DefaultWiggleMe _wiggleMe;
    private boolean _hasWiggleMe;
    private HelpBalloon _dragHandleHelp;
    private JDialog _configureDialog;
    private BSSuperpositionStateDialog _superpositionStateDialog;
    private BSColorScheme _colorScheme;
    private BSAbstractModuleSpec _moduleSpec;
    private Point _configDialogLocation;
    private Point _superpositionStateDialogLocation;

    public BSAbstractModule(String string, BSAbstractModuleSpec bSAbstractModuleSpec) {
        super(string, new BSClock(), false);
        if (bSAbstractModuleSpec.isSuperpositionControlsSupported() && bSAbstractModuleSpec.isAverageProbabilityDensitySupported()) {
            throw new UnsupportedOperationException("Superposition State and Average Probability Density features are mututally exclusive. See the Javadoc for BSEigenstatesNode.setMode for details.");
        }
        this._moduleSpec = bSAbstractModuleSpec;
        this._colorScheme = BSConstants.COLOR_SCHEME;
        this.setLogoPanel(null);
        EventListener eventListener = new EventListener();
        this._canvas = new PhetPCanvas(CANVAS_RENDERING_SIZE);
        this._canvas.setBackground(BSConstants.CANVAS_BACKGROUND);
        this.setSimulationPanel(this._canvas);
        this._previousCanvasSize = new Dimension();
        this._parentNode = new PNode();
        this._canvas.addScreenChild(this._parentNode);
        this._chart = new BSCombinedChart();
        this._chart.setBackgroundPaint(BSConstants.CANVAS_BACKGROUND);
        this._chartNode = new BSCombinedChartNode(this._chart);
        this._chartNode.setPickable(false);
        this._chartNode.setChildrenPickable(false);
        this._parentNode.addChild(this._chartNode);
        this._legend = new BSEnergyLegend();
        this._parentNode.addChild(this._legend);
        this._chartNode.setBuffered(true);
        this._energyPlot = new BSEnergyPlot();
        this._bottomPlot = new BSBottomPlot();
        Object object = this._chart.getRenderingHints();
        this._energyPlotNode = new XYPlotNode(this._energyPlot);
        this._energyPlotNode.setRenderingHints((RenderingHints)object);
        this._energyPlotNode.setPickable(false);
        this._energyPlotNode.setChildrenPickable(false);
        this._energyPlotNode.setName("energyPlotNode");
        this._parentNode.addChild(this._energyPlotNode);
        this._bottomPlotNode = new XYPlotNode(this._bottomPlot);
        this._bottomPlotNode.setRenderingHints((RenderingHints)object);
        this._bottomPlotNode.setPickable(false);
        this._bottomPlotNode.setChildrenPickable(false);
        this._bottomPlotNode.setName("bottomPlotNode");
        this._parentNode.addChild(this._bottomPlotNode);
        this._eigenstatesNode = new BSEigenstatesNode(this._chartNode, this._canvas);
        this._parentNode.addChild(this._eigenstatesNode);
        this._selectedEquationNode = new BSSelectedEquation();
        this._parentNode.addChild(this._selectedEquationNode);
        this._hilitedEquationNode = new BSHilitedEquation();
        this._parentNode.addChild(this._hilitedEquationNode);
        this._asymmetricDragManager = new BSAsymmetricDragManager(this._moduleSpec, this._chartNode);
        this._coulomb1DDragManager = new BSCoulomb1DDragManager(this._moduleSpec, this._chartNode);
        this._coulomb3DDragManager = new BSCoulomb3DDragManager(this._moduleSpec, this._chartNode);
        this._harmonicOscillatorDragManager = new BSHarmonicOscillatorDragManager(this._moduleSpec, this._chartNode);
        this._squareDragManager = new BSSquareDragManager(this._moduleSpec, this._chartNode);
        this._parentNode.addChild(this._asymmetricDragManager);
        this._parentNode.addChild(this._coulomb1DDragManager);
        this._parentNode.addChild(this._coulomb3DDragManager);
        this._parentNode.addChild(this._harmonicOscillatorDragManager);
        this._parentNode.addChild(this._squareDragManager);
        object = new PBasicInputEventHandler(){
            private boolean _clockIsRunning = false;

            public void mousePressed(PInputEvent pInputEvent) {
                this._clockIsRunning = BSAbstractModule.this.getClock().isRunning();
                if (this._clockIsRunning) {
                    BSAbstractModule.this.getClock().pause();
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                if (this._clockIsRunning) {
                    BSAbstractModule.this.getClock().start();
                }
            }
        };
        this._asymmetricDragManager.addInputEventListener((PInputEventListener)object);
        this._coulomb1DDragManager.addInputEventListener((PInputEventListener)object);
        this._coulomb3DDragManager.addInputEventListener((PInputEventListener)object);
        this._harmonicOscillatorDragManager.addInputEventListener((PInputEventListener)object);
        this._squareDragManager.addInputEventListener((PInputEventListener)object);
        this._energyZoomControl = new ZoomControl(1);
        this._energyZoomControl.addPlot(this._chart.getEnergyPlot());
        this._energyZoomControl.addPlot(this._energyPlot);
        this._energyZoomControlNode = new PSwing(this._energyZoomControl){

            public void setVisible(boolean bl) {
                super.setVisible(bl);
                this.setPickable(bl);
                this.setChildrenPickable(bl);
            }
        };
        this._parentNode.addChild(this._energyZoomControlNode);
        if (this._moduleSpec.isMagnifyingGlassSupported()) {
            this._magnifyingGlass = new BSMagnifyingGlass(this._chartNode, BSConstants.COLOR_SCHEME);
            this._magnifyingGlass.setMagnification(this._moduleSpec.getMagnification());
            this._parentNode.addChild(this._magnifyingGlass);
        }
        this.getClock().addClockListener(this._bottomPlot);
        this._controlPanel = new BSControlPanel(this, bSAbstractModuleSpec);
        this.setControlPanel(this._controlPanel);
        this._clockControls = new BSClockControls((BSClock)this.getClock());
        this.setClockControlPanel(this._clockControls);
        this.addClockListener(new ClockAdapter(){

            public void simulationTimeReset(ClockEvent clockEvent) {
                BSAbstractModule.this.handleClockReset();
            }
        });
        if (this.hasHelp()) {
            HelpBalloon helpBalloon;
            object = this.getDefaultHelpPane();
            HelpBalloon helpBalloon2 = new HelpBalloon((JComponent)object, BSResources.getString("help.restart"), HelpBalloon.BOTTOM_LEFT, 80.0);
            ((HelpPane)object).add(helpBalloon2);
            helpBalloon2.pointAt(this._clockControls.getRewindButton(), this._clockControls.getButtonCanvas());
            HelpBalloon helpBalloon3 = new HelpBalloon((JComponent)object, BSResources.getString("help.clockSpeed"), HelpBalloon.BOTTOM_RIGHT, 80.0);
            ((HelpPane)object).add(helpBalloon3);
            helpBalloon3.pointAt(this._clockControls.getClockIndexComponent());
            if (this._magnifyingGlass != null) {
                helpBalloon = new HelpBalloon((JComponent)object, BSResources.getString("help.magnifyingGlass"), HelpBalloon.RIGHT_CENTER, 20.0);
                ((HelpPane)object).add(helpBalloon);
                helpBalloon.pointAt(this._magnifyingGlass.getPartsNode(), this._canvas);
            }
            helpBalloon = new HelpBalloon((JComponent)object, BSResources.getString("help.zoom"), HelpBalloon.RIGHT_CENTER, 20.0);
            ((HelpPane)object).add(helpBalloon);
            helpBalloon.pointAt(this._energyZoomControlNode, this._canvas);
            this._dragHandleHelp = new HelpBalloon((JComponent)object, BSResources.getString("help.dragHandle"), HelpBalloon.RIGHT_CENTER, 20.0);
            ((HelpPane)object).add(this._dragHandleHelp);
        }
        this.reset();
        this.layoutCanvas();
        this._canvas.addComponentListener(eventListener);
    }

    private void layoutCanvas() {
        Dimension dimension = this._canvas.getSize();
        if (dimension.getWidth() <= 0.0 || dimension.getHeight() <= 0.0) {
            return;
        }
        if (this._initialCanvasSize == null) {
            this._initialCanvasSize = dimension;
        }
        if (dimension.equals(this._previousCanvasSize)) {
            return;
        }
        this._previousCanvasSize.setSize(dimension);
        double d = this._legend.getFullBounds().getHeight();
        double d2 = dimension.getWidth() - 20.0;
        double d3 = dimension.getHeight() - (d + 20.0 + 10.0);
        this._chartNode.setBounds(0.0, 0.0, d2, d3);
        Cloneable cloneable = new AffineTransform();
        ((AffineTransform)cloneable).translate(10.0, 10.0 + d + 10.0);
        ((AffineTransform)cloneable).translate(0.0, 0.0);
        this._chartNode.setTransform((AffineTransform)cloneable);
        this._chartNode.updateChartRenderingInfo();
        this._eigenstatesNode.setTransform((AffineTransform)cloneable);
        this._eigenstatesNode.setBounds(this._chartNode.getEnergyPlotBounds());
        cloneable = this._chartNode.localToGlobal(this._chartNode.getEnergyPlotBounds());
        Rectangle2D rectangle2D = this._chartNode.localToGlobal(this._chartNode.getBottomPlotBounds());
        if (this._energyPlotNode != null) {
            this._energyPlotNode.setOffset(0.0, 0.0);
            this._energyPlotNode.setDataArea((Rectangle2D)cloneable);
        }
        if (this._bottomPlotNode != null) {
            this._bottomPlotNode.setOffset(0.0, 0.0);
            this._bottomPlotNode.setDataArea(rectangle2D);
        }
        Cloneable cloneable2 = this._chartNode.nodeToEnergy(new Point2D.Double(0.0, 0.0));
        Point2D point2D = this._chartNode.nodeToEnergy(new Point2D.Double(1.0, 0.0));
        double d4 = point2D.getX() - ((Point2D)cloneable2).getX();
        if (d4 >= Double.MIN_VALUE && d4 <= Double.MAX_VALUE) {
            this._energyPlot.setDx(d4);
        }
        cloneable2 = new AffineTransform();
        ((AffineTransform)cloneable2).translate(((RectangularShape)cloneable).getX(), 10.0);
        ((AffineTransform)cloneable2).translate(0.0, 0.0);
        this._legend.setTransform((AffineTransform)cloneable2);
        double d5 = rectangle2D.getX() + rectangle2D.getWidth() - 5.0;
        d4 = rectangle2D.getY() + 2.0;
        this._selectedEquationNode.setLocation(d5, d4);
        double d6 = d5;
        double d7 = rectangle2D.getY() + this._selectedEquationNode.getFullBounds().getHeight();
        this._hilitedEquationNode.setLocation(d6, d7);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(((RectangularShape)cloneable).getX() + ((RectangularShape)cloneable).getWidth() - 3.0, ((RectangularShape)cloneable).getY() + ((RectangularShape)cloneable).getHeight() - 3.0);
        affineTransform.translate(-this._energyZoomControlNode.getWidth() * 0.75, -this._energyZoomControlNode.getHeight() * 0.75);
        affineTransform.scale(0.75, 0.75);
        this._energyZoomControlNode.setTransform(affineTransform);
        if (this._magnifyingGlass != null) {
            AffineTransform affineTransform2 = new AffineTransform();
            this._magnifyingGlass.setDragBounds((Rectangle2D)cloneable);
            double d8 = ((RectangularShape)cloneable).getCenterX();
            double d9 = ((RectangularShape)cloneable).getY() + ((RectangularShape)cloneable).getHeight() - 22.0;
            affineTransform2.translate(d8, d9);
            this._magnifyingGlass.setTransform(affineTransform2);
            this._magnifyingGlass.updateDisplay();
        }
        this._asymmetricDragManager.updateLayout();
        this._coulomb1DDragManager.updateLayout();
        this._coulomb3DDragManager.updateLayout();
        this._harmonicOscillatorDragManager.updateLayout();
        this._squareDragManager.updateLayout();
    }

    public boolean hasHelp() {
        return true;
    }

    public void activate() {
        super.activate();
        if (this._hasWiggleMe) {
            this.addWiggleMe();
        }
    }

    public void deactivate() {
        if (this._configureDialog != null) {
            this._configureDialog.dispose();
        }
        if (this._superpositionStateDialog != null) {
            this._superpositionStateDialog.dispose();
        }
        super.deactivate();
    }

    public void update(Observable observable, Object object) {
        if (observable == this._model && object != "hilitedEnergy") {
            this.resetClock();
            this.disableWiggleMe();
        }
    }

    public void reset() {
        this.closeAllDialogs();
        BSAbstractDragManager bSAbstractDragManager = null;
        double d = this._moduleSpec.getMassMultiplierRange().getDefault();
        double d2 = 5.68 * d;
        this._particle = new BSParticle(d2);
        this._superpositionCoefficients = new BSSuperpositionCoefficients();
        int n = this._moduleSpec.getNumberOfWellsRange().getDefault();
        BSPotentialSpec bSPotentialSpec = null;
        bSPotentialSpec = this._moduleSpec.getAsymmetricSpec();
        if (bSPotentialSpec != null) {
            this._asymmetricPotential = new BSAsymmetricPotential(this._particle, bSPotentialSpec.getOffsetRange().getDefault(), bSPotentialSpec.getHeightRange().getDefault(), bSPotentialSpec.getWidthRange().getDefault());
        }
        if ((bSPotentialSpec = this._moduleSpec.getCoulomb1DSpec()) != null) {
            this._coulomb1DPotential = new BSCoulomb1DPotential(this._particle, n, bSPotentialSpec.getOffsetRange().getDefault(), bSPotentialSpec.getSpacingRange().getDefault());
        }
        if ((bSPotentialSpec = this._moduleSpec.getCoulomb3DSpec()) != null) {
            this._coulomb3DPotential = new BSCoulomb3DPotential(this._particle, bSPotentialSpec.getOffsetRange().getDefault());
        }
        if ((bSPotentialSpec = this._moduleSpec.getHarmonicOscillatorSpec()) != null) {
            this._harmonicOscillatorPotential = new BSHarmonicOscillatorPotential(this._particle, bSPotentialSpec.getOffsetRange().getDefault(), bSPotentialSpec.getAngularFrequencyRange().getDefault());
        }
        if ((bSPotentialSpec = this._moduleSpec.getSquareSpec()) != null) {
            this._squarePotential = new BSSquarePotential(this._particle, n, bSPotentialSpec.getOffsetRange().getDefault(), bSPotentialSpec.getHeightRange().getDefault(), bSPotentialSpec.getWidthRange().getDefault(), bSPotentialSpec.getSeparationRange().getDefault());
        }
        BSAbstractPotential bSAbstractPotential = null;
        BSWellType bSWellType = this._moduleSpec.getDefaultWellType();
        if (bSWellType == BSWellType.ASYMMETRIC) {
            bSAbstractPotential = this._asymmetricPotential;
            bSAbstractDragManager = this._asymmetricDragManager;
        } else if (bSWellType == BSWellType.COULOMB_1D) {
            bSAbstractPotential = this._coulomb1DPotential;
            bSAbstractDragManager = this._coulomb1DDragManager;
        } else if (bSWellType == BSWellType.COULOMB_3D) {
            bSAbstractPotential = this._coulomb3DPotential;
            bSAbstractDragManager = this._coulomb3DDragManager;
        } else if (bSWellType == BSWellType.HARMONIC_OSCILLATOR) {
            bSAbstractPotential = this._harmonicOscillatorPotential;
            bSAbstractDragManager = this._harmonicOscillatorDragManager;
        } else if (bSWellType == BSWellType.SQUARE) {
            bSAbstractPotential = this._squarePotential;
            bSAbstractDragManager = this._squareDragManager;
        } else {
            throw new UnsupportedOperationException("unsupported well type: " + bSWellType);
        }
        assert (bSAbstractPotential != null);
        assert (bSAbstractDragManager != null);
        if (this._model != null) {
            this._model.deleteObserver(this);
        }
        this._model = new BSModel(this._particle, bSAbstractPotential, this._superpositionCoefficients);
        this._model.addObserver(this);
        this._energyPlot.setModel(this._model);
        this._bottomPlot.setModel(this._model);
        this._eigenstatesNode.setModel(this._model);
        this._selectedEquationNode.setModel(this._model);
        this._hilitedEquationNode.setModel(this._model);
        if (this._magnifyingGlass != null) {
            this._magnifyingGlass.setModel(this._model);
        }
        this.configureZoomControls(this._model.getWellType());
        this._controlPanel.setWellType(this._model.getWellType());
        this._controlPanel.setNumberOfWellsControlVisible(this._model.getPotential().supportsMultipleWells());
        this._controlPanel.setNumberOfWells(this._model.getNumberOfWells());
        this._controlPanel.setMagnifyingGlassSelected(this._moduleSpec.isMagnifyingGlassSelected());
        this._controlPanel.setRealSelected(true);
        this._controlPanel.setImaginarySelected(false);
        this._controlPanel.setMagnitudeSelected(false);
        this._controlPanel.setPhaseSelected(false);
        this._controlPanel.setBottomPlotMode(BSBottomPlotMode.PROBABILITY_DENSITY);
        this._controlPanel.setParticleMass(this._particle.getMass());
        this._controlPanel.setMagnification(this._moduleSpec.getMagnification());
        this._controlPanel.setFieldConstant(this._moduleSpec.getFieldConstantRange().getDefault());
        this._asymmetricDragManager.setPotential(this._asymmetricPotential);
        this._asymmetricDragManager.setColorScheme(this._colorScheme);
        this._coulomb1DDragManager.setPotential(this._coulomb1DPotential);
        this._coulomb1DDragManager.setColorScheme(this._colorScheme);
        this._coulomb3DDragManager.setPotential(this._coulomb3DPotential);
        this._coulomb3DDragManager.setColorScheme(this._colorScheme);
        this._harmonicOscillatorDragManager.setPotential(this._harmonicOscillatorPotential);
        this._harmonicOscillatorDragManager.setColorScheme(this._colorScheme);
        this._squareDragManager.setPotential(this._squarePotential);
        this._squareDragManager.setColorScheme(this._colorScheme);
        this.hideAllDragManagers();
        bSAbstractDragManager.setVisible(true);
        PNode pNode = bSAbstractDragManager.getHelpNode();
        if (pNode != null) {
            this._dragHandleHelp.pointAt(pNode, this._canvas);
        }
        this._clockControls.setClockIndex(0);
        this.resetClock();
    }

    private void closeAllDialogs() {
        if (this._configureDialog != null) {
            this._configureDialog.dispose();
            this._configureDialog = null;
        }
        if (this._superpositionStateDialog != null) {
            this._superpositionStateDialog.dispose();
            this._superpositionStateDialog = null;
        }
    }

    public void setHasWiggleMe(boolean bl) {
        this._hasWiggleMe = bl;
    }

    private void addWiggleMe() {
        if (this._wiggleMe == null) {
            String string = BSResources.getString("wiggleMe.eigenstates");
            this._wiggleMe = new DefaultWiggleMe(this._canvas, string);
            this._parentNode.addChild(this._wiggleMe);
            this._wiggleMe.setOffset(250.0, -50.0);
            this._wiggleMe.animateTo(250.0, 250.0);
            this._wiggleMe.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    BSAbstractModule.this.disableWiggleMe();
                }
            });
        }
    }

    private void disableWiggleMe() {
        if (this._wiggleMe != null && this._wiggleMe.isEnabled()) {
            this._wiggleMe.setEnabled(false);
            this._parentNode.removeChild(this._wiggleMe);
        }
    }

    public BSModuleConfig save() {
        BSModuleConfig bSModuleConfig = new BSModuleConfig();
        bSModuleConfig.setClockRunning(this.getClock().isRunning());
        bSModuleConfig.setClockIndex(this._clockControls.getClockIndex());
        bSModuleConfig.saveParticle(this._particle);
        bSModuleConfig.saveAsymmetricPotential(this._asymmetricPotential);
        bSModuleConfig.saveCoulomb1DPotential(this._coulomb1DPotential);
        bSModuleConfig.saveCoulomb3DPotential(this._coulomb3DPotential);
        bSModuleConfig.saveHarmonicOscillatorPotential(this._harmonicOscillatorPotential);
        bSModuleConfig.saveSquarePotential(this._squarePotential);
        bSModuleConfig.setNumberOfWells(this._model.getPotential().getNumberOfWells());
        bSModuleConfig.setSuperpositionCoefficients(this._superpositionCoefficients.getCoefficients());
        bSModuleConfig.saveSelectedWellType(this._controlPanel.getWellType());
        bSModuleConfig.setMagnifyingGlassSelected(this._controlPanel.isMagnifyingGlassSelected());
        bSModuleConfig.setRealSelected(this._controlPanel.isRealSelected());
        bSModuleConfig.setImaginarySelected(this._controlPanel.isImaginarySelected());
        bSModuleConfig.setMagnitudeSelected(this._controlPanel.isMagnitudeSelected());
        bSModuleConfig.setPhaseSelected(this._controlPanel.isPhaseSelected());
        bSModuleConfig.saveBottomPlotMode(this._controlPanel.getBottomPlotMode());
        bSModuleConfig.setFieldConstant(this._controlPanel.getFieldConstant());
        return bSModuleConfig;
    }

    public void load(BSModuleConfig bSModuleConfig) {
        this.closeAllDialogs();
        if (this.isActive()) {
            if (bSModuleConfig.isClockRunning()) {
                this.getClock().start();
            } else {
                this.getClock().pause();
            }
        }
        this._clockControls.setClockIndex(bSModuleConfig.getClockIndex());
        this._model.setNotifyEnabled(false);
        this._particle = bSModuleConfig.loadParticle();
        this._model.setParticle(this._particle);
        this._asymmetricPotential = bSModuleConfig.loadAsymmetricPotential(this._particle);
        this._coulomb1DPotential = bSModuleConfig.loadCoulomb1DPotential(this._particle);
        this._coulomb3DPotential = bSModuleConfig.loadCoulomb3DPotential(this._particle);
        this._harmonicOscillatorPotential = bSModuleConfig.loadHarmonicOscillatorPotential(this._particle);
        this._squarePotential = bSModuleConfig.loadSquarePotential(this._particle);
        this.setNumberOfWells(bSModuleConfig.getNumberOfWells());
        this._asymmetricDragManager.setPotential(this._asymmetricPotential);
        this._asymmetricDragManager.setColorScheme(this._colorScheme);
        this._coulomb1DDragManager.setPotential(this._coulomb1DPotential);
        this._coulomb1DDragManager.setColorScheme(this._colorScheme);
        this._coulomb3DDragManager.setPotential(this._coulomb3DPotential);
        this._coulomb3DDragManager.setColorScheme(this._colorScheme);
        this._harmonicOscillatorDragManager.setPotential(this._harmonicOscillatorPotential);
        this._harmonicOscillatorDragManager.setColorScheme(this._colorScheme);
        this._squareDragManager.setPotential(this._squarePotential);
        this._squareDragManager.setColorScheme(this._colorScheme);
        BSWellType bSWellType = bSModuleConfig.loadSelectedWellType();
        BSAbstractPotential bSAbstractPotential = null;
        BSAbstractDragManager bSAbstractDragManager = null;
        if (bSWellType == BSWellType.ASYMMETRIC) {
            bSAbstractPotential = this._asymmetricPotential;
            bSAbstractDragManager = this._asymmetricDragManager;
        } else if (bSWellType == BSWellType.COULOMB_1D) {
            assert (this._coulomb1DPotential != null);
            bSAbstractPotential = this._coulomb1DPotential;
            bSAbstractDragManager = this._coulomb1DDragManager;
        } else if (bSWellType == BSWellType.COULOMB_3D) {
            assert (this._coulomb3DPotential != null);
            bSAbstractPotential = this._coulomb3DPotential;
            bSAbstractDragManager = this._coulomb3DDragManager;
        } else if (bSWellType == BSWellType.HARMONIC_OSCILLATOR) {
            bSAbstractPotential = this._harmonicOscillatorPotential;
            bSAbstractDragManager = this._harmonicOscillatorDragManager;
        } else if (bSWellType == BSWellType.SQUARE) {
            bSAbstractPotential = this._squarePotential;
            bSAbstractDragManager = this._squareDragManager;
        } else {
            throw new IllegalArgumentException("unsupported wellType: " + bSWellType);
        }
        assert (bSAbstractPotential != null);
        this._model.setPotential(bSAbstractPotential);
        this.hideAllDragManagers();
        bSAbstractDragManager.setVisible(true);
        double[] dArray = bSModuleConfig.getSuperpositionCoefficients();
        for (int i = 0; i < dArray.length; ++i) {
            this._superpositionCoefficients.setCoefficient(i, dArray[i]);
        }
        this._model.setNotifyEnabled(true);
        this._controlPanel.setMagnifyingGlassSelected(bSModuleConfig.isMagnifyingGlassSelected());
        this._controlPanel.setRealSelected(bSModuleConfig.isRealSelected());
        this._controlPanel.setImaginarySelected(bSModuleConfig.isImaginarySelected());
        this._controlPanel.setMagnitudeSelected(bSModuleConfig.isMagnitudeSelected());
        this._controlPanel.setPhaseSelected(bSModuleConfig.isPhaseSelected());
        this._controlPanel.setBottomPlotMode(bSModuleConfig.loadBottomPlotMode());
        this._controlPanel.setParticleMass(this._particle.getMass());
        this._controlPanel.setWellType(this._model.getWellType());
        this._controlPanel.setNumberOfWellsControlVisible(this._model.getPotential().supportsMultipleWells());
        this._controlPanel.setNumberOfWells(this._model.getNumberOfWells());
        this._controlPanel.setFieldConstant(bSModuleConfig.getFieldConstant());
        this.configureZoomControls(this._model.getWellType());
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this._colorScheme = bSColorScheme;
        this._chart.setColorScheme(bSColorScheme);
        this._energyPlot.setColorScheme(bSColorScheme);
        this._bottomPlot.setColorScheme(bSColorScheme);
        this._controlPanel.setColorScheme(bSColorScheme);
        this._legend.setColorScheme(bSColorScheme);
        this._eigenstatesNode.setColorScheme(bSColorScheme);
        this._selectedEquationNode.setColorScheme(bSColorScheme);
        this._hilitedEquationNode.setColorScheme(bSColorScheme);
        if (this._magnifyingGlass != null) {
            this._magnifyingGlass.setColorScheme(bSColorScheme);
        }
        if (this._superpositionStateDialog != null) {
            this._superpositionStateDialog.setColorScheme(this._colorScheme);
        }
        this._asymmetricDragManager.setColorScheme(this._colorScheme);
        this._coulomb1DDragManager.setColorScheme(this._colorScheme);
        this._coulomb3DDragManager.setColorScheme(this._colorScheme);
        this._harmonicOscillatorDragManager.setColorScheme(this._colorScheme);
        this._squareDragManager.setColorScheme(this._colorScheme);
    }

    public JFrame getFrame() {
        return PhetApplication.getInstance().getPhetFrame();
    }

    public void addClockListener(ClockListener clockListener) {
        this.getClock().addClockListener(clockListener);
    }

    public void setWellType(BSWellType bSWellType) {
        if (bSWellType != this._model.getWellType()) {
            if (this._configureDialog != null) {
                this._configureDialog.dispose();
            }
            this.configureZoomControls(bSWellType);
            BSAbstractPotential bSAbstractPotential = null;
            BSAbstractDragManager bSAbstractDragManager = null;
            if (bSWellType == BSWellType.ASYMMETRIC) {
                bSAbstractPotential = this._asymmetricPotential;
                bSAbstractDragManager = this._asymmetricDragManager;
            } else if (bSWellType == BSWellType.COULOMB_1D) {
                assert (this._coulomb1DPotential != null);
                bSAbstractPotential = this._coulomb1DPotential;
                bSAbstractDragManager = this._coulomb1DDragManager;
            } else if (bSWellType == BSWellType.COULOMB_3D) {
                assert (this._coulomb3DPotential != null);
                bSAbstractPotential = this._coulomb3DPotential;
                bSAbstractDragManager = this._coulomb3DDragManager;
            } else if (bSWellType == BSWellType.HARMONIC_OSCILLATOR) {
                bSAbstractPotential = this._harmonicOscillatorPotential;
                bSAbstractDragManager = this._harmonicOscillatorDragManager;
            } else if (bSWellType == BSWellType.SQUARE) {
                bSAbstractPotential = this._squarePotential;
                bSAbstractDragManager = this._squareDragManager;
            } else {
                throw new IllegalArgumentException("unsupported wellType: " + bSWellType);
            }
            assert (bSAbstractPotential != null);
            assert (bSAbstractDragManager != null);
            this.hideAllDragManagers();
            bSAbstractDragManager.setVisible(true);
            PNode pNode = bSAbstractDragManager.getHelpNode();
            if (pNode != null) {
                this._dragHandleHelp.pointAt(pNode, this._canvas);
            }
            this._model.setPotential(bSAbstractPotential);
            this._controlPanel.setWellType(bSWellType);
            this._controlPanel.setNumberOfWellsControlVisible(this._model.getPotential().supportsMultipleWells());
            this._controlPanel.setNumberOfWells(this._model.getNumberOfWells());
            this.resetClock();
        }
    }

    public void setNumberOfWells(int n) {
        if (n != this._model.getNumberOfWells()) {
            if (this._asymmetricPotential != null) {
                this._asymmetricPotential.setNumberOfWells(n);
            }
            if (this._coulomb1DPotential != null) {
                this._coulomb1DPotential.setNumberOfWells(n);
            }
            if (this._coulomb3DPotential != null) {
                this._coulomb3DPotential.setNumberOfWells(n);
            }
            if (this._harmonicOscillatorPotential != null) {
                this._harmonicOscillatorPotential.setNumberOfWells(n);
            }
            if (this._squarePotential != null) {
                this._squarePotential.setNumberOfWells(n);
            }
            this._eigenstatesNode.updateBandSelection();
            this.resetClock();
        }
    }

    public void showConfigureDialog() {
        if (this._configureDialog == null) {
            this._configureDialog = BSConfigureDialogFactory.createDialog(this.getFrame(), this._model.getPotential(), this._moduleSpec);
            this._configureDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    BSAbstractModule.this._configDialogLocation = BSAbstractModule.this._configureDialog.getLocation();
                    BSAbstractModule.this._configureDialog = null;
                }
            });
            if (this._configDialogLocation == null) {
                SwingUtils.centerDialogInParent(this._configureDialog);
            } else {
                this._configureDialog.setLocation(this._configDialogLocation);
            }
            this._configureDialog.setVisible(true);
        }
    }

    public void showSuperpositionStateDialog() {
        if (this._superpositionStateDialog == null) {
            this._superpositionStateDialog = new BSSuperpositionStateDialog((Frame)this.getFrame(), this._model, this._colorScheme);
            this._superpositionStateDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    BSAbstractModule.this._superpositionStateDialogLocation = BSAbstractModule.this._superpositionStateDialog.getLocation();
                    BSAbstractModule.this._superpositionStateDialog = null;
                }
            });
            if (this._superpositionStateDialogLocation == null) {
                SwingUtils.centerDialogInParent(this._superpositionStateDialog);
            } else {
                this._superpositionStateDialog.setLocation(this._superpositionStateDialogLocation);
            }
            this._superpositionStateDialog.setVisible(true);
        }
    }

    public void setRealVisible(boolean bl) {
        this._bottomPlot.setRealSeriesVisible(bl);
    }

    public void setImaginaryVisible(boolean bl) {
        this._bottomPlot.setImaginarySeriesVisible(bl);
    }

    public void setMagnitudeVisible(boolean bl) {
        this._bottomPlot.setMagnitudeSeriesVisible(bl);
    }

    public void setPhaseVisible(boolean bl) {
        this._bottomPlot.setPhaseSeriesVisible(bl);
    }

    public void setBottomPlotMode(BSBottomPlotMode bSBottomPlotMode) {
        this._chart.getBottomPlot().setMode(bSBottomPlotMode);
        this._bottomPlot.setMode(bSBottomPlotMode);
        this._selectedEquationNode.setMode(bSBottomPlotMode);
        this._hilitedEquationNode.setMode(bSBottomPlotMode);
        this._eigenstatesNode.setMode(bSBottomPlotMode);
        this._magnifyingGlass.setMode(bSBottomPlotMode);
    }

    public void setParticleMass(double d) {
        this._particle.setMass(d);
        this.resetClock();
    }

    public void setMagnifyingGlassVisible(boolean bl) {
        if (this._magnifyingGlass != null) {
            this._magnifyingGlass.setVisible(bl);
        }
    }

    private void resetClock() {
        this.getClock().resetSimulationTime();
    }

    private void handleClockReset() {
    }

    private void configureZoomControls(BSWellType bSWellType) {
        BSPotentialSpec bSPotentialSpec = this._moduleSpec.getRangeSpec(bSWellType);
        ZoomControl.ZoomSpec zoomSpec = bSPotentialSpec.getEnergyZoomSpec();
        this._energyZoomControlNode.setVisible(zoomSpec.getNumberOfZoomLevels() > 1);
        this._energyZoomControl.setZoomSpec(zoomSpec);
    }

    public String getId() {
        return this._moduleSpec.getId();
    }

    private void hideAllDragManagers() {
        this._asymmetricDragManager.setVisible(false);
        this._coulomb1DDragManager.setVisible(false);
        this._coulomb3DDragManager.setVisible(false);
        this._harmonicOscillatorDragManager.setVisible(false);
        this._squareDragManager.setVisible(false);
    }

    public void setFieldConstant(double d) {
        if (this._asymmetricPotential != null) {
            this._asymmetricPotential.setFieldConstant(d);
        }
        if (this._coulomb1DPotential != null) {
            this._coulomb1DPotential.setFieldConstant(d);
        }
        if (this._coulomb3DPotential != null) {
            this._coulomb3DPotential.setFieldConstant(d);
        }
        if (this._harmonicOscillatorPotential != null) {
            this._harmonicOscillatorPotential.setFieldConstant(d);
        }
        if (this._squarePotential != null) {
            this._squarePotential.setFieldConstant(d);
        }
    }

    private class EventListener
    extends ComponentAdapter {
        private EventListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (componentEvent.getSource() == BSAbstractModule.this._canvas) {
                BSAbstractModule.this.layoutCanvas();
            }
        }
    }
}

