/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.draghandles.BSPotentialHandle;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;

public class BSSquareWidthHandle
extends BSPotentialHandle {
    public BSSquareWidthHandle(BSSquarePotential bSSquarePotential, BSPotentialSpec bSPotentialSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSSquarePotential, bSPotentialSpec, bSCombinedChartNode, 0);
        int n = bSPotentialSpec.getWidthRange().getSignificantDecimalPlaces();
        String string = BSSquareWidthHandle.createNumberFormat(n);
        this.setValueNumberFormat(string);
        this.setValuePattern(BSResources.getString("drag.width"));
        this.updateDragBounds();
    }

    public void updateDragBounds() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
        if (bSSquarePotential.getCenter() != 0.0) {
            throw new UnsupportedOperationException("this implementation only supports potentials centered at 0");
        }
        int n = bSSquarePotential.getNumberOfWells();
        double d = bSSquarePotential.getSeparation();
        double d2 = bSPotentialSpec.getWidthRange().getMin();
        double d3 = bSPotentialSpec.getWidthRange().getMax();
        double d4 = ((double)n * d2 + (double)(n - 1) * d) / 2.0;
        double d5 = ((double)n * d3 + (double)(n - 1) * d) / 2.0;
        double d6 = bSCombinedChartNode.positionToNode(d4);
        double d7 = bSCombinedChartNode.positionToNode(d5);
        ValueAxis valueAxis = bSCombinedChartNode.getEnergyPlot().getRangeAxis();
        double d8 = valueAxis.getLowerBound();
        double d9 = valueAxis.getUpperBound();
        double d10 = bSCombinedChartNode.energyToNode(d9);
        double d11 = bSCombinedChartNode.energyToNode(d8);
        double d12 = d7 - d6;
        double d13 = d11 - d10;
        Rectangle2D rectangle2D = new Rectangle2D.Double(d6, d10, d12, d13);
        rectangle2D = bSCombinedChartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updateView();
    }

    protected void updateModel() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        bSSquarePotential.deleteObserver(this);
        Point2D point2D = this.getGlobalPosition();
        Point2D point2D2 = this.viewToModel(point2D);
        double d = point2D2.getX();
        int n = bSSquarePotential.getNumberOfWells();
        double d2 = bSSquarePotential.getSeparation();
        double d3 = (2.0 * d - (double)(n - 1) * d2) / (double)n;
        int n2 = bSPotentialSpec.getWidthRange().getSignificantDecimalPlaces();
        d3 = BSSquareWidthHandle.round(d3, n2);
        bSSquarePotential.setWidth(d3);
        this.setValueDisplay(d3);
        bSSquarePotential.addObserver(this);
        this.updateDragBounds();
    }

    protected void updateView() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        this.removePropertyChangeListener(this);
        int n = bSSquarePotential.getNumberOfWells();
        double d = bSSquarePotential.getCenter(n - 1);
        double d2 = bSSquarePotential.getWidth();
        double d3 = bSSquarePotential.getHeight();
        double d4 = d + d2 / 2.0;
        double d5 = bSSquarePotential.getEnergyAt(d4 + 0.001) - d3 / 2.0;
        Point2D.Double double_ = new Point2D.Double(d4, d5);
        Point2D point2D = this.modelToView(double_);
        this.setGlobalPosition(point2D);
        this.setValueDisplay(d2);
        this.addPropertyChangeListener(this);
    }
}

