/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.draghandles.BSAbstractMarker;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Observable;
import java.util.Observer;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;

public class BSSquareSeparationMarker
extends BSAbstractMarker
implements Observer {
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private BSSquarePotential _potential;
    private BSCombinedChartNode _chartNode;
    private PPath _leftNode;
    private PPath _rightNode;
    private GeneralPath _leftPath;
    private GeneralPath _rightPath;

    public BSSquareSeparationMarker(BSSquarePotential bSSquarePotential, BSCombinedChartNode bSCombinedChartNode) {
        this._potential = bSSquarePotential;
        this._potential.addObserver(this);
        this._chartNode = bSCombinedChartNode;
        this._leftPath = new GeneralPath();
        this._leftNode = new PPath();
        this._leftNode.setStroke(BSConstants.DRAG_HANDLE_MARKERS_STROKE);
        this._leftNode.setStrokePaint(DEFAULT_COLOR);
        this.addChild(this._leftNode);
        this._rightPath = new GeneralPath();
        this._rightNode = new PPath();
        this._rightNode.setStroke(BSConstants.DRAG_HANDLE_MARKERS_STROKE);
        this._rightNode.setStrokePaint(DEFAULT_COLOR);
        this.addChild(this._rightNode);
        ValueAxis valueAxis = bSCombinedChartNode.getEnergyPlot().getRangeAxis();
        valueAxis.addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent axisChangeEvent) {
                BSSquareSeparationMarker.this.updateView();
            }
        });
        this.updateView();
    }

    public void updateView() {
        if (this._potential.getCenter() != 0.0) {
            throw new UnsupportedOperationException("this implementation only supports potentials centered at 0");
        }
        this._leftPath.reset();
        this._rightPath.reset();
        int n = this._potential.getNumberOfWells();
        if (n > 1) {
            double d = this._potential.getSeparation();
            double d2 = 0.0;
            double d3 = 0.0;
            if (n % 2 == 0) {
                d2 = -(d / 2.0);
                d3 = d / 2.0;
            } else {
                double d4 = this._potential.getWidth();
                d2 = d4 / 2.0;
                d3 = d4 / 2.0 + d;
            }
            ValueAxis valueAxis = this._chartNode.getEnergyPlot().getRangeAxis();
            double d5 = valueAxis.getUpperBound();
            double d6 = this._potential.getOffset();
            double d7 = this._potential.getHeight();
            Point2D.Double double_ = new Point2D.Double(d2, d5);
            Point2D point2D = this._chartNode.energyToNode(double_);
            Point2D point2D2 = this._chartNode.localToGlobal(point2D);
            Point2D.Double double_2 = new Point2D.Double(d2, d6 + d7);
            Point2D point2D3 = this._chartNode.energyToNode(double_2);
            Point2D point2D4 = this._chartNode.localToGlobal(point2D3);
            this._leftPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
            this._leftPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
            double_ = new Point2D.Double(d3, d5);
            point2D = this._chartNode.energyToNode(double_);
            point2D2 = this._chartNode.localToGlobal(point2D);
            double_2 = new Point2D.Double(d3, d6 + d7);
            point2D3 = this._chartNode.energyToNode(double_2);
            point2D4 = this._chartNode.localToGlobal(point2D3);
            this._rightPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
            this._rightPath.lineTo((float)point2D4.getX(), (float)point2D4.getY());
        }
        this._leftNode.setPathTo(this._leftPath);
        this._rightNode.setPathTo(this._rightPath);
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this._leftNode.setStrokePaint(bSColorScheme.getDragHandleMarkersColor());
        this._rightNode.setStrokePaint(bSColorScheme.getDragHandleMarkersColor());
    }

    public void update(Observable observable, Object object) {
        assert (observable == this._potential);
        this.updateView();
    }
}

