/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.draghandles;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.draghandles.BSPotentialHandle;
import edu.colorado.phet.boundstates.model.BSSquarePotential;
import edu.colorado.phet.boundstates.module.BSPotentialSpec;
import edu.colorado.phet.boundstates.view.BSCombinedChartNode;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BSSquareOffsetHandle
extends BSPotentialHandle {
    public BSSquareOffsetHandle(BSSquarePotential bSSquarePotential, BSPotentialSpec bSPotentialSpec, BSCombinedChartNode bSCombinedChartNode) {
        super(bSSquarePotential, bSPotentialSpec, bSCombinedChartNode, 1);
        int n = bSPotentialSpec.getOffsetRange().getSignificantDecimalPlaces();
        String string = BSSquareOffsetHandle.createNumberFormat(n);
        this.setValueNumberFormat(string);
        this.setValuePattern(BSResources.getString("drag.offset"));
        this.updateDragBounds();
    }

    public void updateDragBounds() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        BSCombinedChartNode bSCombinedChartNode = this.getChartNode();
        assert (bSSquarePotential.getCenter() == 0.0);
        double d = BSConstants.POSITION_VIEW_RANGE.getLowerBound();
        double d2 = BSConstants.POSITION_VIEW_RANGE.getUpperBound();
        double d3 = bSCombinedChartNode.positionToNode(d);
        double d4 = bSCombinedChartNode.positionToNode(d2);
        double d5 = bSPotentialSpec.getOffsetRange().getMin();
        double d6 = bSPotentialSpec.getOffsetRange().getMax();
        double d7 = bSCombinedChartNode.energyToNode(d6);
        double d8 = bSCombinedChartNode.energyToNode(d5);
        double d9 = d4 - d3;
        double d10 = d8 - d7;
        Rectangle2D rectangle2D = new Rectangle2D.Double(d3, d7, d9, d10);
        rectangle2D = bSCombinedChartNode.localToGlobal(rectangle2D);
        this.setDragBounds(rectangle2D);
        this.updateView();
    }

    protected void updateModel() {
        double d;
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        BSPotentialSpec bSPotentialSpec = this.getPotentialSpec();
        bSSquarePotential.deleteObserver(this);
        Point2D point2D = this.getGlobalPosition();
        Point2D point2D2 = this.viewToModel(point2D);
        double d2 = d = point2D2.getY();
        int n = bSPotentialSpec.getOffsetRange().getSignificantDecimalPlaces();
        d2 = BSSquareOffsetHandle.round(d2, n);
        bSSquarePotential.setOffset(d2);
        this.setValueDisplay(d2);
        bSSquarePotential.addObserver(this);
    }

    protected void updateView() {
        BSSquarePotential bSSquarePotential = (BSSquarePotential)this.getPotential();
        this.removePropertyChangeListener(this);
        int n = bSSquarePotential.getNumberOfWells();
        double d = bSSquarePotential.getCenter(n - 1);
        double d2 = bSSquarePotential.getOffset();
        double d3 = d;
        double d4 = d2;
        Point2D.Double double_ = new Point2D.Double(d3, d4);
        Point2D point2D = this.modelToView(double_);
        this.setGlobalPosition(point2D);
        this.setValueDisplay(d4);
        this.addPropertyChangeListener(this);
    }
}

