/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.control;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.enums.BSWellType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class BSWellComboBox
extends JComboBox {
    private static final Stroke ICON_STROKE = new BasicStroke(2.0f);
    private ArrayList _choices = new ArrayList();
    private Color _potentialColor = BSConstants.COLOR_SCHEME.getPotentialEnergyColor();

    public BSWellComboBox() {
        WellComboBoxRenderer wellComboBoxRenderer = new WellComboBoxRenderer();
        this.setRenderer(wellComboBoxRenderer);
    }

    public void clearChoices() {
        this._choices.clear();
        this.removeAllItems();
    }

    public void addChoice(BSWellType bSWellType) {
        if (bSWellType == BSWellType.ASYMMETRIC) {
            ImageIcon imageIcon = BSWellComboBox.createAsymmetricIcon(this._potentialColor);
            WellChoice wellChoice = new WellChoice(bSWellType, BSResources.getString("choice.well.asymmetric"), imageIcon);
            this._choices.add(wellChoice);
            this.addItem(wellChoice);
        } else if (bSWellType == BSWellType.COULOMB_1D) {
            ImageIcon imageIcon = BSWellComboBox.createCoulombIcon(this._potentialColor);
            WellChoice wellChoice = new WellChoice(bSWellType, BSResources.getString("choice.well.coulomb1D"), imageIcon);
            this._choices.add(wellChoice);
            this.addItem(wellChoice);
        } else if (bSWellType == BSWellType.COULOMB_3D) {
            ImageIcon imageIcon = BSWellComboBox.createCoulombIcon(this._potentialColor);
            WellChoice wellChoice = new WellChoice(bSWellType, BSResources.getString("choice.well.coulomb3D"), imageIcon);
            this._choices.add(wellChoice);
            this.addItem(wellChoice);
        } else if (bSWellType == BSWellType.HARMONIC_OSCILLATOR) {
            ImageIcon imageIcon = BSWellComboBox.createHarmonicOscillatorIcon(this._potentialColor);
            WellChoice wellChoice = new WellChoice(bSWellType, BSResources.getString("choice.well.harmonicOscillator"), imageIcon);
            this._choices.add(wellChoice);
            this.addItem(wellChoice);
        } else if (bSWellType == BSWellType.SQUARE) {
            ImageIcon imageIcon = BSWellComboBox.createSquareIcon(this._potentialColor);
            WellChoice wellChoice = new WellChoice(bSWellType, BSResources.getString("choice.well.square"), imageIcon);
            this._choices.add(wellChoice);
            this.addItem(wellChoice);
        } else {
            throw new IllegalArgumentException("unsupported well type: " + bSWellType);
        }
        this.setMaximumRowCount(this._choices.size());
    }

    public BSWellType getSelectedWellType() {
        return ((WellChoice)this.getSelectedItem()).getWellType();
    }

    public void setSelectedWellType(BSWellType bSWellType) {
        Iterator iterator = this._choices.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            WellChoice wellChoice = (WellChoice)iterator.next();
            if (wellChoice.getWellType() != bSWellType) continue;
            this.setSelectedItem(wellChoice);
            bl = true;
        }
        if (!bl) {
            throw new IllegalStateException("potentialType is not one of the choices: " + bSWellType);
        }
    }

    public void setWellColor(Color color) {
        this._potentialColor = color;
        BSWellType bSWellType = this.getSelectedWellType();
        ArrayList arrayList = new ArrayList(this._choices);
        this.clearChoices();
        for (WellChoice wellChoice : arrayList) {
            this.addChoice(wellChoice.getWellType());
        }
        this.setSelectedWellType(bSWellType);
    }

    private static ImageIcon createCoulombIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(20, 20, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        QuadCurve2D.Double double_ = new QuadCurve2D.Double();
        QuadCurve2D.Double double_2 = new QuadCurve2D.Double();
        ((QuadCurve2D)double_).setCurve(0.0, 4.0, 8.0, 5.0, 7.0, 16.0);
        ((QuadCurve2D)double_2).setCurve(10.0, 16.0, 11.0, 5.0, 17.0, 4.0);
        graphics2D.setStroke(ICON_STROKE);
        graphics2D.setPaint(color);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
        return new ImageIcon(bufferedImage);
    }

    private static ImageIcon createHarmonicOscillatorIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(17, 20, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        QuadCurve2D.Double double_ = new QuadCurve2D.Double();
        ((QuadCurve2D)double_).setCurve(0.0, 3.0, 8.0, 30.0, 17.0, 3.0);
        graphics2D.setStroke(ICON_STROKE);
        graphics2D.setPaint(color);
        graphics2D.draw(double_);
        return new ImageIcon(bufferedImage);
    }

    private static ImageIcon createSquareIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(50, 20, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 4.0f);
        generalPath.lineTo(10.0f, 4.0f);
        generalPath.lineTo(10.0f, 16.0f);
        generalPath.lineTo(20.0f, 16.0f);
        generalPath.lineTo(20.0f, 4.0f);
        generalPath.lineTo(30.0f, 4.0f);
        graphics2D.setStroke(ICON_STROKE);
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
        return new ImageIcon(bufferedImage);
    }

    private static ImageIcon createAsymmetricIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(50, 20, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 4.0f);
        generalPath.lineTo(10.0f, 4.0f);
        generalPath.lineTo(10.0f, 16.0f);
        generalPath.lineTo(20.0f, 4.0f);
        generalPath.lineTo(30.0f, 4.0f);
        graphics2D.setStroke(ICON_STROKE);
        graphics2D.setPaint(color);
        graphics2D.draw(generalPath);
        return new ImageIcon(bufferedImage);
    }

    public static class WellChoice {
        private BSWellType _wellType;
        private String _label;
        private ImageIcon _imageIcon;

        public WellChoice(BSWellType bSWellType, String string, ImageIcon imageIcon) {
            this._wellType = bSWellType;
            this._label = string;
            this._imageIcon = imageIcon;
        }

        public BSWellType getWellType() {
            return this._wellType;
        }

        public ImageIcon getImageIcon() {
            return this._imageIcon;
        }

        public String getLabel() {
            return this._label;
        }
    }

    private static class WellComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public WellComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(2);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            WellChoice wellChoice = (WellChoice)object;
            this.setText(wellChoice.getLabel());
            this.setIcon(wellChoice.getImageIcon());
            return this;
        }
    }
}

