/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.control;

import edu.colorado.phet.boundstates.BSConstants;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.boundstates.control.BSAbstractControlPanel;
import edu.colorado.phet.boundstates.control.BSMassMultiplierSlider;
import edu.colorado.phet.boundstates.control.BSWellComboBox;
import edu.colorado.phet.boundstates.enums.BSBottomPlotMode;
import edu.colorado.phet.boundstates.enums.BSWellType;
import edu.colorado.phet.boundstates.module.BSAbstractModule;
import edu.colorado.phet.boundstates.module.BSAbstractModuleSpec;
import edu.colorado.phet.boundstates.view.ViewLegend;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BSControlPanel
extends BSAbstractControlPanel {
    private BSAbstractModule _module;
    private BSWellComboBox _wellTypeComboBox;
    private LinearValueControl _numberOfWellsControl;
    private JButton _configureEnergyButton;
    private JButton _superpositionButton;
    private JCheckBox _magnifyingGlassCheckBox;
    private LinearValueControl _fieldConstantControl;
    private JRadioButton _waveFunctionRadioButton;
    private JRadioButton _probabilityDensityRadioButton;
    private JRadioButton _averageProbabilityDensityRadioButton;
    private JCheckBox _realCheckBox;
    private JCheckBox _imaginaryCheckBox;
    private JCheckBox _magnitudeCheckBox;
    private JCheckBox _phaseCheckBox;
    private JLabel _realLegend;
    private JLabel _imaginaryLegend;
    private JLabel _magnitudeLegend;
    private JLabel _phaseLegend;
    private LinearValueControl _massMultiplierControl;
    private EventListener _listener;

    public BSControlPanel(BSAbstractModule bSAbstractModule, BSAbstractModuleSpec bSAbstractModuleSpec) {
        super(bSAbstractModule);
        Object object;
        Object object2;
        int n;
        this._module = bSAbstractModule;
        int n2 = BSResources.getInt("width.controlPanel", 235);
        this.setMinimumWidth(n2);
        JPanel jPanel = new JPanel();
        Object object3 = BSResources.getString("title.energyChartControls");
        jPanel.setBorder(new TitledBorder((String)object3));
        Object object4 = new JLabel(BSResources.getString("label.wellType"));
        this._wellTypeComboBox = new BSWellComboBox();
        Object object5 = bSAbstractModuleSpec.getWellTypes();
        for (int i = 0; i < ((BSWellType[])object5).length; ++i) {
            this._wellTypeComboBox.addChoice(object5[i]);
        }
        if (bSAbstractModuleSpec.isNumberOfWellsSupported()) {
            IntegerRange integerRange = bSAbstractModuleSpec.getNumberOfWellsRange();
            int n3 = integerRange.getMin();
            int n4 = integerRange.getMax();
            n = integerRange.getDefault();
            this._numberOfWellsControl = new LinearValueControl(n3, n4, BSResources.getString("label.numberOfWells"), "0", "");
            this._numberOfWellsControl.setValue(n);
            this._numberOfWellsControl.setUpDownArrowDelta(1.0);
            this._numberOfWellsControl.setTextFieldEditable(true);
            this._numberOfWellsControl.setTextFieldColumns(2);
            this._numberOfWellsControl.setMajorTickSpacing(1.0);
            this._numberOfWellsControl.setNotifyWhileAdjusting(false);
            this._numberOfWellsControl.setSnapToTicks(true);
        }
        this._configureEnergyButton = new JButton(BSResources.getString("button.configureEnergy"));
        this._superpositionButton = new JButton(BSResources.getString("button.superposition"));
        if (bSAbstractModuleSpec.isFieldConstantSupported()) {
            DoubleRange doubleRange = bSAbstractModuleSpec.getFieldConstantRange();
            double d = doubleRange.getDefault();
            double d2 = doubleRange.getMin();
            double d3 = doubleRange.getMax();
            object2 = BSResources.getString("label.fieldConstant");
            object = BSResources.getString("units.fieldConstant");
            this._fieldConstantControl = new LinearValueControl(d2, d3, (String)object2, "0.0", (String)object);
            this._fieldConstantControl.setValue(d);
            this._fieldConstantControl.setUpDownArrowDelta(0.1);
            this._fieldConstantControl.setTextFieldColumns(3);
            this._fieldConstantControl.setTextFieldEditable(true);
            this._fieldConstantControl.setMajorTickSpacing(0.5);
            this._fieldConstantControl.setNotifyWhileAdjusting(false);
        }
        Object object6 = BSResources.getString("choice.magnifyingGlass") + " (?x)";
        this._magnifyingGlassCheckBox = new JCheckBox((String)object6);
        Serializable serializable = new JPanel();
        Serializable serializable2 = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        ((EasyGridBagLayout)serializable2).setAnchor(17);
        n = 0;
        int n5 = 0;
        ((EasyGridBagLayout)serializable2).addComponent((Component)object4, n, n5, 2, 1);
        ((EasyGridBagLayout)serializable2).addComponent(this._wellTypeComboBox, ++n, n5);
        ((EasyGridBagLayout)serializable2).addComponent(this._configureEnergyButton, ++n, n5);
        ++n;
        if (this._numberOfWellsControl != null) {
            ((EasyGridBagLayout)serializable2).addComponent(this._numberOfWellsControl, n, n5);
            ++n;
        }
        if (bSAbstractModuleSpec.isSuperpositionControlsSupported()) {
            ((EasyGridBagLayout)serializable2).addComponent(this._superpositionButton, n, n5);
            ++n;
        }
        if (this._fieldConstantControl != null) {
            ((EasyGridBagLayout)serializable2).addComponent(this._fieldConstantControl, n, n5);
            ++n;
        }
        if (bSAbstractModuleSpec.isMagnifyingGlassSupported()) {
            ((EasyGridBagLayout)serializable2).addComponent(this._magnifyingGlassCheckBox, n, n5);
            ++n;
        }
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)serializable, "West");
        object3 = new JPanel();
        object4 = BSResources.getString("title.bottomChartControls");
        ((JComponent)object3).setBorder(new TitledBorder((String)object4));
        object5 = new JPanel();
        object6 = new JLabel(BSResources.getString("label.display"));
        this._averageProbabilityDensityRadioButton = new JRadioButton(BSResources.getString("choice.display.averageProbabilityDensity"));
        this._probabilityDensityRadioButton = new JRadioButton(BSResources.getString("choice.display.probabilityDensity"));
        this._waveFunctionRadioButton = new JRadioButton(BSResources.getString("choice.display.waveFunction"));
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this._averageProbabilityDensityRadioButton);
        ((ButtonGroup)serializable).add(this._probabilityDensityRadioButton);
        ((ButtonGroup)serializable).add(this._waveFunctionRadioButton);
        serializable2 = new JPanel();
        Object object7 = new EasyGridBagLayout((JPanel)serializable2);
        ((Container)serializable2).setLayout((LayoutManager)object7);
        ((EasyGridBagLayout)object7).setAnchor(17);
        ((EasyGridBagLayout)object7).setInsets(new Insets(0, 0, 0, 0));
        ((EasyGridBagLayout)object7).setMinimumWidth(0, 10);
        n5 = 0;
        int n6 = 0;
        ((EasyGridBagLayout)object7).addComponent((Component)object6, n5, n6, 2, 1);
        ++n5;
        ++n6;
        if (bSAbstractModuleSpec.isAverageProbabilityDensitySupported()) {
            ((EasyGridBagLayout)object7).addComponent(this._averageProbabilityDensityRadioButton, n5, n6);
            ++n5;
        }
        ((EasyGridBagLayout)object7).addComponent(this._probabilityDensityRadioButton, n5, n6);
        ((EasyGridBagLayout)object7).addComponent(this._waveFunctionRadioButton, ++n5, n6);
        ++n5;
        ((Container)object5).setLayout(new BorderLayout());
        ((Container)object5).add((Component)serializable2, "West");
        object6 = new JPanel();
        serializable = new JLabel(BSResources.getString("label.view"));
        this._realCheckBox = new JCheckBox(BSResources.getString("choice.view.real"));
        this._imaginaryCheckBox = new JCheckBox(BSResources.getString("choice.view.imaginary"));
        this._magnitudeCheckBox = new JCheckBox(BSResources.getString("choice.view.magnitude"));
        this._phaseCheckBox = new JCheckBox(BSResources.getString("choice.view.phase"));
        serializable2 = new JPanel(new FlowLayout(0, 0, 0));
        ((Container)serializable2).add(this._realCheckBox);
        ((Container)serializable2).add(Box.createHorizontalStrut(7));
        object7 = ViewLegend.createColorKey(BSConstants.COLOR_SCHEME.getRealColor());
        this._realLegend = new JLabel((Icon)object7);
        ((Container)serializable2).add(this._realLegend);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this._imaginaryCheckBox);
        jPanel2.add(Box.createHorizontalStrut(7));
        Icon icon = ViewLegend.createColorKey(BSConstants.COLOR_SCHEME.getImaginaryColor());
        this._imaginaryLegend = new JLabel(icon);
        jPanel2.add(this._imaginaryLegend);
        Object object8 = new JPanel(new FlowLayout(0, 0, 0));
        ((Container)object8).add(this._magnitudeCheckBox);
        ((Container)object8).add(Box.createHorizontalStrut(7));
        Object object9 = ViewLegend.createColorKey(BSConstants.COLOR_SCHEME.getMagnitudeColor());
        this._magnitudeLegend = new JLabel((Icon)object9);
        ((Container)object8).add(this._magnitudeLegend);
        object2 = new JPanel(new FlowLayout(0, 0, 0));
        ((Container)object2).add(this._phaseCheckBox);
        ((Container)object2).add(Box.createHorizontalStrut(7));
        object = ViewLegend.createPhaseKey();
        this._phaseLegend = new JLabel((Icon)object);
        ((Container)object2).add(this._phaseLegend);
        JPanel jPanel3 = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel3);
        jPanel3.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setInsets(new Insets(0, 0, 0, 0));
        easyGridBagLayout.setMinimumWidth(0, 10);
        easyGridBagLayout.addComponent((Component)serializable, 0, 0, 2, 1);
        easyGridBagLayout.addComponent((Component)serializable2, 1, 1);
        easyGridBagLayout.addComponent(jPanel2, 2, 1);
        easyGridBagLayout.addComponent((Component)object8, 3, 1);
        easyGridBagLayout.addComponent((Component)object2, 4, 1);
        ((Container)object6).setLayout(new BorderLayout());
        ((Container)object6).add((Component)jPanel3, "West");
        serializable = new JPanel();
        serializable2 = new EasyGridBagLayout((JPanel)serializable);
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        ((EasyGridBagLayout)serializable2).setAnchor(17);
        ((EasyGridBagLayout)serializable2).addComponent((Component)object5, 0, 0);
        ((EasyGridBagLayout)serializable2).addComponent((Component)object6, 1, 0);
        ((Container)object3).setLayout(new BorderLayout());
        ((Container)object3).add((Component)serializable, "West");
        object4 = new JPanel();
        ((JComponent)object4).setBorder(new TitledBorder(""));
        object5 = bSAbstractModuleSpec.getMassMultiplierRange();
        double d = ((DoubleRange)object5).getDefault();
        double d4 = ((DoubleRange)object5).getMin();
        double d5 = ((DoubleRange)object5).getMax();
        object8 = BSResources.getString("label.particleMass");
        object9 = "0.00";
        object2 = "<html>m<sub>e</sub></html>";
        this._massMultiplierControl = new BSMassMultiplierSlider(d4, d5, (String)object8, (String)object9, (String)object2);
        this._massMultiplierControl.setValue(d);
        this._massMultiplierControl.setUpDownArrowDelta(0.01);
        this._massMultiplierControl.setTextFieldEditable(true);
        this._massMultiplierControl.setTextFieldColumns(3);
        this._massMultiplierControl.setNotifyWhileAdjusting(true);
        jPanel3 = new JPanel();
        easyGridBagLayout = new EasyGridBagLayout(jPanel3);
        jPanel3.setLayout(easyGridBagLayout);
        easyGridBagLayout.setAnchor(17);
        easyGridBagLayout.setInsets(new Insets(0, 0, 0, 0));
        easyGridBagLayout.addComponent(this._massMultiplierControl, 0, 0);
        ((Container)object4).setLayout(new BorderLayout());
        ((Container)object4).add((Component)jPanel3, "West");
        this.addControlFullWidth(jPanel);
        this.addVerticalSpace(0);
        this.addControlFullWidth((Component)object3);
        this.addVerticalSpace(0);
        if (bSAbstractModuleSpec.isParticleControlsSupported()) {
            this.addControlFullWidth((Component)object4);
            this.addVerticalSpace(0);
        }
        this.addResetAllButton(bSAbstractModule);
        this._listener = new EventListener();
        this._wellTypeComboBox.addItemListener(this._listener);
        if (this._numberOfWellsControl != null) {
            this._numberOfWellsControl.addChangeListener(this._listener);
        }
        this._configureEnergyButton.addActionListener(this._listener);
        this._superpositionButton.addActionListener(this._listener);
        this._magnifyingGlassCheckBox.addActionListener(this._listener);
        if (this._fieldConstantControl != null) {
            this._fieldConstantControl.addChangeListener(this._listener);
        }
        this._waveFunctionRadioButton.addActionListener(this._listener);
        this._probabilityDensityRadioButton.addActionListener(this._listener);
        this._averageProbabilityDensityRadioButton.addActionListener(this._listener);
        this._realCheckBox.addActionListener(this._listener);
        this._imaginaryCheckBox.addActionListener(this._listener);
        this._magnitudeCheckBox.addActionListener(this._listener);
        this._phaseCheckBox.addActionListener(this._listener);
        this._massMultiplierControl.addChangeListener(this._listener);
    }

    public void setColorScheme(BSColorScheme bSColorScheme) {
        this._wellTypeComboBox.removeItemListener(this._listener);
        this._wellTypeComboBox.setWellColor(bSColorScheme.getPotentialEnergyColor());
        this._wellTypeComboBox.addItemListener(this._listener);
        this._realLegend.setIcon(ViewLegend.createColorKey(bSColorScheme.getRealColor()));
        this._imaginaryLegend.setIcon(ViewLegend.createColorKey(bSColorScheme.getImaginaryColor()));
        this._magnitudeLegend.setIcon(ViewLegend.createColorKey(bSColorScheme.getMagnitudeColor()));
    }

    public void setWellType(BSWellType bSWellType) {
        this._wellTypeComboBox.setSelectedWellType(bSWellType);
        this.handleWellTypeSelection();
    }

    public BSWellType getWellType() {
        return this._wellTypeComboBox.getSelectedWellType();
    }

    public void setNumberOfWells(int n) {
        if (this._numberOfWellsControl != null) {
            this._numberOfWellsControl.setValue(n);
            this.handleNumberOfWells();
        }
    }

    public void setMagnifyingGlassSelected(boolean bl) {
        this._magnifyingGlassCheckBox.setSelected(bl);
        this.handleMagnifyingGlassSelection();
    }

    public void setMagnification(double d) {
        String string = BSConstants.MAGNIFICATION_FORMAT.format(d);
        String string2 = BSResources.getString("choice.magnifyingGlass") + " (" + string + "x)";
        this._magnifyingGlassCheckBox.setText(string2);
    }

    public boolean isMagnifyingGlassSelected() {
        return this._magnifyingGlassCheckBox.isSelected();
    }

    public void setBottomPlotMode(BSBottomPlotMode bSBottomPlotMode) {
        if (bSBottomPlotMode == BSBottomPlotMode.WAVE_FUNCTION) {
            this._waveFunctionRadioButton.setSelected(true);
        } else if (bSBottomPlotMode == BSBottomPlotMode.PROBABILITY_DENSITY) {
            this._probabilityDensityRadioButton.setSelected(true);
        } else if (bSBottomPlotMode == BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY) {
            this._averageProbabilityDensityRadioButton.setSelected(true);
        } else {
            throw new UnsupportedOperationException("unsupported mode: " + bSBottomPlotMode);
        }
        this.handleDisplaySelection();
    }

    public BSBottomPlotMode getBottomPlotMode() {
        BSBottomPlotMode bSBottomPlotMode = BSBottomPlotMode.WAVE_FUNCTION;
        if (this._probabilityDensityRadioButton.isSelected()) {
            bSBottomPlotMode = BSBottomPlotMode.PROBABILITY_DENSITY;
        } else if (this._waveFunctionRadioButton.isSelected()) {
            bSBottomPlotMode = BSBottomPlotMode.WAVE_FUNCTION;
        } else if (this._averageProbabilityDensityRadioButton.isSelected()) {
            bSBottomPlotMode = BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY;
        } else {
            throw new UnsupportedOperationException("unsupported BSBottomPlotMode");
        }
        return bSBottomPlotMode;
    }

    public void setRealSelected(boolean bl) {
        this._realCheckBox.setSelected(bl);
        this.handleRealSelection();
    }

    public boolean isRealSelected() {
        return this._realCheckBox.isSelected();
    }

    public void setImaginarySelected(boolean bl) {
        this._imaginaryCheckBox.setSelected(bl);
        this.handleImaginarySelection();
    }

    public boolean isImaginarySelected() {
        return this._imaginaryCheckBox.isSelected();
    }

    public void setMagnitudeSelected(boolean bl) {
        this._magnitudeCheckBox.setSelected(bl);
        this.handleMagnitudeSelection();
    }

    public boolean isMagnitudeSelected() {
        return this._magnitudeCheckBox.isSelected();
    }

    public void setPhaseSelected(boolean bl) {
        this._phaseCheckBox.setSelected(bl);
        this.handlePhaseSelection();
    }

    public boolean isPhaseSelected() {
        return this._phaseCheckBox.isSelected();
    }

    public void setParticleMass(double d) {
        this._massMultiplierControl.setValue(d / 5.68);
        this.handleMassSlider();
    }

    public void setFieldConstant(double d) {
        if (this._fieldConstantControl != null) {
            this._fieldConstantControl.setValue(d);
        }
    }

    public double getFieldConstant() {
        double d = 0.0;
        if (this._fieldConstantControl != null) {
            d = this._fieldConstantControl.getValue();
        }
        return d;
    }

    public void setNumberOfWellsControlVisible(boolean bl) {
        if (this._numberOfWellsControl != null) {
            this._numberOfWellsControl.setVisible(bl);
        }
    }

    private void handleWellTypeSelection() {
        BSWellType bSWellType = this._wellTypeComboBox.getSelectedWellType();
        this._module.setWellType(bSWellType);
    }

    private void handleNumberOfWells() {
        if (this._numberOfWellsControl != null) {
            int n = (int)Math.round(this._numberOfWellsControl.getValue());
            this._module.setNumberOfWells(n);
        }
    }

    private void handleConfigureEnergyButton() {
        this._module.showConfigureDialog();
    }

    private void handleSuperpositionButton() {
        this._module.showSuperpositionStateDialog();
    }

    private void handleRealSelection() {
        this._module.setRealVisible(this._realCheckBox.isSelected());
    }

    private void handleImaginarySelection() {
        this._module.setImaginaryVisible(this._imaginaryCheckBox.isSelected());
    }

    private void handleMagnitudeSelection() {
        this._module.setMagnitudeVisible(this._magnitudeCheckBox.isSelected());
    }

    private void handlePhaseSelection() {
        this._module.setPhaseVisible(this._phaseCheckBox.isSelected());
    }

    private void handleDisplaySelection() {
        if (this._waveFunctionRadioButton.isSelected()) {
            this._module.setBottomPlotMode(BSBottomPlotMode.WAVE_FUNCTION);
            this._module.setRealVisible(this._realCheckBox.isSelected());
            this._module.setImaginaryVisible(this._imaginaryCheckBox.isSelected());
            this._module.setMagnitudeVisible(this._magnitudeCheckBox.isSelected());
            this._module.setPhaseVisible(this._phaseCheckBox.isSelected());
            this._realCheckBox.setEnabled(true);
            this._imaginaryCheckBox.setEnabled(true);
            this._magnitudeCheckBox.setEnabled(true);
            this._phaseCheckBox.setEnabled(true);
        } else if (this._probabilityDensityRadioButton.isSelected()) {
            this._module.setBottomPlotMode(BSBottomPlotMode.PROBABILITY_DENSITY);
            this._realCheckBox.setEnabled(false);
            this._imaginaryCheckBox.setEnabled(false);
            this._magnitudeCheckBox.setEnabled(false);
            this._phaseCheckBox.setEnabled(false);
        } else if (this._averageProbabilityDensityRadioButton.isSelected()) {
            this._module.setBottomPlotMode(BSBottomPlotMode.AVERAGE_PROBABILITY_DENSITY);
            this._realCheckBox.setEnabled(false);
            this._imaginaryCheckBox.setEnabled(false);
            this._magnitudeCheckBox.setEnabled(false);
            this._phaseCheckBox.setEnabled(false);
        }
    }

    private void handleMassSlider() {
        double d = this._massMultiplierControl.getValue() * 5.68;
        this._module.setParticleMass(d);
    }

    private void handleMagnifyingGlassSelection() {
        this._module.setMagnifyingGlassVisible(this._magnifyingGlassCheckBox.isSelected());
    }

    private void handleFieldConstantSlider() {
        if (this._fieldConstantControl != null) {
            double d = this._fieldConstantControl.getValue();
            this._module.setFieldConstant(d);
        }
    }

    private class EventListener
    implements ActionListener,
    ItemListener,
    ChangeListener {
        private boolean _isSliderDragging = false;
        private boolean _clockWasRunning = false;

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == BSControlPanel.this._configureEnergyButton) {
                BSControlPanel.this.handleConfigureEnergyButton();
            } else if (actionEvent.getSource() == BSControlPanel.this._superpositionButton) {
                BSControlPanel.this.handleSuperpositionButton();
            } else if (actionEvent.getSource() == BSControlPanel.this._realCheckBox) {
                BSControlPanel.this.handleRealSelection();
            } else if (actionEvent.getSource() == BSControlPanel.this._imaginaryCheckBox) {
                BSControlPanel.this.handleImaginarySelection();
            } else if (actionEvent.getSource() == BSControlPanel.this._magnitudeCheckBox) {
                BSControlPanel.this.handleMagnitudeSelection();
            } else if (actionEvent.getSource() == BSControlPanel.this._phaseCheckBox) {
                BSControlPanel.this.handlePhaseSelection();
            } else if (actionEvent.getSource() == BSControlPanel.this._waveFunctionRadioButton) {
                BSControlPanel.this.handleDisplaySelection();
            } else if (actionEvent.getSource() == BSControlPanel.this._probabilityDensityRadioButton) {
                BSControlPanel.this.handleDisplaySelection();
            } else if (actionEvent.getSource() == BSControlPanel.this._averageProbabilityDensityRadioButton) {
                BSControlPanel.this.handleDisplaySelection();
            } else if (actionEvent.getSource() == BSControlPanel.this._magnifyingGlassCheckBox) {
                BSControlPanel.this.handleMagnifyingGlassSelection();
            } else {
                throw new IllegalArgumentException("unexpected event: " + actionEvent);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == BSControlPanel.this._numberOfWellsControl) {
                BSControlPanel.this.handleNumberOfWells();
                this.adjustClockState(BSControlPanel.this._numberOfWellsControl);
            } else if (changeEvent.getSource() == BSControlPanel.this._fieldConstantControl) {
                BSControlPanel.this.handleFieldConstantSlider();
                this.adjustClockState(BSControlPanel.this._fieldConstantControl);
            } else if (changeEvent.getSource() == BSControlPanel.this._massMultiplierControl) {
                BSControlPanel.this.handleMassSlider();
                this.adjustClockState(BSControlPanel.this._massMultiplierControl);
            } else {
                throw new IllegalArgumentException("unexpected event: " + changeEvent);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (itemEvent.getSource() == BSControlPanel.this._wellTypeComboBox) {
                    BSControlPanel.this.handleWellTypeSelection();
                } else {
                    throw new IllegalArgumentException("unexpected event: " + itemEvent);
                }
            }
        }

        private void adjustClockState(AbstractValueControl abstractValueControl) {
            if (abstractValueControl.getNotifyWhileAdjusting()) {
                if (!abstractValueControl.isAdjusting()) {
                    this._isSliderDragging = false;
                    if (this._clockWasRunning) {
                        BSControlPanel.this._module.getClock().start();
                        this._clockWasRunning = false;
                    }
                } else if (!this._isSliderDragging) {
                    this._isSliderDragging = true;
                    this._clockWasRunning = BSControlPanel.this._module.getClock().isRunning();
                    if (this._clockWasRunning) {
                        BSControlPanel.this._module.getClock().pause();
                    }
                }
            }
        }
    }
}

