/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.boundstates.color;

import edu.colorado.phet.boundstates.BSAbstractApplication;
import edu.colorado.phet.boundstates.BSResources;
import edu.colorado.phet.boundstates.color.BSColorScheme;
import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.dialogs.ColorChooserFactory;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class BSColorSchemeDialog
extends PaintImmediateDialog
implements ColorChooserFactory.Listener {
    private static final Stroke COLOR_CHIP_STROKE = new BasicStroke(1.0f);
    private static final Color COLOR_CHIP_BORDER_COLOR = Color.BLACK;
    private Frame _parent;
    private BSAbstractApplication _app;
    private BSColorScheme _scheme;
    private BSColorScheme _restoreScheme;
    private JLabel _currentChip;
    private JLabel _chartChip;
    private JLabel _ticksChip;
    private JLabel _gridlinesChip;
    private JLabel _eigenstateNormalChip;
    private JLabel _eigenstateHiliteChip;
    private JLabel _eigenstateSelectionChip;
    private JLabel _potentialEnergyChip;
    private JLabel _realChip;
    private JLabel _imaginaryChip;
    private JLabel _magnitudeChip;
    private JLabel _magnifyingGlassBezelChip;
    private JLabel _magnifyingGlassHandleChip;
    private JLabel _dragHandleChip;
    private JLabel _dragHandleHiliteChip;
    private JLabel _dragHandleValueChip;
    private JLabel _dragHandleMarkersChip;
    private JButton _okButton;
    private JButton _cancelButton;
    private JDialog _colorChooserDialog;

    public BSColorSchemeDialog(BSAbstractApplication bSAbstractApplication, BSColorScheme bSColorScheme) {
        super(PhetApplication.getInstance().getPhetFrame());
        super.setTitle(BSResources.getString("title.colorScheme"));
        super.setModal(false);
        super.setResizable(false);
        this._parent = PhetApplication.getInstance().getPhetFrame();
        this._app = bSAbstractApplication;
        this._scheme = bSColorScheme;
        this._restoreScheme = new BSColorScheme(bSColorScheme);
        this.createUI();
        this.setLocationRelativeTo(this._parent);
    }

    private void createUI() {
        JPanel jPanel = this.createInputPanel();
        JPanel jPanel2 = this.createActionsPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new JSeparator(), "North");
        jPanel4.add((Component)jPanel2, "South");
        jPanel3.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel3);
        this.pack();
    }

    private JPanel createInputPanel() {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() instanceof JLabel) {
                    BSColorSchemeDialog.this.editColor((JLabel)mouseEvent.getSource());
                }
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        jPanel.setLayout(easyGridBagLayout);
        int n = 0;
        PhetFont phetFont = new PhetFont(1, PhetFont.getDefaultFontSize());
        JLabel jLabel = new JLabel(BSResources.getString("label.color.chartSection"));
        jLabel.setFont(phetFont);
        easyGridBagLayout.addAnchoredComponent(jLabel, n, 0, 17);
        jLabel = new JLabel(BSResources.getString("label.color.chartBackground"));
        this._chartChip = new JLabel();
        this.setColor(this._chartChip, this._scheme.getChartColor());
        this._chartChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._chartChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.ticks"));
        this._ticksChip = new JLabel();
        this.setColor(this._ticksChip, this._scheme.getTickColor());
        this._ticksChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._ticksChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.gridlines"));
        this._gridlinesChip = new JLabel();
        this.setColor(this._gridlinesChip, this._scheme.getGridlineColor());
        this._gridlinesChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._gridlinesChip, n, 1, 17);
        easyGridBagLayout.addFilledComponent(new JSeparator(), ++n, 0, 2, 1, 2);
        jLabel = new JLabel(BSResources.getString("label.color.energySection"));
        jLabel.setFont(phetFont);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 17);
        jLabel = new JLabel(BSResources.getString("label.color.potentialEnergy"));
        this._potentialEnergyChip = new JLabel();
        this.setColor(this._potentialEnergyChip, this._scheme.getPotentialEnergyColor());
        this._potentialEnergyChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._potentialEnergyChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.eigenstateNormal"));
        this._eigenstateNormalChip = new JLabel();
        this.setColor(this._eigenstateNormalChip, this._scheme.getEigenstateNormalColor());
        this._eigenstateNormalChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._eigenstateNormalChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.eigenstateHilite"));
        this._eigenstateHiliteChip = new JLabel();
        this.setColor(this._eigenstateHiliteChip, this._scheme.getEigenstateHiliteColor());
        this._eigenstateHiliteChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._eigenstateHiliteChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.eigenstateSelection"));
        this._eigenstateSelectionChip = new JLabel();
        this.setColor(this._eigenstateSelectionChip, this._scheme.getEigenstateSelectionColor());
        this._eigenstateSelectionChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._eigenstateSelectionChip, n, 1, 17);
        easyGridBagLayout.addFilledComponent(new JSeparator(), ++n, 0, 2, 1, 2);
        jLabel = new JLabel(BSResources.getString("label.color.waveFunctionSection"));
        jLabel.setFont(phetFont);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 17);
        jLabel = new JLabel(BSResources.getString("label.color.real"));
        this._realChip = new JLabel();
        this.setColor(this._realChip, this._scheme.getRealColor());
        this._realChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._realChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.imaginary"));
        this._imaginaryChip = new JLabel();
        this.setColor(this._imaginaryChip, this._scheme.getImaginaryColor());
        this._imaginaryChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._imaginaryChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.magnitude"));
        this._magnitudeChip = new JLabel();
        this.setColor(this._magnitudeChip, this._scheme.getMagnitudeColor());
        this._magnitudeChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._magnitudeChip, n, 1, 17);
        easyGridBagLayout.addFilledComponent(new JSeparator(), ++n, 0, 2, 1, 2);
        jLabel = new JLabel(BSResources.getString("label.color.magnifyingGlassSection"));
        jLabel.setFont(phetFont);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 17);
        jLabel = new JLabel(BSResources.getString("label.color.magnifyingGlassBezel"));
        this._magnifyingGlassBezelChip = new JLabel();
        this.setColor(this._magnifyingGlassBezelChip, this._scheme.getMagnifyingGlassBezelColor());
        this._magnifyingGlassBezelChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._magnifyingGlassBezelChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.magnifyingGlassHandle"));
        this._magnifyingGlassHandleChip = new JLabel();
        this.setColor(this._magnifyingGlassHandleChip, this._scheme.getMagnifyingGlassHandleColor());
        this._magnifyingGlassHandleChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._magnifyingGlassHandleChip, n, 1, 17);
        easyGridBagLayout.addFilledComponent(new JSeparator(), ++n, 0, 2, 1, 2);
        jLabel = new JLabel(BSResources.getString("label.color.dragHandleSection"));
        jLabel.setFont(phetFont);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 17);
        jLabel = new JLabel(BSResources.getString("label.color.dragHandle"));
        this._dragHandleChip = new JLabel();
        this.setColor(this._dragHandleChip, this._scheme.getDragHandleColor());
        this._dragHandleChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._dragHandleChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.dragHandleHilite"));
        this._dragHandleHiliteChip = new JLabel();
        this.setColor(this._dragHandleHiliteChip, this._scheme.getDragHandleHiliteColor());
        this._dragHandleHiliteChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._dragHandleHiliteChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.dragHandleValue"));
        this._dragHandleValueChip = new JLabel();
        this.setColor(this._dragHandleValueChip, this._scheme.getDragHandleValueColor());
        this._dragHandleValueChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._dragHandleValueChip, n, 1, 17);
        jLabel = new JLabel(BSResources.getString("label.color.dragHandleMarkers"));
        this._dragHandleMarkersChip = new JLabel();
        this.setColor(this._dragHandleMarkersChip, this._scheme.getDragHandleMarkersColor());
        this._dragHandleMarkersChip.addMouseListener(mouseInputAdapter);
        easyGridBagLayout.addAnchoredComponent(jLabel, ++n, 0, 13);
        easyGridBagLayout.addAnchoredComponent(this._dragHandleMarkersChip, n, 1, 17);
        ++n;
        return jPanel;
    }

    private JPanel createActionsPanel() {
        this._okButton = new JButton(BSResources.getString("choice.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BSColorSchemeDialog.this.dispose();
            }
        });
        this._cancelButton = new JButton(BSResources.getString("choice.cancel"));
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BSColorSchemeDialog.this.restoreColors();
                BSColorSchemeDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        jPanel.add(this._okButton);
        jPanel.add(this._cancelButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    private void editColor(JLabel jLabel) {
        this._currentChip = jLabel;
        String string = null;
        Color color = null;
        if (this._currentChip == this._chartChip) {
            string = BSResources.getString("label.color.chartBackground");
            color = this._scheme.getChartColor();
        } else if (this._currentChip == this._ticksChip) {
            string = BSResources.getString("label.color.ticks");
            color = this._scheme.getTickColor();
        } else if (this._currentChip == this._gridlinesChip) {
            string = BSResources.getString("label.color.gridlines");
            color = this._scheme.getGridlineColor();
        } else if (this._currentChip == this._eigenstateNormalChip) {
            string = BSResources.getString("label.color.eigenstateNormal");
            color = this._scheme.getEigenstateNormalColor();
        } else if (this._currentChip == this._eigenstateHiliteChip) {
            string = BSResources.getString("label.color.eigenstateHilite");
            color = this._scheme.getEigenstateHiliteColor();
        } else if (this._currentChip == this._eigenstateSelectionChip) {
            string = BSResources.getString("label.color.eigenstateSelection");
            color = this._scheme.getEigenstateSelectionColor();
        } else if (this._currentChip == this._potentialEnergyChip) {
            string = BSResources.getString("label.color.potentialEnergy");
            color = this._scheme.getPotentialEnergyColor();
        } else if (this._currentChip == this._realChip) {
            string = BSResources.getString("label.color.real");
            color = this._scheme.getRealColor();
        } else if (this._currentChip == this._imaginaryChip) {
            string = BSResources.getString("label.color.imaginary");
            color = this._scheme.getImaginaryColor();
        } else if (this._currentChip == this._magnitudeChip) {
            string = BSResources.getString("label.color.magnitude");
            color = this._scheme.getMagnitudeColor();
        } else if (this._currentChip == this._magnifyingGlassBezelChip) {
            string = BSResources.getString("label.color.magnifyingGlassBezel");
            color = this._scheme.getMagnifyingGlassBezelColor();
        } else if (this._currentChip == this._magnifyingGlassHandleChip) {
            string = BSResources.getString("label.color.magnifyingGlassHandle");
            color = this._scheme.getMagnifyingGlassHandleColor();
        } else if (this._currentChip == this._dragHandleChip) {
            string = BSResources.getString("label.color.dragHandle");
            color = this._scheme.getDragHandleColor();
        } else if (this._currentChip == this._dragHandleHiliteChip) {
            string = BSResources.getString("label.color.dragHandleHilite");
            color = this._scheme.getDragHandleHiliteColor();
        } else if (this._currentChip == this._dragHandleValueChip) {
            string = BSResources.getString("label.color.dragHandleValue");
            color = this._scheme.getDragHandleValueColor();
        } else if (this._currentChip == this._dragHandleMarkersChip) {
            string = BSResources.getString("label.color.dragHandleMarkers");
            color = this._scheme.getDragHandleMarkersColor();
        } else {
            throw new IllegalStateException("unsupported color scheme property");
        }
        String string2 = string + " " + BSResources.getString("title.chooseColor");
        this.closeColorChooser();
        this._colorChooserDialog = ColorChooserFactory.createDialog(string2, this._parent, color, this);
        this._colorChooserDialog.setVisible(true);
    }

    private void restoreColors() {
        this._app.setColorScheme(this._restoreScheme);
        this._scheme.copy(this._restoreScheme);
    }

    private void closeColorChooser() {
        if (this._colorChooserDialog != null) {
            this._colorChooserDialog.dispose();
        }
    }

    private void setColor(JLabel jLabel, Color color) {
        Rectangle rectangle = new Rectangle(0, 0, 30, 30);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(rectangle);
        graphics2D.setStroke(COLOR_CHIP_STROKE);
        graphics2D.setColor(COLOR_CHIP_BORDER_COLOR);
        graphics2D.draw(rectangle);
        jLabel.setIcon(new ImageIcon(bufferedImage));
    }

    public void dispose() {
        this.closeColorChooser();
        super.dispose();
    }

    public void colorChanged(Color color) {
        this.handleColorChange(color);
    }

    public void ok(Color color) {
        this.handleColorChange(color);
    }

    public void cancelled(Color color) {
        this.handleColorChange(color);
    }

    private void handleColorChange(Color color) {
        this.setColor(this._currentChip, color);
        if (this._currentChip == this._chartChip) {
            this._scheme.setChartColor(color);
        } else if (this._currentChip == this._ticksChip) {
            this._scheme.setTickColor(color);
        } else if (this._currentChip == this._gridlinesChip) {
            this._scheme.setGridlineColor(color);
        } else if (this._currentChip == this._eigenstateNormalChip) {
            this._scheme.setEigenstateNormalColor(color);
        } else if (this._currentChip == this._eigenstateHiliteChip) {
            this._scheme.setEigenstateHiliteColor(color);
        } else if (this._currentChip == this._eigenstateSelectionChip) {
            this._scheme.setEigenstateSelectionColor(color);
        } else if (this._currentChip == this._potentialEnergyChip) {
            this._scheme.setPotentialEnergyColor(color);
        } else if (this._currentChip == this._realChip) {
            this._scheme.setRealColor(color);
        } else if (this._currentChip == this._imaginaryChip) {
            this._scheme.setImaginaryColor(color);
        } else if (this._currentChip == this._magnitudeChip) {
            this._scheme.setMagnitudeColor(color);
        } else if (this._currentChip == this._magnifyingGlassBezelChip) {
            this._scheme.setMagnifyingGlassBezelColor(color);
        } else if (this._currentChip == this._magnifyingGlassHandleChip) {
            this._scheme.setMagnifyingGlassHandleColor(color);
        } else if (this._currentChip == this._dragHandleChip) {
            this._scheme.setDragHandleColor(color);
        } else if (this._currentChip == this._dragHandleHiliteChip) {
            this._scheme.setDragHandleHiliteColor(color);
        } else if (this._currentChip == this._dragHandleValueChip) {
            this._scheme.setDragHandleValueColor(color);
        } else if (this._currentChip == this._dragHandleMarkersChip) {
            this._scheme.setDragHandleMarkersColor(color);
        } else {
            throw new IllegalStateException("unsupported color scheme property");
        }
        this._app.setColorScheme(this._scheme);
    }
}

