/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLConstants;
import edu.colorado.phet.beerslawlab.common.model.Solvent;
import edu.colorado.phet.beerslawlab.concentration.model.Beaker;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.beerslawlab.concentration.model.Dropper;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StockSolutionNode
extends PPath {
    public StockSolutionNode(final Solvent solvent, final Property<Solute> property, final Dropper dropper, final Beaker beaker, final double d) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.setStroke(BLLConstants.FLUID_STROKE);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                if (dropper.on.get().booleanValue() && !dropper.empty.get().booleanValue()) {
                    StockSolutionNode.this.setPathTo(new Rectangle2D.Double(-d / 2.0, 0.0, d, beaker.location.getY() - dropper.getY()));
                } else {
                    StockSolutionNode.this.setPathTo(new Rectangle2D.Double());
                }
                StockSolutionNode.this.setOffset(((ImmutableVector2D)dropper.location.get()).toPoint2D());
            }
        };
        richSimpleObserver.observe(dropper.location, dropper.on, dropper.empty);
        final RichSimpleObserver richSimpleObserver2 = new RichSimpleObserver(){

            public void update() {
                Color color = ConcentrationSolution.createColor(solvent, (Solute)property.get(), ((Solute)property.get()).stockSolutionConcentration);
                StockSolutionNode.this.setPaint(color);
                StockSolutionNode.this.setStrokePaint(BLLConstants.createFluidStrokeColor(color));
            }
        };
        richSimpleObserver2.observe(property, property.get().colorScheme);
        property.addObserver(new ChangeObserver<Solute>(){

            @Override
            public void update(Solute solute, Solute solute2) {
                solute2.colorScheme.removeObserver(richSimpleObserver2);
                solute.colorScheme.addObserver(richSimpleObserver2);
            }
        });
        dropper.visible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                StockSolutionNode.this.setVisible(bl);
            }
        });
    }
}

