/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.common.view.SoluteItemNode;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.beerslawlab.concentration.model.SoluteColorScheme;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ComboBoxNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SoluteChoiceNode
extends PhetPNode {
    private final SoluteComboBoxNode comboBoxNode;

    public SoluteChoiceNode(ArrayList<Solute> arrayList, final Property<Solute> property) {
        PText pText = new PText(MessageFormat.format(BLLResources.Strings.PATTERN_0LABEL, BLLResources.Strings.SOLUTE)){
            {
                this.setFont(new PhetFont(18));
            }
        };
        this.addChild(pText);
        this.comboBoxNode = new SoluteComboBoxNode(arrayList, property.get());
        this.addChild(this.comboBoxNode);
        double d = this.comboBoxNode.getFullBoundsReference().getHeight() - pText.getFullBoundsReference().getHeight();
        pText.setOffset(0.0, Math.max(0.0, d / 2.0));
        this.comboBoxNode.setOffset(pText.getFullBoundsReference().getMaxX() + 5.0, Math.min(0.0, d / 2.0));
        property.addObserver(new VoidFunction1<Solute>(){

            @Override
            public void apply(Solute solute) {
                ((SoluteChoiceNode)SoluteChoiceNode.this).comboBoxNode.selectedItem.set(solute);
            }
        });
        this.comboBoxNode.selectedItem.addObserver(new VoidFunction1<Solute>(){

            @Override
            public void apply(Solute solute) {
                property.set(solute);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SoluteComboBoxNode
    extends ComboBoxNode<Solute> {
        public SoluteComboBoxNode(ArrayList<Solute> arrayList, Solute solute) {
            super(BLLSimSharing.UserComponents.soluteComboBox, new Function1<Solute, String>(){

                @Override
                public String apply(Solute solute) {
                    return solute.name;
                }
            }, arrayList, solute, new Function1<Solute, PNode>(){

                @Override
                public PNode apply(final Solute solute) {
                    final Property<Color> property = new Property<Color>(solute.colorScheme.get().maxColor);
                    solute.colorScheme.addObserver(new VoidFunction1<SoluteColorScheme>(){

                        @Override
                        public void apply(SoluteColorScheme soluteColorScheme) {
                            property.set(solute.colorScheme.get().maxColor);
                        }
                    });
                    return new SoluteItemNode(property, solute.getDisplayName());
                }
            });
        }
    }
}

