/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.geom.RoundRectangle2D;

class SaturatedIndicatorNode
extends PComposite {
    public SaturatedIndicatorNode(final ConcentrationSolution concentrationSolution) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        PText pText = new PText(BLLResources.Strings.SATURATED){
            {
                this.setFont(new PhetFont(20));
            }
        };
        double d = 1.2 * pText.getFullBoundsReference().getWidth();
        double d2 = 1.2 * pText.getFullBoundsReference().getHeight();
        PPath pPath = new PPath(new RoundRectangle2D.Double(0.0, 0.0, d, d2, 8.0, 8.0)){
            {
                this.setPaint(ColorUtils.createColor(new Color(240, 240, 240), 150));
                this.setStroke(null);
            }
        };
        this.addChild(pPath);
        this.addChild(pText);
        pText.setOffset(pPath.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0, pPath.getFullBoundsReference().getCenterY() - pText.getFullBoundsReference().getHeight() / 2.0);
        concentrationSolution.concentration.addObserver(new SimpleObserver(){

            public void update() {
                SaturatedIndicatorNode.this.setVisible(concentrationSolution.isSaturated());
            }
        });
    }
}

