/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLConstants;
import edu.colorado.phet.beerslawlab.common.model.IFluid;
import edu.colorado.phet.beerslawlab.concentration.model.Faucet;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.geom.Rectangle2D;

class FaucetFluidNode
extends PPath {
    public FaucetFluidNode(final Faucet faucet, final IFluid iFluid, final double d, final double d2) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.setStroke(BLLConstants.FLUID_STROKE);
        this.setStrokePaint(BLLConstants.createFluidStrokeColor(iFluid.getFluidColor()));
        this.setOffset(faucet.location.toPoint2D());
        iFluid.addFluidColorObserver(new SimpleObserver(){

            public void update() {
                FaucetFluidNode.this.setPaint(iFluid.getFluidColor());
            }
        });
        faucet.flowRate.addObserver(new SimpleObserver(){

            public void update() {
                if (faucet.flowRate.get() == 0.0) {
                    FaucetFluidNode.this.setPathTo(new Rectangle2D.Double());
                } else {
                    double d3 = d * faucet.flowRate.get() / faucet.maxFlowRate;
                    FaucetFluidNode.this.setPathTo(new Rectangle2D.Double(-d3 / 2.0, 0.0, d3, d2));
                }
            }
        });
    }
}

