/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.concentration.model.Evaporator;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.slider.HSliderNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PText;

class EvaporationControlNode
extends ControlPanelNode {
    public EvaporationControlNode(final Evaporator evaporator) {
        super((PNode)new HBox(new PText(BLLResources.Strings.EVAPORATION){
            {
                this.setFont(new PhetFont(18));
            }
        }, new HSliderNode(BLLSimSharing.UserComponents.evaporationSlider, 0.0, evaporator.maxEvaporationRate, evaporator.evaporationRate, evaporator.enabled){
            {
                super(iUserComponent, d, d2, settableProperty, observableProperty);
                PhetFont phetFont = new PhetFont(14);
                this.addLabel(0.0, new PhetPText(BLLResources.Strings.NONE, phetFont));
                this.addLabel(evaporator.maxEvaporationRate, new PhetPText(BLLResources.Strings.LOTS, phetFont));
                this.addInputEventListener(new PBasicInputEventHandler(){

                    public void mouseReleased(PInputEvent pInputEvent) {
                        evaporator.evaporationRate.set(0.0);
                    }
                });
            }
        }));
    }
}

