/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationModel;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class ConcentrationModelDialog
extends JDialog {
    public ConcentrationModelDialog(Frame frame, ConcentrationModel concentrationModel) {
        super(frame, "Model Properties (dev)");
        this.setResizable(false);
        this.setContentPane(new ConcentrationModelPanel(concentrationModel));
        this.pack();
    }

    public static class ConcentrationModelButton
    extends JButton {
        private JDialog dialog;

        public ConcentrationModelButton(final Frame frame, final ConcentrationModel concentrationModel) {
            super("Model Properties (dev)");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ConcentrationModelButton.this.dialog == null) {
                        ConcentrationModelButton.this.dialog = new ConcentrationModelDialog(frame, concentrationModel);
                        SwingUtils.centerInParent(ConcentrationModelButton.this.dialog);
                    }
                    if (!ConcentrationModelButton.this.dialog.isVisible()) {
                        ConcentrationModelButton.this.dialog.setVisible(true);
                    }
                }
            });
        }
    }

    private static class ConcentrationModelPanel
    extends VerticalLayoutPanel {
        public ConcentrationModelPanel(final ConcentrationModel concentrationModel) {
            this.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.setInsets(new Insets(2, 2, 2, 2));
            final JLabel jLabel = new JLabel();
            final JLabel jLabel2 = new JLabel();
            final JLabel jLabel3 = new JLabel();
            final JLabel jLabel4 = new JLabel();
            final JLabel jLabel5 = new JLabel();
            final JLabel jLabel6 = new JLabel();
            final JLabel jLabel7 = new JLabel();
            final JLabel jLabel8 = new JLabel();
            final JLabel jLabel9 = new JLabel();
            final JLabel jLabel10 = new JLabel();
            final JLabel jLabel11 = new JLabel();
            final JLabel jLabel12 = new JLabel();
            final JLabel jLabel13 = new JLabel();
            final JLabel jLabel14 = new JLabel();
            final JLabel jLabel15 = new JLabel();
            final JLabel jLabel16 = new JLabel();
            final JLabel jLabel17 = new JLabel();
            final JLabel jLabel18 = new JLabel();
            this.add(new HeadingLabel("solute:"));
            this.add(jLabel7);
            this.add(jLabel6);
            this.add(jLabel17);
            this.add(jLabel18);
            this.add(Box.createVerticalStrut(5));
            this.add(new HeadingLabel("solution:"));
            this.add(jLabel11);
            this.add(jLabel12);
            this.add(jLabel8);
            this.add(jLabel9);
            this.add(jLabel10);
            this.add(Box.createVerticalStrut(5));
            this.add(new HeadingLabel("rates:"));
            this.add(jLabel3);
            this.add(jLabel4);
            this.add(jLabel);
            this.add(jLabel15);
            this.add(jLabel16);
            this.add(Box.createVerticalStrut(5));
            this.add(new HeadingLabel("locations:"));
            this.add(jLabel5);
            this.add(jLabel2);
            this.add(jLabel13);
            this.add(jLabel14);
            final DecimalFormat decimalFormat = new DecimalFormat("0.000");
            final DecimalFormat decimalFormat2 = new DecimalFormat("0.00");
            final DecimalFormat decimalFormat3 = new DecimalFormat("0.0000");
            final DecimalFormat decimalFormat4 = new DecimalFormat("0.000");
            concentrationModel.dropper.location.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel2.setText("dropper = (" + (int)((ImmutableVector2D)concentrationModel.dropper.location.get()).getX() + "," + (int)((ImmutableVector2D)concentrationModel.dropper.location.get()).getY() + ")");
                }
            });
            concentrationModel.evaporator.evaporationRate.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel.setText("evaporation = " + decimalFormat.format(concentrationModel.evaporator.evaporationRate.get()) + " L/sec");
                }
            });
            concentrationModel.solventFaucet.flowRate.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel3.setText("solvent faucet = " + decimalFormat.format(concentrationModel.solventFaucet.flowRate.get()) + " L/sec");
                }
            });
            concentrationModel.drainFaucet.flowRate.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel4.setText("drain faucet = " + decimalFormat.format(concentrationModel.drainFaucet.flowRate.get()) + " L/sec");
                }
            });
            concentrationModel.shaker.location.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel5.setText("shaker = (" + (int)((ImmutableVector2D)concentrationModel.shaker.location.get()).getX() + "," + (int)((ImmutableVector2D)concentrationModel.shaker.location.get()).getY() + ")");
                }
            });
            concentrationModel.solute.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel7.setText(HTMLUtils.toHTMLString("formula = " + concentrationModel.solute.get().formula));
                    jLabel17.setText("saturated concentration = " + decimalFormat4.format(concentrationModel.solute.get().getSaturatedConcentration()) + " M");
                    jLabel18.setText("stock concentration = " + decimalFormat4.format(concentrationModel.solute.get().stockSolutionConcentration) + " M");
                }
            });
            concentrationModel.soluteForm.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel6.setText("form = " + (Object)((Object)concentrationModel.soluteForm.get()));
                }
            });
            concentrationModel.solution.concentration.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel8.setText("concentration = " + decimalFormat4.format(concentrationModel.solution.concentration.get()) + " M");
                }
            });
            concentrationModel.solution.precipitateAmount.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel9.setText("precipitate amount = " + decimalFormat3.format(concentrationModel.solution.precipitateAmount.get()) + " mol");
                    jLabel10.setText("precipitate particles = " + concentrationModel.solution.getNumberOfPrecipitateParticles());
                }
            });
            concentrationModel.solution.soluteAmount.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel11.setText("solute amount = " + decimalFormat3.format(concentrationModel.solution.soluteAmount.get()) + " mol");
                }
            });
            concentrationModel.solution.volume.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel12.setText("volume = " + decimalFormat2.format(concentrationModel.solution.volume.get()) + " L");
                }
            });
            concentrationModel.concentrationMeter.body.location.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel13.setText("meter = (" + (int)concentrationModel.concentrationMeter.body.location.get().getX() + "," + (int)concentrationModel.concentrationMeter.body.location.get().getY() + ")");
                }
            });
            concentrationModel.concentrationMeter.probe.location.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel14.setText("probe = (" + (int)concentrationModel.concentrationMeter.probe.location.get().getX() + "," + (int)concentrationModel.concentrationMeter.probe.location.get().getY() + ")");
                }
            });
            concentrationModel.shaker.addDispensingRateObserver(new SimpleObserver(){

                public void update() {
                    jLabel15.setText("shaker = " + decimalFormat.format(concentrationModel.shaker.getDispensingRate()) + " mol/sec");
                }
            });
            concentrationModel.dropper.flowRate.addObserver(new SimpleObserver(){

                public void update() {
                    jLabel16.setText("dropper = " + decimalFormat.format(concentrationModel.dropper.flowRate.get()) + " L/sec");
                }
            });
        }
    }

    private static class HeadingLabel
    extends JLabel {
        public HeadingLabel(String string) {
            super(string);
            this.setFont(new PhetFont(1, 12));
        }
    }
}

