/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.common.view.BLLCanvas;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationModel;
import edu.colorado.phet.beerslawlab.concentration.view.BLLFaucetNode;
import edu.colorado.phet.beerslawlab.concentration.view.BeakerNode;
import edu.colorado.phet.beerslawlab.concentration.view.ColorSchemeEditorDialog;
import edu.colorado.phet.beerslawlab.concentration.view.ConcentrationMeterNode;
import edu.colorado.phet.beerslawlab.concentration.view.ConcentrationModelDialog;
import edu.colorado.phet.beerslawlab.concentration.view.DropperNode;
import edu.colorado.phet.beerslawlab.concentration.view.EvaporationControlNode;
import edu.colorado.phet.beerslawlab.concentration.view.FaucetFluidNode;
import edu.colorado.phet.beerslawlab.concentration.view.PrecipitateNode;
import edu.colorado.phet.beerslawlab.concentration.view.RemoveSoluteButtonNode;
import edu.colorado.phet.beerslawlab.concentration.view.SaturatedIndicatorNode;
import edu.colorado.phet.beerslawlab.concentration.view.ShakerNode;
import edu.colorado.phet.beerslawlab.concentration.view.ShakerParticlesNode;
import edu.colorado.phet.beerslawlab.concentration.view.SoluteControlsNode;
import edu.colorado.phet.beerslawlab.concentration.view.SolutionNode;
import edu.colorado.phet.beerslawlab.concentration.view.StockSolutionNode;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Frame;

public class ConcentrationCanvas
extends BLLCanvas {
    public ConcentrationCanvas(ConcentrationModel concentrationModel, Frame frame) {
        BeakerNode beakerNode = new BeakerNode(concentrationModel.beaker, BeakerNode.TicksLocation.LEFT);
        SolutionNode solutionNode = new SolutionNode(concentrationModel.solution, concentrationModel.beaker);
        PrecipitateNode precipitateNode = new PrecipitateNode(concentrationModel.precipitate);
        SaturatedIndicatorNode saturatedIndicatorNode = new SaturatedIndicatorNode(concentrationModel.solution);
        ShakerNode shakerNode = new ShakerNode(concentrationModel.shaker);
        ShakerParticlesNode shakerParticlesNode = new ShakerParticlesNode(concentrationModel.shakerParticles);
        DropperNode dropperNode = new DropperNode(concentrationModel.dropper, concentrationModel.solution.solvent, concentrationModel.solution.solute);
        StockSolutionNode stockSolutionNode = new StockSolutionNode(concentrationModel.solution.solvent, concentrationModel.solute, concentrationModel.dropper, concentrationModel.beaker, 15.0);
        BLLFaucetNode bLLFaucetNode = new BLLFaucetNode(BLLSimSharing.UserComponents.solventFaucet, concentrationModel.solventFaucet);
        BLLFaucetNode bLLFaucetNode2 = new BLLFaucetNode(BLLSimSharing.UserComponents.drainFaucet, concentrationModel.drainFaucet);
        double d = concentrationModel.beaker.location.getY() - concentrationModel.solventFaucet.location.getY();
        FaucetFluidNode faucetFluidNode = new FaucetFluidNode(concentrationModel.solventFaucet, concentrationModel.solution.solvent, bLLFaucetNode.getFluidWidth(), d);
        FaucetFluidNode faucetFluidNode2 = new FaucetFluidNode(concentrationModel.drainFaucet, concentrationModel.solution, bLLFaucetNode2.getFluidWidth(), 1000.0);
        ConcentrationMeterNode concentrationMeterNode = new ConcentrationMeterNode(concentrationModel.concentrationMeter, concentrationModel.solution, concentrationModel.dropper, (PNode)solutionNode, (PNode)stockSolutionNode, (PNode)faucetFluidNode, (PNode)faucetFluidNode2);
        SoluteControlsNode soluteControlsNode = new SoluteControlsNode(concentrationModel.getSolutes(), concentrationModel.solute, concentrationModel.soluteForm);
        EvaporationControlNode evaporationControlNode = new EvaporationControlNode(concentrationModel.evaporator);
        RemoveSoluteButtonNode removeSoluteButtonNode = new RemoveSoluteButtonNode(concentrationModel.solution, concentrationModel.shakerParticles);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(concentrationModel, frame, 18, Color.BLACK, Color.ORANGE){
            {
                this.setConfirmationEnabled(false);
            }
        };
        PSwing pSwing = new PSwing(new ConcentrationModelDialog.ConcentrationModelButton(frame, concentrationModel));
        PSwing pSwing2 = new PSwing(new ColorSchemeEditorDialog.ColorSchemeEditorButton(frame, concentrationModel));
        this.addChild(faucetFluidNode);
        this.addChild(bLLFaucetNode);
        this.addChild(faucetFluidNode2);
        this.addChild(bLLFaucetNode2);
        this.addChild(stockSolutionNode);
        this.addChild(solutionNode);
        this.addChild(beakerNode);
        this.addChild(precipitateNode);
        this.addChild(saturatedIndicatorNode);
        this.addChild(shakerParticlesNode);
        this.addChild(shakerNode);
        this.addChild(dropperNode);
        this.addChild(evaporationControlNode);
        this.addChild(removeSoluteButtonNode);
        this.addChild(resetAllButtonNode);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addChild(pSwing);
            this.addChild(pSwing2);
        }
        this.addChild(concentrationMeterNode);
        this.addChild(soluteControlsNode);
        solutionNode.setOffset(beakerNode.getOffset());
        precipitateNode.setOffset(beakerNode.getOffset());
        saturatedIndicatorNode.setOffset(beakerNode.getFullBoundsReference().getCenterX() - saturatedIndicatorNode.getFullBoundsReference().getWidth() / 2.0, beakerNode.getFullBoundsReference().getMaxY() - saturatedIndicatorNode.getFullBoundsReference().getHeight() - 30.0);
        soluteControlsNode.setOffset(this.getStageSize().getWidth() - soluteControlsNode.getFullBoundsReference().getWidth() - 20.0, 20.0);
        evaporationControlNode.setOffset(beakerNode.getFullBoundsReference().getMinX() + 20.0, beakerNode.getFullBoundsReference().getMaxY() + 20.0);
        ((PNode)removeSoluteButtonNode).setOffset(evaporationControlNode.getFullBoundsReference().getMaxX() + 10.0, evaporationControlNode.getFullBoundsReference().getCenterY() - removeSoluteButtonNode.getFullBoundsReference().getHeight() / 2.0);
        ((PNode)resetAllButtonNode).setOffset(this.getStageSize().getWidth() - resetAllButtonNode.getFullBoundsReference().getWidth() - 20.0, this.getStageSize().getHeight() - resetAllButtonNode.getFullBoundsReference().getHeight() - 20.0);
        pSwing.setOffset(soluteControlsNode.getFullBoundsReference().getMaxX() - pSwing.getFullBoundsReference().getWidth(), soluteControlsNode.getFullBoundsReference().getMaxY() + 5.0);
        pSwing2.setOffset(pSwing.getFullBoundsReference().getMinX() - pSwing2.getFullBoundsReference().getWidth() - 5.0, pSwing.getYOffset());
        PNode pNode = concentrationMeterNode.bodyNode;
        if (pNode.getFullBoundsReference().getMaxX() > this.getStageSize().getWidth()) {
            double d2 = this.getStageSize().getWidth() - pNode.getFullBoundsReference().getWidth() - 4.0;
            double d3 = concentrationModel.concentrationMeter.body.location.get().getY();
            concentrationModel.concentrationMeter.body.location.set(new ImmutableVector2D(d2, d3));
        }
    }
}

