/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.model.Solvent;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationModel;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.beerslawlab.concentration.model.SoluteColorScheme;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.ColorControl;
import edu.colorado.phet.common.phetcommon.view.controls.DoubleSpinner;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ColorSchemeEditorDialog
extends JDialog {
    public ColorSchemeEditorDialog(Frame frame, ConcentrationModel concentrationModel) {
        super(frame, "Color Scheme Editor (dev)");
        this.setResizable(false);
        this.setContentPane(new ColorSchemeEditorCanvas(frame, concentrationModel));
        this.pack();
    }

    private static String toString(SoluteColorScheme soluteColorScheme) {
        return soluteColorScheme.minConcentration + ", " + ColorSchemeEditorDialog.toString(soluteColorScheme.minColor) + ", " + soluteColorScheme.midConcentration + ", " + ColorSchemeEditorDialog.toString(soluteColorScheme.midColor) + ", " + soluteColorScheme.maxConcentration + ", " + ColorSchemeEditorDialog.toString(soluteColorScheme.maxColor);
    }

    private static String toString(Color color) {
        if (color.equals(Solvent.Water.COLOR)) {
            return "Water.COLOR";
        }
        return "new Color( " + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + " )";
    }

    private static class ColorControlNode
    extends PNode {
        private final ColorControl colorControl;

        public ColorControlNode(Frame frame, String string, Color color) {
            this.colorControl = new ColorControl(frame, string, color);
            this.colorControl.setOpaque(false);
            this.addChild(new PSwing(this.colorControl));
        }

        public Color getColor() {
            return this.colorControl.getColor();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.colorControl.addChangeListener(changeListener);
        }
    }

    public static class ColorSchemeEditorButton
    extends JButton {
        private JDialog dialog;

        public ColorSchemeEditorButton(final Frame frame, final ConcentrationModel concentrationModel) {
            super("dev", new ImageIcon(BLLResources.Images.COLOR_SCHEME_EDITOR_ICON));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ColorSchemeEditorButton.this.dialog == null) {
                        ColorSchemeEditorButton.this.dialog = new ColorSchemeEditorDialog(frame, concentrationModel);
                        SwingUtils.centerInParent(ColorSchemeEditorButton.this.dialog);
                    }
                    if (!ColorSchemeEditorButton.this.dialog.isVisible()) {
                        ColorSchemeEditorButton.this.dialog.setVisible(true);
                    }
                }
            });
        }
    }

    private static class ColorSchemeEditorCanvas
    extends PhetPCanvas {
        private static final Dimension CANVAS_SIZE = new Dimension(700, 500);

        public ColorSchemeEditorCanvas(Frame frame, final ConcentrationModel concentrationModel) {
            PNode pNode;
            this.setBackground(new Color(240, 240, 240));
            this.setPreferredSize(CANVAS_SIZE);
            PText pText = new PText("    solute           min                mid                  max                     gradient");
            pText.setFont(new PhetFont(1, 14));
            pText.setOffset(30.0, 10.0);
            this.addChild(pText);
            PNode pNode2 = pText;
            final ArrayList<Solute> arrayList = concentrationModel.getSolutes();
            for (Solute object2 : arrayList) {
                pNode = new SoluteColorSchemeNode(frame, object2);
                this.addChild(pNode);
                pNode.setOffset(CANVAS_SIZE.getWidth() - pNode.getFullBoundsReference().getWidth() - 20.0, pNode2.getFullBoundsReference().getMaxY() + 30.0);
                pNode2 = pNode;
            }
            final Property<Color> property = concentrationModel.solution.solvent.color;
            final ColorControlNode colorControlNode = new ColorControlNode(frame, "Water:", (Color)property.get());
            this.addChild(colorControlNode);
            colorControlNode.setOffset(pNode2.getXOffset(), pNode2.getFullBoundsReference().getMaxY() + 30.0);
            colorControlNode.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    property.set(colorControlNode.getColor());
                }
            });
            pNode = new TextButtonNode("Print to Java Console", new PhetFont(12), Color.ORANGE);
            ((ButtonNode)pNode).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.out.println(concentrationModel.solution.solvent.name + "," + property.get());
                    for (Solute solute : arrayList) {
                        System.out.println(solute.name + ": " + ColorSchemeEditorDialog.toString(solute.colorScheme.get()));
                    }
                }
            });
            this.addChild(pNode);
            ((PhetPNode)pNode).setOffset(CANVAS_SIZE.getWidth() - pNode.getFullBoundsReference().getWidth() - 20.0, CANVAS_SIZE.getHeight() - pNode.getFullBoundsReference().getHeight() - 10.0);
        }

        public void addChild(PNode pNode) {
            this.getLayer().addChild(pNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GradientNode
    extends PComposite {
        private static final Dimension GRADIENT_SIZE = new Dimension(200, 25);

        public GradientNode(Property<SoluteColorScheme> property) {
            final PPath pPath = new PPath();
            pPath.setStroke(null);
            final PPath pPath2 = new PPath();
            pPath2.setStroke(null);
            PPath pPath3 = new PPath(new Rectangle2D.Double(0.0, 0.0, GradientNode.GRADIENT_SIZE.width, GradientNode.GRADIENT_SIZE.height));
            this.addChild(pPath);
            this.addChild(pPath2);
            this.addChild(pPath3);
            property.addObserver(new VoidFunction1<SoluteColorScheme>(){

                @Override
                public void apply(SoluteColorScheme soluteColorScheme) {
                    double d = (double)GRADIENT_SIZE.width * (soluteColorScheme.midConcentration - soluteColorScheme.minConcentration) / (soluteColorScheme.maxConcentration - soluteColorScheme.minConcentration);
                    double d2 = (double)GRADIENT_SIZE.width - d;
                    pPath.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, GRADIENT_SIZE.height));
                    pPath2.setPathTo(new Rectangle2D.Double(d, 0.0, d2, GRADIENT_SIZE.height));
                    pPath.setPaint(new GradientPaint(0.0f, 0.0f, soluteColorScheme.minColor, (float)d, 0.0f, soluteColorScheme.midColor));
                    pPath2.setPaint(new GradientPaint((float)d, 0.0f, soluteColorScheme.midColor, (float)(d + d2), 0.0f, soluteColorScheme.maxColor));
                }
            });
        }
    }

    private static class SoluteColorSchemeNode
    extends PNode {
        public SoluteColorSchemeNode(Frame frame, final Solute solute) {
            HTMLNode hTMLNode = new HTMLNode(solute.formula + ":", Color.BLACK, new PhetFont(12));
            final ColorControlNode colorControlNode = new ColorControlNode(frame, String.valueOf(solute.colorScheme.get().minConcentration) + "=", solute.colorScheme.get().minColor);
            final ColorControlNode colorControlNode2 = new ColorControlNode(frame, "=", solute.colorScheme.get().midColor);
            final ColorControlNode colorControlNode3 = new ColorControlNode(frame, String.valueOf(solute.colorScheme.get().maxConcentration) + "=", solute.colorScheme.get().maxColor);
            final DoubleSpinner doubleSpinner = new DoubleSpinner(solute.colorScheme.get().midConcentration, solute.colorScheme.get().minConcentration, solute.colorScheme.get().maxConcentration, 0.01, "0.00", new Dimension(60, 20));
            PSwing pSwing = new PSwing(doubleSpinner);
            PText pText = new PText("-->");
            GradientNode gradientNode = new GradientNode(solute.colorScheme);
            this.addChild(hTMLNode);
            this.addChild(colorControlNode);
            this.addChild(pSwing);
            this.addChild(colorControlNode2);
            this.addChild(colorControlNode3);
            this.addChild(pText);
            this.addChild(gradientNode);
            colorControlNode.setOffset(hTMLNode.getFullBoundsReference().getMaxX() + 30.0, hTMLNode.getYOffset());
            pSwing.setOffset(colorControlNode.getFullBoundsReference().getMaxX() + 30.0, colorControlNode.getFullBoundsReference().getCenterY() - pSwing.getFullBoundsReference().getHeight() / 2.0);
            colorControlNode2.setOffset(pSwing.getFullBoundsReference().getMaxX() + 2.0, hTMLNode.getYOffset());
            colorControlNode3.setOffset(colorControlNode2.getFullBoundsReference().getMaxX() + 30.0, hTMLNode.getYOffset());
            pText.setOffset(colorControlNode3.getFullBoundsReference().getMaxX() + 30.0, hTMLNode.getYOffset());
            gradientNode.setOffset(pText.getFullBoundsReference().getMaxX() + 30.0, colorControlNode3.getFullBoundsReference().getCenterY() - gradientNode.getFullBoundsReference().getHeight() / 2.0);
            final VoidFunction0 voidFunction0 = new VoidFunction0(){

                public void apply() {
                    SoluteColorScheme soluteColorScheme = solute.colorScheme.get();
                    SoluteColorScheme soluteColorScheme2 = new SoluteColorScheme(soluteColorScheme.minConcentration, colorControlNode.getColor(), doubleSpinner.getDoubleValue(), colorControlNode2.getColor(), soluteColorScheme.maxConcentration, colorControlNode3.getColor());
                    solute.colorScheme.set(soluteColorScheme2);
                }
            };
            doubleSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    voidFunction0.apply();
                }
            });
            ChangeListener changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    voidFunction0.apply();
                }
            };
            colorControlNode.addChangeListener(changeListener);
            colorControlNode2.addChangeListener(changeListener);
            colorControlNode3.addChangeListener(changeListener);
        }
    }
}

