/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.concentration.model.Beaker;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.MessageFormat;

class BeakerNode
extends PComposite {
    private static final Stroke STROKE = new BasicStroke(6.0f, 1, 1);
    private static final Color STROKE_COLOR = Color.BLACK;
    private static final String[] MAJOR_TICK_LABELS = new String[]{"\u00bd", "1"};
    private static final Color TICK_COLOR = Color.BLACK;
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final Stroke MINOR_TICK_STROKE = new BasicStroke(2.0f, 0, 2);
    private static final Font TICK_LABEL_FONT = new PhetFont(24);
    private final Beaker beaker;
    private final PPath outlineNode;
    private final GeneralPath outlinePath;
    private final PComposite ticksNode;

    public BeakerNode(Beaker beaker, TicksLocation ticksLocation) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.beaker = beaker;
        this.outlinePath = new GeneralPath();
        this.outlineNode = new PPath();
        this.outlineNode.setPaint(null);
        this.outlineNode.setStroke(STROKE);
        this.outlineNode.setStrokePaint(STROKE_COLOR);
        this.addChild(this.outlineNode);
        this.ticksNode = new PComposite();
        this.addChild(this.ticksNode);
        this.setOffset(beaker.location.toPoint2D());
        this.createOutline();
        this.updateTicks(ticksLocation);
    }

    private double getOriginXOffset() {
        return this.beaker.size.getWidth() / 2.0;
    }

    private double getOriginYOffset() {
        return this.beaker.size.getHeight();
    }

    private void createOutline() {
        this.outlinePath.reset();
        double d = this.getOriginXOffset();
        double d2 = this.getOriginYOffset();
        this.outlinePath.moveTo((float)(-d - 20.0), (float)(-d2 - 20.0));
        this.outlinePath.lineTo((float)(-d), (float)(-d2));
        this.outlinePath.lineTo((float)(-d), (float)(this.beaker.size.getHeight() - d2));
        this.outlinePath.lineTo((float)(this.beaker.size.getWidth() - d), (float)(this.beaker.size.getHeight() - d2));
        this.outlinePath.lineTo((float)(this.beaker.size.getWidth() - d), (float)(-d2));
        this.outlinePath.lineTo((float)(this.beaker.size.getWidth() - d + 20.0), (float)(-d2 - 20.0));
        this.outlineNode.setPathTo(this.outlinePath);
    }

    private void updateTicks(TicksLocation ticksLocation) {
        this.ticksNode.removeAllChildren();
        int n = (int)Math.round(10.0);
        double d = -this.getOriginXOffset();
        double d2 = this.getOriginXOffset();
        double d3 = this.beaker.size.getHeight() - this.getOriginYOffset();
        double d4 = this.beaker.size.getHeight() / (double)n;
        for (int i = 1; i <= n; ++i) {
            PPath pPath;
            Line2D.Double double_;
            double d5;
            double d6;
            double d7 = d3 - (double)i * d4;
            if (i % 5 == 0) {
                d6 = ticksLocation == TicksLocation.LEFT ? d : d2 - 30.0;
                d5 = ticksLocation == TicksLocation.LEFT ? d + 30.0 : d2;
                double_ = new Line2D.Double(d6, d7, d5, d7);
                pPath = new PPath(double_);
                pPath.setStroke(MAJOR_TICK_STROKE);
                pPath.setStrokePaint(TICK_COLOR);
                this.ticksNode.addChild(pPath);
                int n2 = i / 5 - 1;
                if (n2 >= MAJOR_TICK_LABELS.length || MAJOR_TICK_LABELS[n2] == null) continue;
                String string = MessageFormat.format(BLLResources.Strings.PATTERN_0VALUE_1UNITS, MAJOR_TICK_LABELS[n2], BLLResources.Strings.UNITS_LITERS);
                PText pText = new PText(string);
                pText.setFont(TICK_LABEL_FONT);
                pText.setTextPaint(TICK_COLOR);
                this.ticksNode.addChild(pText);
                double d8 = ticksLocation == TicksLocation.LEFT ? pPath.getFullBounds().getMaxX() + 8.0 : pPath.getFullBounds().getMinX() - pText.getFullBoundsReference().getWidth() - 8.0;
                double d9 = pPath.getFullBounds().getMinY() - pText.getFullBoundsReference().getHeight() / 2.0;
                pText.setOffset(d8, d9);
                continue;
            }
            d6 = ticksLocation == TicksLocation.LEFT ? d : d2 - 15.0;
            d5 = ticksLocation == TicksLocation.LEFT ? d + 15.0 : d2;
            double_ = new Line2D.Double(d6, d7, d5, d7);
            pPath = new PPath(double_);
            pPath.setStroke(MINOR_TICK_STROKE);
            pPath.setStrokePaint(TICK_COLOR);
            this.ticksNode.addChild(pPath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TicksLocation
    extends Enum<TicksLocation> {
        public static final /* enum */ TicksLocation LEFT = new TicksLocation();
        public static final /* enum */ TicksLocation RIGHT = new TicksLocation();
        private static final /* synthetic */ TicksLocation[] $VALUES;

        public static TicksLocation[] values() {
            return (TicksLocation[])$VALUES.clone();
        }

        static {
            $VALUES = new TicksLocation[]{LEFT, RIGHT};
        }
    }
}

