/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.common.model.Solvent;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import java.awt.Color;

public class SoluteColorScheme {
    public final Color minColor;
    public final Color midColor;
    public final Color maxColor;
    public final double minConcentration;
    public final double midConcentration;
    public final double maxConcentration;

    public SoluteColorScheme(double d, Color color, double d2, Color color2, double d3, Color color3) {
        this.minColor = color;
        this.midColor = color2;
        this.maxColor = color3;
        this.minConcentration = d;
        this.midConcentration = d2;
        this.maxConcentration = d3;
    }

    public Color interpolateLinear(double d) {
        if (d >= this.maxConcentration) {
            return this.maxColor;
        }
        if (d <= this.minConcentration) {
            return this.minColor;
        }
        if (d <= this.midConcentration) {
            return ColorUtils.interpolateRBGA(this.minColor, this.midColor, (d - this.minConcentration) / (this.midConcentration - this.minConcentration));
        }
        return ColorUtils.interpolateRBGA(this.midColor, this.maxColor, (d - this.midConcentration) / (this.maxConcentration - this.midConcentration));
    }

    public static class CobaltChlorideColorScheme
    extends SoluteColorScheme {
        public CobaltChlorideColorScheme() {
            super(0.0, Solvent.Water.COLOR, 0.05, new Color(255, 242, 242), 4.33, new Color(255, 106, 106));
        }
    }

    public static class CobaltIINitrateColorScheme
    extends SoluteColorScheme {
        public CobaltIINitrateColorScheme() {
            super(0.0, Solvent.Water.COLOR, 0.05, new Color(255, 225, 225), 5.64, new Color(255, 0, 0));
        }
    }

    public static class CopperSulfateColorScheme
    extends SoluteColorScheme {
        public CopperSulfateColorScheme() {
            super(0.0, Solvent.Water.COLOR, 0.2, new Color(200, 225, 255), 1.38, new Color(30, 144, 255));
        }
    }

    public static class DrinkMixColorScheme
    extends SoluteColorScheme {
        public DrinkMixColorScheme() {
            super(0.0, Solvent.Water.COLOR, 0.05, new Color(255, 225, 225), 5.96, new Color(255, 0, 0));
        }
    }

    public static class NickelIIChlorideColorScheme
    extends SoluteColorScheme {
        public NickelIIChlorideColorScheme() {
            super(0.0, Solvent.Water.COLOR, 0.2, new Color(170, 255, 170), 5.21, new Color(0, 128, 0));
        }
    }

    public static class PotassiumChromateColorScheme
    extends SoluteColorScheme {
        public PotassiumChromateColorScheme() {
            super(0.0, Solvent.Water.COLOR, 0.05, new Color(255, 255, 153), 3.35, new Color(255, 255, 0));
        }
    }

    public static class PotassiumDichromateColorScheme
    extends SoluteColorScheme {
        public PotassiumDichromateColorScheme() {
            super(0.0, Solvent.Water.COLOR, 0.01, new Color(255, 204, 153), 0.51, new Color(255, 127, 0));
        }
    }

    public static class PotassiumPermanganateColorScheme
    extends SoluteColorScheme {
        public PotassiumPermanganateColorScheme() {
            super(0.0, Solvent.Water.COLOR, 0.01, new Color(255, 0, 255), 0.48, new Color(80, 0, 120));
        }
    }
}

