/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.common.model.Movable;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolo.util.PBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shaker
extends Movable {
    public final double orientation;
    public final Property<Solute> solute;
    public final Property<Boolean> visible;
    public final Property<Boolean> empty;
    private final double maxDispensingRate;
    private final Property<Double> dispensingRate;
    private ImmutableVector2D previousLocation;

    public Shaker(ImmutableVector2D immutableVector2D, double d, PBounds pBounds, Property<Solute> property, double d2) {
        super(immutableVector2D, pBounds);
        assert (pBounds.contains(immutableVector2D.toPoint2D()));
        this.orientation = d;
        this.solute = property;
        this.visible = new Property<Boolean>(true);
        this.empty = new Property<Boolean>(false);
        this.maxDispensingRate = d2;
        this.dispensingRate = new Property<Double>(0.0);
        this.previousLocation = immutableVector2D;
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                if (Shaker.this.empty.get().booleanValue() || !Shaker.this.visible.get().booleanValue()) {
                    Shaker.this.dispensingRate.set(0.0);
                }
            }
        };
        richSimpleObserver.observe(this.empty, this.visible);
    }

    public double getDispensingRate() {
        return this.dispensingRate.get();
    }

    public void addDispensingRateObserver(SimpleObserver simpleObserver) {
        this.dispensingRate.addObserver(simpleObserver);
    }

    public void stepInTime() {
        if (this.visible.get().booleanValue() && !this.empty.get().booleanValue()) {
            if (this.previousLocation.equals(this.location.get())) {
                this.dispensingRate.set(0.0);
            } else {
                this.dispensingRate.set(this.maxDispensingRate);
            }
        }
        this.previousLocation = new ImmutableVector2D(this.getX(), this.getY());
    }

    @Override
    public void reset() {
        super.reset();
        this.dispensingRate.reset();
        this.previousLocation = new ImmutableVector2D(this.getX(), this.getY());
    }
}

