/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.concentration.model.Beaker;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.beerslawlab.concentration.model.PrecipitateParticle;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.util.ArrayList;

public class Precipitate {
    private final ConcentrationSolution solution;
    private final Beaker beaker;
    private final ArrayList<PrecipitateParticle> particles;
    private final ArrayList<ParticlesChangeListener> listeners;

    public Precipitate(ConcentrationSolution concentrationSolution, Beaker beaker) {
        this.solution = concentrationSolution;
        this.beaker = beaker;
        this.particles = new ArrayList();
        this.listeners = new ArrayList();
        concentrationSolution.precipitateAmount.addObserver(new SimpleObserver(){

            public void update() {
                Precipitate.this.updateParticles();
            }
        });
        concentrationSolution.solute.addObserver(new SimpleObserver(){

            public void update() {
                Precipitate.this.removeAllParticles();
                Precipitate.this.updateParticles();
            }
        });
    }

    public void addParticlesChangeListener(ParticlesChangeListener particlesChangeListener) {
        this.listeners.add(particlesChangeListener);
    }

    private void updateParticles() {
        int n = this.solution.getNumberOfPrecipitateParticles();
        if (n == 0) {
            this.removeAllParticles();
        } else if (n > this.particles.size()) {
            while (n > this.particles.size()) {
                this.addParticle(new PrecipitateParticle(this.solution.solute.get(), this.getRandomOffset(), this.getRandomOrientation()));
            }
        } else {
            while (n < this.particles.size()) {
                this.removeParticle(this.particles.get(this.particles.size() - 1));
            }
        }
    }

    private void addParticle(PrecipitateParticle precipitateParticle) {
        this.particles.add(precipitateParticle);
        this.fireParticleAdded(precipitateParticle);
    }

    private void removeParticle(PrecipitateParticle precipitateParticle) {
        this.particles.remove(precipitateParticle);
        this.fireParticleRemoved(precipitateParticle);
    }

    private void removeAllParticles() {
        for (PrecipitateParticle precipitateParticle : new ArrayList<PrecipitateParticle>(this.particles)) {
            this.removeParticle(precipitateParticle);
        }
    }

    private void fireParticleAdded(PrecipitateParticle precipitateParticle) {
        for (ParticlesChangeListener particlesChangeListener : new ArrayList<ParticlesChangeListener>(this.listeners)) {
            particlesChangeListener.particleAdded(precipitateParticle);
        }
    }

    private void fireParticleRemoved(PrecipitateParticle precipitateParticle) {
        for (ParticlesChangeListener particlesChangeListener : new ArrayList<ParticlesChangeListener>(this.listeners)) {
            particlesChangeListener.particleRemoved(precipitateParticle);
        }
    }

    private ImmutableVector2D getRandomOffset() {
        double d;
        double d2 = d = this.solution.solute.get().particleSize;
        double d3 = this.beaker.size.getWidth() - d - 2.0 * d2;
        double d4 = d2 + Math.random() * d3 - this.beaker.size.getWidth() / 2.0;
        double d5 = d;
        double d6 = -d5;
        return new ImmutableVector2D(d4, d6);
    }

    private double getRandomOrientation() {
        return Math.random() * 2.0 * Math.PI;
    }

    public static interface ParticlesChangeListener {
        public void particleAdded(PrecipitateParticle var1);

        public void particleRemoved(PrecipitateParticle var1);
    }
}

