/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.common.model.Movable;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.umd.cs.piccolo.util.PBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dropper
extends Movable {
    public final Property<Solute> solute;
    public final Property<Boolean> visible;
    public final Property<Boolean> on;
    public final Property<Boolean> enabled;
    public final Property<Boolean> empty;
    public final CompositeProperty<Double> flowRate;

    public Dropper(ImmutableVector2D immutableVector2D, PBounds pBounds, Property<Solute> property, final double d) {
        super(immutableVector2D, pBounds);
        assert (pBounds.contains(immutableVector2D.toPoint2D()));
        this.solute = property;
        this.visible = new Property<Boolean>(true);
        this.on = new Property<Boolean>(false);
        this.enabled = new Property<Boolean>(true);
        this.empty = new Property<Boolean>(false);
        this.enabled.addObserver(new SimpleObserver(){

            public void update() {
                if (!Dropper.this.enabled.get().booleanValue()) {
                    Dropper.this.on.set(false);
                }
            }
        });
        this.flowRate = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                return Dropper.this.on.get() != false ? d : 0.0;
            }
        }, this.on);
        this.empty.addObserver(new SimpleObserver(){

            public void update() {
                if (Dropper.this.empty.get().booleanValue()) {
                    Dropper.this.enabled.set(false);
                }
            }
        });
    }
}

