/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.concentration.model.Beaker;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationMeter;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.beerslawlab.concentration.model.Dropper;
import edu.colorado.phet.beerslawlab.concentration.model.Evaporator;
import edu.colorado.phet.beerslawlab.concentration.model.Faucet;
import edu.colorado.phet.beerslawlab.concentration.model.Precipitate;
import edu.colorado.phet.beerslawlab.concentration.model.Shaker;
import edu.colorado.phet.beerslawlab.concentration.model.ShakerParticles;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcentrationModel
implements Resettable {
    private static final DoubleRange SOLUTION_VOLUME_RANGE = new DoubleRange(0.0, 1.0, 0.5);
    private static final DoubleRange SOLUTE_AMOUNT = new DoubleRange(0.0, 6.0, 0.0);
    private final ArrayList<Solute> solutes;
    public final Property<Solute> solute;
    public final ConcentrationSolution solution;
    public final Property<Solute.SoluteForm> soluteForm = new Property<Solute.SoluteForm>(Solute.SoluteForm.SOLID);
    public final Shaker shaker;
    public final ShakerParticles shakerParticles;
    public final Dropper dropper;
    public final Evaporator evaporator;
    public final Beaker beaker;
    public final Precipitate precipitate;
    public final Faucet solventFaucet;
    public final Faucet drainFaucet;
    public final ConcentrationMeter concentrationMeter;

    public ConcentrationModel(IClock iClock) {
        iClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                ConcentrationModel.this.stepInTime((double)clockEvent.getWallTimeChange() / 1000.0);
            }
        });
        this.solutes = new ArrayList<Solute>(){
            {
                this.add(new Solute.DrinkMix());
                this.add(new Solute.CobaltIINitrate());
                this.add(new Solute.CobaltChloride());
                this.add(new Solute.PotassiumDichromate());
                this.add(new Solute.PotassiumChromate());
                this.add(new Solute.NickelIIChloride());
                this.add(new Solute.CopperSulfate());
                this.add(new Solute.PotassiumPermanganate());
            }
        };
        this.solute = new Property<Solute>(this.solutes.get(0));
        this.solution = new ConcentrationSolution(this.solute, 0.0, SOLUTION_VOLUME_RANGE.getDefault());
        this.beaker = new Beaker(new ImmutableVector2D(400.0, 550.0), new PDimension(600.0, 300.0), SOLUTION_VOLUME_RANGE.getMax());
        this.precipitate = new Precipitate(this.solution, this.beaker);
        this.shaker = new Shaker(new ImmutableVector2D(340.0, 170.0), 2.356194490192345, new PBounds(225.0, 50.0, 400.0, 160.0), this.solute, 0.2);
        this.shakerParticles = new ShakerParticles(this.shaker, this.solution, this.beaker);
        this.dropper = new Dropper(new ImmutableVector2D(375.0, 210.0), new PBounds(230.0, 205.0, 400.0, 30.0), this.solute, 0.05);
        this.evaporator = new Evaporator(0.25, this.solution);
        this.solventFaucet = new Faucet(new ImmutableVector2D(150.0, 190.0), 1000.0, 0.25);
        this.drainFaucet = new Faucet(new ImmutableVector2D(825.0, 618.0), 20.0, 0.25);
        this.concentrationMeter = new ConcentrationMeter(new ImmutableVector2D(785.0, 210.0), new PBounds(10.0, 150.0, 825.0, 530.0), new ImmutableVector2D(775.0, 390.0), new PBounds(30.0, 150.0, 935.0, 530.0));
        this.solute.addObserver(new SimpleObserver(){

            public void update() {
                ConcentrationModel.this.solution.soluteAmount.set(0.0);
            }
        });
        this.soluteForm.addObserver(new VoidFunction1<Solute.SoluteForm>(){

            @Override
            public void apply(Solute.SoluteForm soluteForm) {
                ConcentrationModel.this.shaker.visible.set(soluteForm == Solute.SoluteForm.SOLID);
                ConcentrationModel.this.dropper.visible.set(soluteForm == Solute.SoluteForm.STOCK_SOLUTION);
            }
        });
        this.solution.volume.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                ConcentrationModel.this.solventFaucet.enabled.set(d < SOLUTION_VOLUME_RANGE.getMax());
                ConcentrationModel.this.drainFaucet.enabled.set(d > SOLUTION_VOLUME_RANGE.getMin());
                ConcentrationModel.this.dropper.enabled.set(ConcentrationModel.this.dropper.empty.get() == false && d < SOLUTION_VOLUME_RANGE.getMax());
            }
        });
        this.solution.soluteAmount.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                boolean bl = d >= SOLUTE_AMOUNT.getMax();
                ConcentrationModel.this.shaker.empty.set(bl);
                ConcentrationModel.this.dropper.empty.set(bl);
                ConcentrationModel.this.dropper.enabled.set(ConcentrationModel.this.dropper.empty.get() == false && !bl && ConcentrationModel.this.solution.volume.get() < SOLUTION_VOLUME_RANGE.getMax());
            }
        });
    }

    public ArrayList<Solute> getSolutes() {
        return new ArrayList<Solute>(this.solutes);
    }

    @Override
    public void reset() {
        this.solute.reset();
        this.solution.reset();
        this.soluteForm.reset();
        this.shaker.reset();
        this.dropper.reset();
        this.evaporator.reset();
        this.solventFaucet.reset();
        this.drainFaucet.reset();
        this.concentrationMeter.reset();
    }

    private void stepInTime(double d) {
        this.addSolventFromInputFaucet(d);
        this.drainSolutionFromOutputFaucet(d);
        this.addStockSolutionFromDropper(d);
        this.evaporateSolvent(d);
        this.propagateShakerParticles(d);
        this.createShakerParticles();
    }

    private void addSolventFromInputFaucet(double d) {
        this.addSolvent(this.solventFaucet.flowRate.get() * d);
    }

    private void drainSolutionFromOutputFaucet(double d) {
        double d2 = this.drainFaucet.flowRate.get() * d;
        if (d2 > 0.0) {
            double d3 = this.solution.concentration.get();
            double d4 = this.removeSolvent(d2);
            this.removeSolute(d3 * d4);
        }
    }

    private void propagateShakerParticles(double d) {
        this.shakerParticles.stepInTime(d);
    }

    private void createShakerParticles() {
        this.shaker.stepInTime();
    }

    private void addStockSolutionFromDropper(double d) {
        double d2 = this.dropper.flowRate.get() * d;
        if (d2 > 0.0) {
            double d3 = this.addSolvent(d2);
            this.addSolute(this.solution.solute.get().stockSolutionConcentration * d3);
        }
    }

    private void evaporateSolvent(double d) {
        this.removeSolvent(this.evaporator.evaporationRate.get() * d);
    }

    private double addSolvent(double d) {
        if (d > 0.0) {
            double d2 = this.solution.volume.get();
            this.solution.volume.set(Math.min(SOLUTION_VOLUME_RANGE.getMax(), this.solution.volume.get() + d));
            return this.solution.volume.get() - d2;
        }
        return 0.0;
    }

    private double removeSolvent(double d) {
        if (d > 0.0) {
            double d2 = this.solution.volume.get();
            this.solution.volume.set(Math.max(SOLUTION_VOLUME_RANGE.getMin(), this.solution.volume.get() - d));
            return d2 - this.solution.volume.get();
        }
        return 0.0;
    }

    private double addSolute(double d) {
        if (d > 0.0) {
            double d2 = this.solution.soluteAmount.get();
            this.solution.soluteAmount.set(Math.min(SOLUTE_AMOUNT.getMax(), this.solution.soluteAmount.get() + d));
            return this.solution.soluteAmount.get() - d2;
        }
        return 0.0;
    }

    private double removeSolute(double d) {
        if (d > 0.0) {
            double d2 = this.solution.soluteAmount.get();
            this.solution.soluteAmount.set(Math.max(SOLUTE_AMOUNT.getMin(), this.solution.soluteAmount.get() - d));
            return d2 - this.solution.soluteAmount.get();
        }
        return 0.0;
    }

    static {
        assert (SOLUTION_VOLUME_RANGE.getMin() >= 0.0);
        assert (SOLUTION_VOLUME_RANGE.getMax() <= 1.0);
    }
}

