/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.view;

import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawSolution;
import edu.colorado.phet.beerslawlab.beerslaw.model.Light;
import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.common.phetcommon.view.util.GridPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.WavelengthControl;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WavelengthControlNode
extends PNode
implements Resettable {
    private static final PhetFont FONT = new PhetFont(18);
    private static final Dimension WAVELENGTH_CONTROL_TRACK_SIZE = new Dimension(150, 30);
    private final Property<Boolean> variableWavelength = new Property<Boolean>(false);

    public WavelengthControlNode(final Property<BeersLawSolution> property, final Light light) {
        JLabel jLabel = new JLabel(MessageFormat.format(BLLResources.Strings.PATTERN_0LABEL, BLLResources.Strings.WAVELENGTH));
        jLabel.setFont(FONT);
        PropertyRadioButton<Boolean> propertyRadioButton = new PropertyRadioButton<Boolean>(BLLSimSharing.UserComponents.lambdaMaxRadioButton, BLLResources.Strings.FIXED, this.variableWavelength, false);
        propertyRadioButton.setFont(FONT);
        PropertyRadioButton<Boolean> propertyRadioButton2 = new PropertyRadioButton<Boolean>(BLLSimSharing.UserComponents.variableRadioButton, BLLResources.Strings.VARIABLE, this.variableWavelength, true);
        propertyRadioButton2.setFont(FONT);
        GridPanel gridPanel = new GridPanel();
        gridPanel.setInsets(new Insets(4, 4, 4, 4));
        gridPanel.setOpaque(false);
        gridPanel.setAnchor(GridPanel.Anchor.WEST);
        gridPanel.setFill(GridPanel.Fill.HORIZONTAL);
        gridPanel.add(jLabel, 0, 0, 2, 1);
        gridPanel.add((Component)propertyRadioButton, 1, 0);
        gridPanel.add((Component)propertyRadioButton2, 1, 1);
        PSwing pSwing = new PSwing(gridPanel);
        BLLWavelengthControl bLLWavelengthControl = new BLLWavelengthControl(WAVELENGTH_CONTROL_TRACK_SIZE, light.wavelength);
        final ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode((PNode)bLLWavelengthControl);
        zeroOffsetNode.setOffset(pSwing.getXOffset(), pSwing.getFullBoundsReference().getMaxY() + 6.0);
        final PNode pNode = new PNode();
        pNode.addChild(pSwing);
        pNode.addChild(zeroOffsetNode);
        this.addChild(new ControlPanelNode(pNode));
        this.variableWavelength.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    pNode.addChild(zeroOffsetNode);
                } else {
                    pNode.removeChild(zeroOffsetNode);
                    light.wavelength.set(((BeersLawSolution)property.get()).molarAbsorptivityData.getLambdaMax());
                }
            }
        });
    }

    @Override
    public void reset() {
        this.variableWavelength.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BLLWavelengthControl
    extends WavelengthControl {
        public BLLWavelengthControl(Dimension dimension, final Property<Double> property) {
            super(BLLSimSharing.UserComponents.wavelengthControl, true, dimension.width, dimension.height);
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    property.set(BLLWavelengthControl.this.getWavelength());
                }
            });
            property.addObserver(new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    BLLWavelengthControl.this.setWavelength(d);
                }
            });
        }
    }
}

