/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.view;

import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawSolution;
import edu.colorado.phet.beerslawlab.beerslaw.model.Cuvette;
import edu.colorado.phet.beerslawlab.common.BLLConstants;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.common.piccolophet.nodes.DoubleArrowNode;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CuvetteNode
extends PNode {
    private static final Color ARROW_FILL = Color.ORANGE;

    public CuvetteNode(final Cuvette cuvette, Property<BeersLawSolution> property, final ModelViewTransform modelViewTransform, double d) {
        final PPath pPath = new PPath(){
            {
                this.setPickable(false);
                this.setStroke(new BasicStroke(3.0f));
            }
        };
        final PPath pPath2 = new PPath(){
            {
                this.setPickable(false);
                this.setStroke(BLLConstants.FLUID_STROKE);
            }
        };
        final DoubleArrowNode doubleArrowNode = new DoubleArrowNode(new Point2D.Double(-40.0, 0.0), new Point2D.Double(40.0, 0.0), 25.0, 30.0, 15.0){
            {
                this.setPaint(ARROW_FILL);
            }
        };
        this.addChild(pPath2);
        this.addChild(pPath);
        this.addChild(doubleArrowNode);
        cuvette.width.addObserver(new SimpleObserver(){

            public void update() {
                final double d = modelViewTransform.modelToViewDeltaX(cuvette.width.get());
                final double d2 = modelViewTransform.modelToViewDeltaY(cuvette.height);
                pPath.setPathTo(new DoubleGeneralPath(){
                    {
                        this.moveTo(0.0, 0.0);
                        this.lineTo(0.0, d2);
                        this.lineTo(d, d2);
                        this.lineTo(d, 0.0);
                    }
                }.getGeneralPath());
                pPath2.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, 0.92 * d2));
                pPath2.setOffset(pPath.getXOffset(), pPath.getFullBoundsReference().getMaxY() - pPath2.getFullBoundsReference().getHeight());
                doubleArrowNode.setOffset(pPath.getFullBoundsReference().getMaxX(), 0.85 * pPath.getFullBoundsReference().getHeight());
            }
        });
        final VoidFunction1<Color> voidFunction1 = new VoidFunction1<Color>(){

            @Override
            public void apply(Color color) {
                CuvetteNode.this.updateColor(pPath2, color);
            }
        };
        property.get().fluidColor.addObserver(voidFunction1);
        property.addObserver(new ChangeObserver<BeersLawSolution>(){

            @Override
            public void update(BeersLawSolution beersLawSolution, BeersLawSolution beersLawSolution2) {
                beersLawSolution2.fluidColor.removeObserver(voidFunction1);
                beersLawSolution.fluidColor.addObserver(voidFunction1);
            }
        });
        this.setOffset(modelViewTransform.modelToView(cuvette.location.toPoint2D()));
        doubleArrowNode.addInputEventListener(new CursorHandler());
        doubleArrowNode.addInputEventListener(new HighlightHandler.PaintHighlightHandler(doubleArrowNode, ARROW_FILL, ARROW_FILL.brighter()));
        doubleArrowNode.addInputEventListener(new WidthDragHandler(this, cuvette, modelViewTransform, d));
    }

    private void updateColor(PPath pPath, Color color) {
        pPath.setPaint(ColorUtils.createColor(color, 150));
        pPath.setStrokePaint(BLLConstants.createFluidStrokeColor(color));
    }

    private static class WidthDragHandler
    extends SimSharingDragHandler {
        private final Cuvette cuvette;
        private final CuvetteNode cuvetteNode;
        private final ModelViewTransform mvt;
        private final double snapInterval;
        private double startXOffset;
        private double startWidth;

        public WidthDragHandler(CuvetteNode cuvetteNode, Cuvette cuvette, ModelViewTransform modelViewTransform, double d) {
            super(BLLSimSharing.UserComponents.cuvetteWidthHandle, UserComponentTypes.sprite);
            this.cuvette = cuvette;
            this.cuvetteNode = cuvetteNode;
            this.mvt = modelViewTransform;
            this.snapInterval = d;
        }

        protected void startDrag(PInputEvent pInputEvent) {
            super.startDrag(pInputEvent);
            this.startXOffset = pInputEvent.getPositionRelativeTo(this.cuvetteNode).getX();
            this.startWidth = this.cuvette.width.get();
        }

        protected void drag(PInputEvent pInputEvent) {
            super.drag(pInputEvent);
            double d = pInputEvent.getPositionRelativeTo(this.cuvetteNode).getX();
            double d2 = this.mvt.viewToModelDeltaX(d - this.startXOffset);
            double d3 = MathUtil.clamp(this.startWidth + d2, this.cuvette.widthRange);
            this.cuvette.width.set(d3);
        }

        protected void endDrag(PInputEvent pInputEvent) {
            super.endDrag(pInputEvent);
            int n = (int)((this.cuvette.width.get() + this.snapInterval / 2.0) / this.snapInterval);
            this.cuvette.width.set((double)n * this.snapInterval);
        }
    }
}

