/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.view;

import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawSolution;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJTextField;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcentrationTextField
extends SimSharingJTextField {
    private static final NumberFormat FORMAT = new DefaultDecimalFormat("0");
    private Property<BeersLawSolution> solutionProperty;
    private final SimpleObserver concentrationObserver;

    public ConcentrationTextField(final Property<BeersLawSolution> property, PhetFont phetFont) {
        super(BLLSimSharing.UserComponents.concentrationTextField, 3);
        this.setFont(phetFont);
        this.setHorizontalAlignment(4);
        this.solutionProperty = property;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConcentrationTextField.this.commitValue();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ConcentrationTextField.this.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                ConcentrationTextField.this.commitValue();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 38) {
                    if (((BeersLawSolution)property.get()).concentration.get() < ((BeersLawSolution)property.get()).concentrationRange.getMax()) {
                        double d = ((BeersLawSolution)property.get()).concentrationTransform.modelToView(((BeersLawSolution)property.get()).concentration.get()) + 1.0;
                        SimSharingManager.sendUserMessage(BLLSimSharing.UserComponents.concentrationTextField, UserComponentTypes.textField, UserActions.upArrowPressed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, ((BeersLawSolution)property.get()).concentrationTransform.viewToModel(d)));
                        ConcentrationTextField.this.updateModel(d);
                    }
                } else if (keyEvent.getKeyCode() == 40 && ((BeersLawSolution)property.get()).concentration.get() > ((BeersLawSolution)property.get()).concentrationRange.getMin()) {
                    double d = ((BeersLawSolution)property.get()).concentrationTransform.modelToView(((BeersLawSolution)property.get()).concentration.get()) + 1.0;
                    SimSharingManager.sendUserMessage(BLLSimSharing.UserComponents.concentrationTextField, UserComponentTypes.textField, UserActions.downArrowPressed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, ((BeersLawSolution)property.get()).concentrationTransform.viewToModel(d)));
                    ConcentrationTextField.this.updateModel(d);
                }
            }
        });
        this.concentrationObserver = new SimpleObserver(){

            public void update() {
                ConcentrationTextField.this.updateView(((BeersLawSolution)property.get()).concentration.get());
            }
        };
        property.get().concentration.addObserver(this.concentrationObserver);
        property.addObserver(new SimpleObserver(){

            public void update() {
                ((BeersLawSolution)property.get()).concentration.removeObserver(ConcentrationTextField.this.concentrationObserver);
                ((BeersLawSolution)property.get()).concentration.addObserver(ConcentrationTextField.this.concentrationObserver);
            }
        });
    }

    private void updateView(double d) {
        double d2 = this.solutionProperty.get().concentrationTransform.modelToView(d);
        super.setText(FORMAT.format(d2));
    }

    private void updateModel(double d) {
        Double d2 = this.solutionProperty.get().concentrationTransform.viewToModel(d);
        Double d3 = this.constrainValue(d2, this.solutionProperty.get().concentrationRange);
        this.solutionProperty.get().concentration.set(d3);
        this.updateView(this.solutionProperty.get().concentration.get());
    }

    private void commitValue() {
        try {
            this.updateModel(Double.valueOf(this.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            this.revertValue();
        }
    }

    private double constrainValue(double d, DoubleRange doubleRange) {
        if (d > doubleRange.getMax()) {
            this.badInput();
            return doubleRange.getMax();
        }
        if (d < doubleRange.getMin()) {
            this.badInput();
            return doubleRange.getMin();
        }
        return d;
    }

    private void revertValue() {
        this.badInput();
        this.updateView(this.solutionProperty.get().concentration.get());
    }

    private void badInput() {
        Toolkit.getDefaultToolkit().beep();
    }
}

