/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.view;

import edu.colorado.phet.beerslawlab.beerslaw.model.Beam;
import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;

class BeamNode
extends PPath {
    public BeamNode(final Beam beam, final ModelViewTransform modelViewTransform) {
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.setStroke(new BasicStroke(0.25f));
        this.setStrokePaint(ColorUtils.createColor(Color.LIGHT_GRAY, 210));
        beam.shape.addObserver(new VoidFunction1<ImmutableRectangle2D>(){

            @Override
            public void apply(ImmutableRectangle2D immutableRectangle2D) {
                BeamNode.this.setPathTo(modelViewTransform.modelToView(immutableRectangle2D).toRectangle2D());
            }
        });
        beam.paint.addObserver(new VoidFunction1<Paint>(){

            @Override
            public void apply(Paint paint) {
                BeamNode.this.setPaint(paint);
            }
        });
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                BeamNode.this.setVisible(beam.visible.get());
            }
        };
        richSimpleObserver.observe(beam.visible);
    }
}

