/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.view;

import edu.colorado.phet.beerslawlab.beerslaw.model.ATDetector;
import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.common.view.DebugOriginNode;
import edu.colorado.phet.beerslawlab.common.view.MovableDragHandler;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyRadioButton;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HorizontalTiledNode;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;

class ATDetectorNode
extends PhetPNode {
    public final PNode bodyNode;

    public ATDetectorNode(ATDetector aTDetector, ModelViewTransform modelViewTransform) {
        this.bodyNode = new BodyNode(aTDetector, modelViewTransform);
        ProbeNode probeNode = new ProbeNode(aTDetector, modelViewTransform);
        WireNode wireNode = new WireNode(this.bodyNode, probeNode);
        this.addChild(wireNode);
        this.addChild(this.bodyNode);
        this.addChild(probeNode);
    }

    private static class BodyNode
    extends PNode {
        private static final DecimalFormat ABSORBANCE_FORMAT = new DecimalFormat("0.00");
        private static final DecimalFormat TRANSMITTANCE_FORMAT = new DecimalFormat("0.00");

        public BodyNode(final ATDetector aTDetector, final ModelViewTransform modelViewTransform) {
            ModeButton modeButton = new ModeButton(BLLSimSharing.UserComponents.transmittanceRadioButton, BLLResources.Strings.TRANSMITTANCE, aTDetector.mode, ATDetector.ATDetectorMode.TRANSMITTANCE);
            ModeButton modeButton2 = new ModeButton(BLLSimSharing.UserComponents.absorbanceRadioButton, BLLResources.Strings.ABSORBANCE, aTDetector.mode, ATDetector.ATDetectorMode.ABSORBANCE);
            PNode pNode = new PNode();
            pNode.addChild(modeButton);
            pNode.addChild(modeButton2);
            modeButton2.setOffset(modeButton.getXOffset(), modeButton.getFullBoundsReference().getMaxY() + 1.0);
            final PText pText = new PText(this.getFormattedTransmittance(100.0));
            pText.setFont(new PhetFont(24));
            double d = Math.max(pNode.getFullBoundsReference().getWidth(), pText.getFullBoundsReference().getWidth()) + 50.0;
            final HorizontalTiledNode horizontalTiledNode = new HorizontalTiledNode(d, BLLResources.Images.AT_DETECTOR_BODY_LEFT, BLLResources.Images.AT_DETECTOR_BODY_CENTER, BLLResources.Images.AT_DETECTOR_BODY_RIGHT);
            this.addChild(horizontalTiledNode);
            this.addChild(pNode);
            this.addChild(pText);
            pNode.setOffset(25.0, 17.0);
            pText.setOffset(25.0, 87.0);
            aTDetector.body.location.addObserver(new VoidFunction1<ImmutableVector2D>(){

                @Override
                public void apply(ImmutableVector2D immutableVector2D) {
                    BodyNode.this.setOffset(modelViewTransform.modelToView(immutableVector2D.toPoint2D()));
                }
            });
            RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

                public void update() {
                    Double d = aTDetector.value.get();
                    if (d == null) {
                        pText.setText("-");
                        pText.setOffset(horizontalTiledNode.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0, pText.getYOffset());
                    } else {
                        String string = aTDetector.mode.get() == ATDetector.ATDetectorMode.TRANSMITTANCE ? BodyNode.this.getFormattedTransmittance(d) : BodyNode.this.getFormattedAbsorbance(d);
                        pText.setText(string);
                        pText.setOffset(horizontalTiledNode.getFullBoundsReference().getMaxX() - pText.getFullBoundsReference().getWidth() - 25.0, pText.getYOffset());
                    }
                }
            };
            richSimpleObserver.observe(aTDetector.value, aTDetector.mode);
            this.addInputEventListener(new NonInteractiveEventHandler(BLLSimSharing.UserComponents.detectorBody));
        }

        private String getFormattedAbsorbance(double d) {
            return ABSORBANCE_FORMAT.format(d);
        }

        private String getFormattedTransmittance(double d) {
            return MessageFormat.format(BLLResources.Strings.PATTERN_0PERCENT, TRANSMITTANCE_FORMAT.format(d));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModeButton
    extends PSwing {
        public ModeButton(IUserComponent iUserComponent, String string, Property<ATDetector.ATDetectorMode> property, ATDetector.ATDetectorMode aTDetectorMode) {
            super(new PropertyRadioButton<ATDetector.ATDetectorMode>(iUserComponent, string, property, aTDetectorMode){
                {
                    this.setOpaque(false);
                    this.setForeground(Color.WHITE);
                    this.setFont(new PhetFont(1, 18));
                }
            });
        }
    }

    private static class ProbeNode
    extends PNode {
        public ProbeNode(final ATDetector aTDetector, final ModelViewTransform modelViewTransform) {
            PImage pImage = new PImage(BLLResources.Images.AT_DETECTOR_PROBE);
            this.addChild(pImage);
            pImage.setOffset(-pImage.getFullBoundsReference().getWidth() / 2.0, -55.0);
            DebugOriginNode debugOriginNode = new DebugOriginNode();
            if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
                this.addChild(debugOriginNode);
                this.addChild(new PPath(){
                    {
                        this.setStrokePaint(Color.RED);
                        double d = modelViewTransform.modelToViewY(aTDetector.probe.sensorDiameter);
                        this.setPathTo(new Line2D.Double(0.0, -d / 2.0, 0.0, d / 2.0));
                    }
                });
            }
            aTDetector.probe.location.addObserver(new VoidFunction1<ImmutableVector2D>(){

                @Override
                public void apply(ImmutableVector2D immutableVector2D) {
                    ProbeNode.this.setOffset(modelViewTransform.modelToView(immutableVector2D.toPoint2D()));
                }
            });
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new MovableDragHandler(BLLSimSharing.UserComponents.detectorProbe, aTDetector.probe, this, modelViewTransform){

                public ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                    return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)BLLSimSharing.ParameterKeys.inBeam, aTDetector.probeInBeam());
                }
            });
        }
    }

    public class WireNode
    extends PPath {
        public WireNode(final PNode pNode, final PNode pNode2) {
            this.setStroke(new BasicStroke(8.0f, 2, 1, 1.0f));
            this.setStrokePaint(Color.GRAY);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    double d = pNode.getFullBoundsReference().getMinX();
                    double d2 = pNode.getFullBounds().getCenterY();
                    double d3 = pNode2.getFullBoundsReference().getCenterX();
                    double d4 = pNode2.getFullBoundsReference().getMaxY();
                    WireNode.this.setPathTo(new CubicCurve2D.Double(d, d2, d - 60.0, d2, d3, d4 + 60.0, d3, d4));
                }
            };
            pNode2.addPropertyChangeListener("fullBounds", propertyChangeListener);
            pNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
        }
    }
}

