/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.model;

import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawSolution;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Light
implements Resettable {
    public final ImmutableVector2D location;
    public final Property<Boolean> on;
    public final Property<Double> wavelength;
    public final double lensDiameter;

    public Light(ImmutableVector2D immutableVector2D, boolean bl, double d, Property<BeersLawSolution> property) {
        this.location = immutableVector2D;
        this.on = new Property<Boolean>(bl);
        this.wavelength = new Property<Double>(property.get().molarAbsorptivityData.getLambdaMax());
        this.lensDiameter = d;
        property.addObserver(new VoidFunction1<BeersLawSolution>(){

            @Override
            public void apply(BeersLawSolution beersLawSolution) {
                Light.this.wavelength.set(beersLawSolution.molarAbsorptivityData.getLambdaMax());
            }
        });
    }

    public double getMinY() {
        return this.location.getY() - this.lensDiameter / 2.0;
    }

    public double getMaxY() {
        return this.location.getY() + this.lensDiameter / 2.0;
    }

    @Override
    public void reset() {
        this.on.reset();
    }
}

