/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.model;

import edu.colorado.phet.beerslawlab.beerslaw.model.ATDetector;
import edu.colorado.phet.beerslawlab.beerslaw.model.Absorbance;
import edu.colorado.phet.beerslawlab.beerslaw.model.Beam;
import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawSolution;
import edu.colorado.phet.beerslawlab.beerslaw.model.Cuvette;
import edu.colorado.phet.beerslawlab.beerslaw.model.Light;
import edu.colorado.phet.beerslawlab.beerslaw.model.Ruler;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Point2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeersLawModel
implements Resettable {
    private final ArrayList<BeersLawSolution> solutions;
    public final Property<BeersLawSolution> solution;
    public final Light light;
    public final Beam beam;
    public final ModelViewTransform mvt = ModelViewTransform.createOffsetScaleMapping(new Point2D.Double(0.0, 0.0), 125.0);
    public final Cuvette cuvette;
    public final ATDetector detector;
    public final Ruler ruler;
    public final Absorbance absorbance;

    public BeersLawModel() {
        this.solutions = new ArrayList<BeersLawSolution>(){
            {
                this.add(new BeersLawSolution.DrinkMixSolution());
                this.add(new BeersLawSolution.CobaltIINitrateSolution());
                this.add(new BeersLawSolution.CobaltChlorideSolution());
                this.add(new BeersLawSolution.PotassiumDichromateSolution());
                this.add(new BeersLawSolution.PotassiumChromateSolution());
                this.add(new BeersLawSolution.NickelIIChlorideSolution());
                this.add(new BeersLawSolution.CopperSulfateSolution());
                this.add(new BeersLawSolution.PotassiumPermanganateSolution());
            }
        };
        this.solution = new Property<BeersLawSolution>(this.solutions.get(0));
        this.light = new Light(new ImmutableVector2D(1.5, 2.2), false, 0.45, this.solution);
        this.cuvette = new Cuvette(new ImmutableVector2D(this.light.location.getX() + 1.5, 1.4), new DoubleRange(0.5, 2.0, 1.0), 3.0);
        this.ruler = new Ruler(2, 0.1, 0.35, new ImmutableVector2D(this.cuvette.location.getX() + this.cuvette.width.get() / 2.0 - 1.0, 4.9), new PBounds(0.0, 1.0, 8.0, 4.5));
        this.absorbance = new Absorbance(this.light, this.solution, this.cuvette);
        this.detector = new ATDetector(new ImmutableVector2D(6.0, 3.7), new PBounds(0.0, 0.0, 7.9, 5.25), new ImmutableVector2D(6.0, this.light.location.getY()), new PBounds(0.0, 0.0, 7.9, 5.25), this.light, this.cuvette, this.absorbance);
        this.beam = new Beam(this.light, this.cuvette, this.detector, this.absorbance, this.mvt);
    }

    @Override
    public void reset() {
        for (BeersLawSolution beersLawSolution : this.solutions) {
            beersLawSolution.reset();
        }
        this.solution.reset();
        this.light.reset();
        this.cuvette.reset();
        this.detector.reset();
        this.ruler.reset();
    }

    public ArrayList<BeersLawSolution> getSolutions() {
        return new ArrayList<BeersLawSolution>(this.solutions);
    }
}

