/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.man;

import edu.colorado.phet.batteryvoltage.Battery;
import edu.colorado.phet.batteryvoltage.common.electron.man.Man;
import edu.colorado.phet.batteryvoltage.common.electron.man.motions.CompositeMotion;
import edu.colorado.phet.batteryvoltage.common.electron.man.motions.LegSwings;
import edu.colorado.phet.batteryvoltage.common.electron.man.motions.LegSwings2;
import edu.colorado.phet.batteryvoltage.common.electron.man.motions.StandStill;
import edu.colorado.phet.batteryvoltage.common.electron.man.motions.Translate;
import edu.colorado.phet.batteryvoltage.common.electron.man.motions.TranslateTo;
import edu.colorado.phet.batteryvoltage.common.electron.man.motions.TranslateToLocation;
import edu.colorado.phet.batteryvoltage.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryvoltage.common.phys2d.Propagator;
import edu.colorado.phet.batteryvoltage.man.CarryPropagator;
import edu.colorado.phet.batteryvoltage.man.DefaultAction;
import edu.colorado.phet.batteryvoltage.man.FixedLocation;
import edu.colorado.phet.batteryvoltage.man.Get;
import edu.colorado.phet.batteryvoltage.man.Grab;
import edu.colorado.phet.batteryvoltage.man.ManIsClose;
import edu.colorado.phet.batteryvoltage.man.ReadyToDrop;
import edu.colorado.phet.batteryvoltage.man.Release;
import edu.colorado.phet.batteryvoltage.man.VoltMan;
import edu.colorado.phet.batteryvoltage.man.dir.CarryToDir;
import edu.colorado.phet.batteryvoltage.man.dir.PropagatorDir;
import edu.colorado.phet.batteryvoltage.man.dir.SpeedDir;
import java.util.Hashtable;
import java.util.Vector;

public class VoltManFactory {
    int barrierX;
    int barrierWidth;
    double goToElectronSpeed;
    Propagator leftPropagator;
    Propagator rightPropagator;
    double barrierInset;
    Hashtable carrierMap;
    double returnHomeSpeed;
    Vector carried;
    double homeThreshold;
    double minCarrySpeed;
    double maxCarrySpeed;
    Vector targeted;
    Battery b;

    public VoltManFactory(int n, int n2, double d, Propagator propagator, Propagator propagator2, double d2, Hashtable hashtable, double d3, Vector vector, double d4, double d5, double d6, Vector vector2, Battery battery) {
        this.b = battery;
        this.targeted = vector2;
        this.minCarrySpeed = d5;
        this.maxCarrySpeed = d6;
        this.homeThreshold = d4;
        this.carried = vector;
        this.barrierX = n;
        this.barrierWidth = n2;
        this.goToElectronSpeed = d;
        this.leftPropagator = propagator;
        this.rightPropagator = propagator2;
        this.barrierInset = d2;
        this.carrierMap = hashtable;
        this.returnHomeSpeed = d3;
    }

    public VoltMan newMan(Man man, DoublePoint doublePoint) {
        StandStill standStill = new StandStill();
        CarryPropagator carryPropagator = new CarryPropagator(man);
        ReadyToDrop readyToDrop = new ReadyToDrop(man, (double)this.barrierX - this.barrierInset, false);
        CompositeMotion compositeMotion = new CompositeMotion();
        compositeMotion.add(new LegSwings(0.15707963267948966));
        compositeMotion.add(new LegSwings2(0.15707963267948966));
        CompositeMotion compositeMotion2 = new CompositeMotion();
        TranslateToLocation translateToLocation = new TranslateToLocation(null, this.goToElectronSpeed);
        compositeMotion2.add(translateToLocation);
        compositeMotion2.add(compositeMotion);
        DefaultAction defaultAction = new DefaultAction(compositeMotion2);
        CompositeMotion compositeMotion3 = new CompositeMotion();
        compositeMotion3.add(compositeMotion);
        compositeMotion3.add(new TranslateTo(doublePoint.getX(), doublePoint.getY(), this.returnHomeSpeed));
        DefaultAction defaultAction2 = new DefaultAction(compositeMotion3);
        DefaultAction defaultAction3 = new DefaultAction(compositeMotion2);
        DefaultAction defaultAction4 = new DefaultAction(standStill);
        ManIsClose manIsClose = new ManIsClose(man, new FixedLocation(new DoublePoint(doublePoint.getX(), doublePoint.getY())), this.homeThreshold);
        defaultAction2.addClause(manIsClose, defaultAction4);
        Get get = new Get(compositeMotion2, translateToLocation);
        ManIsClose manIsClose2 = new ManIsClose(man, get, this.homeThreshold);
        Grab grab = new Grab(man, this.carried, carryPropagator, this.carrierMap, get, this.targeted);
        get.addClause(manIsClose2, grab);
        Translate translate = new Translate(this.maxCarrySpeed, 0.0);
        CompositeMotion compositeMotion4 = new CompositeMotion();
        compositeMotion4.add(translate);
        compositeMotion4.add(compositeMotion);
        DefaultAction defaultAction5 = new DefaultAction(compositeMotion4);
        Release release = new Release(this.carried, this.rightPropagator, this.carrierMap, get, this.targeted, this.b);
        ReadyToDrop readyToDrop2 = new ReadyToDrop(man, (double)(this.barrierX + this.barrierWidth) + this.barrierInset, true);
        defaultAction5.addClause(readyToDrop2, release);
        grab.setCarry(defaultAction5);
        VoltMan voltMan = new VoltMan(defaultAction2, get);
        release.setVoltMan(voltMan);
        voltMan.goHomeAndStayThere();
        voltMan.addDirectional(release);
        voltMan.addDirectional(new PropagatorDir(release, this.leftPropagator, this.rightPropagator));
        voltMan.addDirectional(new CarryToDir((double)this.barrierX - this.barrierInset, (double)(this.barrierX + this.barrierWidth) + this.barrierInset, readyToDrop2));
        SpeedDir speedDir = new SpeedDir(this.b, translate, true, this.minCarrySpeed, this.maxCarrySpeed);
        this.b.addParticleMoveListener(speedDir);
        voltMan.addDirectional(speedDir);
        return voltMan;
    }
}

