/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.common.electron.man;

import edu.colorado.phet.batteryvoltage.common.phys2d.DoublePoint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Vector;

public class Node {
    Vector children = new Vector();
    double x;
    double y;

    public Node(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public DoublePoint getPosition() {
        return new DoublePoint(this.x, this.y);
    }

    public void addChildRelative(double d, double d2) {
        this.addChild(new Node(this.x + d, this.y + d2));
    }

    public void addChild(Node node) {
        this.children.add(node);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int numChildren() {
        return this.children.size();
    }

    public void rotate(double d, double d2, double d3) {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d3, d, d2);
        this.transform(affineTransform);
    }

    public void rotate(double d) {
        for (int i = 0; i < this.numChildren(); ++i) {
            this.childAt(i).rotate(this.x, this.y, d);
        }
    }

    public void transform(AffineTransform affineTransform) {
        Point2D.Double double_ = new Point2D.Double(this.x, this.y);
        Point2D.Double double_2 = (Point2D.Double)affineTransform.transform(double_, null);
        this.x = double_2.x;
        this.y = double_2.y;
        for (int i = 0; i < this.children.size(); ++i) {
            this.childAt(i).transform(affineTransform);
        }
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
        for (int i = 0; i < this.children.size(); ++i) {
            this.childAt(i).translate(d, d2);
        }
    }

    public Node childAt(int n) {
        return (Node)this.children.get(n);
    }
}

