/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;

public class ScaleAlphaImageOpARGB
implements BufferedImageOp {
    private double _scale;

    public ScaleAlphaImageOpARGB() {
        this(1.0);
    }

    public ScaleAlphaImageOpARGB(double d) {
        this._scale = d;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        AffineTransformOp affineTransformOp = new AffineTransformOp(new AffineTransform(), 1);
        return affineTransformOp.createCompatibleDestImage(bufferedImage, colorModel);
    }

    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage.getType() != 2 && bufferedImage.getType() != 3) {
            throw new UnsupportedOperationException("unsupported BufferedImage type=" + bufferedImage.getType());
        }
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        }
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int[] nArray2 = ((DataBufferInt)writableRaster2.getDataBuffer()).getData();
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2 = nArray[i];
            int n3 = n2 >> 24 & 0xFF;
            int n4 = (int)(this._scale * (double)n3);
            nArray2[i] = n = n4 << 24 | n2 & 0xFFFFFF;
        }
        return bufferedImage2;
    }

    public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return new Rectangle2D.Double(0.0, 0.0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Double();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }
}

