/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import edu.colorado.phet.common.phetcommon.view.util.ScaleAlphaImageOpARGB;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import javax.swing.ImageIcon;

public class BufferedImageUtils {
    public static BufferedImage flipX(BufferedImage bufferedImage) {
        int n = bufferedImage.getType();
        if (bufferedImage.getType() == 0) {
            n = 2;
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = BufferedImageUtils.createTransformFlipX(bufferedImage);
        graphics2D.drawRenderedImage(bufferedImage, affineTransform);
        return bufferedImage2;
    }

    private static AffineTransform createTransformFlipX(BufferedImage bufferedImage) {
        AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, 1.0);
        affineTransform.translate(-bufferedImage.getWidth(), 0.0);
        return affineTransform;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static int getTransparency(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().getTransparency();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        int n = 1;
        if (colorModel != null) {
            n = colorModel.getTransparency();
        }
        return n;
    }

    public static BufferedImage toBufferedImage(Image image) {
        int n;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            n = BufferedImageUtils.getTransparency(image);
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        if (bufferedImage == null) {
            n = BufferedImageUtils.hasAlpha(image) ? 1 : 0;
            int n2 = 1;
            if (n != 0) {
                n2 = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n2);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage scaleAlpha(BufferedImage bufferedImage, double d) {
        ScaleAlphaImageOpARGB scaleAlphaImageOpARGB = new ScaleAlphaImageOpARGB(d);
        BufferedImage bufferedImage2 = scaleAlphaImageOpARGB.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        scaleAlphaImageOpARGB.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }
}

