/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireSystem;
import edu.colorado.phet.batteryresistorcircuit.volt.Batt;
import edu.colorado.phet.batteryresistorcircuit.volt.WireRegion;

public class SmoothBatt
extends Batt {
    WireRegion plus;
    WireRegion minus;
    WireSystem sys;
    double desiredVolts;

    public void valueChanged(double d) {
        this.desiredVolts = d;
    }

    public void coreCountChanged(int n) {
    }

    public SmoothBatt(WireRegion wireRegion, WireRegion wireRegion2, WireSystem wireSystem, double d, double d2) {
        super(wireRegion, wireRegion2, wireSystem, d, d2);
        this.desiredVolts = d2;
        this.plus = wireRegion;
        this.minus = wireRegion2;
        this.sys = wireSystem;
    }

    public int countLeft() {
        int n = 0;
        for (int i = 0; i < this.sys.numParticles(); ++i) {
            if (!this.plus.contains(this.sys.particleAt(i))) continue;
            ++n;
        }
        return n;
    }

    public int countRight() {
        int n = 0;
        for (int i = 0; i < this.sys.numParticles(); ++i) {
            if (!this.minus.contains(this.sys.particleAt(i))) continue;
            ++n;
        }
        return n;
    }

    public void propagate(WireParticle wireParticle, double d) {
        double d2 = this.getSpeed();
        wireParticle.setVelocity(d2);
        double d3 = wireParticle.getPosition();
        double d4 = d3 + wireParticle.getVelocity() * d;
        wireParticle.setPosition(d4);
    }

    public double getSpeed() {
        double d;
        double d2 = 1.0;
        if (this.desiredVolts < 0.0) {
            d2 = -1.0;
        }
        if ((d = Math.abs(this.desiredVolts)) <= 0.1) {
            return 0.0;
        }
        if (d <= 0.3) {
            return -4.0 * d2;
        }
        if (d <= 0.5) {
            return -6.0 * d2;
        }
        if (d <= 0.7) {
            return -8.0 * d2;
        }
        if (d <= 0.9) {
            return -10.0 * d2;
        }
        if (d <= 1.1) {
            return -12.0 * d2;
        }
        if (d < 1.3) {
            return -14.0 * d2;
        }
        if (d < 1.7) {
            return -16.0 * d2;
        }
        if (d < 1.9) {
            return -18.0 * d2;
        }
        if (d < 3.1) {
            return -20.0 * d2;
        }
        if (d < 5.1) {
            return -22.0 * d2;
        }
        if (d < 7.1) {
            return -24.0 * d2;
        }
        if (d < 9.1) {
            return -26.0 * d2;
        }
        return -28.0 * d2;
    }
}

