/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.volt;

import edu.colorado.phet.batteryresistorcircuit.common.wire1d.Force1d;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.Propagator1d;
import edu.colorado.phet.batteryresistorcircuit.common.wire1d.WireParticle;
import edu.colorado.phet.batteryresistorcircuit.gui.VoltageListener;
import java.util.Vector;

public class BatteryForcePropagator
implements Propagator1d,
VoltageListener {
    Vector forces = new Vector();
    double minSpeed;
    double maxSpeed;
    private double desiredVoltage;

    public BatteryForcePropagator(double d, double d2) {
        this.minSpeed = d;
        this.maxSpeed = d2;
    }

    public void setMinSpeed(double d) {
        this.minSpeed = d;
    }

    public void addForce(Force1d force1d) {
        this.forces.add(force1d);
    }

    public void propagate(WireParticle wireParticle, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.forces.size(); ++i) {
            d2 += ((Force1d)this.forces.get(i)).getForce(wireParticle);
        }
        double d3 = wireParticle.getMass();
        double d4 = wireParticle.getVelocity();
        double d5 = wireParticle.getPosition();
        double d6 = d2 / d3;
        double d7 = d4 += d6 * d;
        if (this.desiredVoltage < 0.0) {
            if (d4 > this.maxSpeed) {
                d4 = this.maxSpeed;
            } else if (d4 < this.minSpeed) {
                d4 = this.minSpeed;
            }
        } else if (d4 < -this.maxSpeed) {
            d4 = -this.maxSpeed;
        } else if (d4 > -this.minSpeed) {
            d4 = -this.minSpeed;
        }
        wireParticle.setVelocity(d4);
        double d8 = d5 + wireParticle.getVelocity() * d;
        wireParticle.setPosition(d8);
    }

    public void valueChanged(double d) {
        this.desiredVoltage = d;
        this.setMinSpeed(Math.abs(d * 0.7));
    }
}

