/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.oscillator2d;

import edu.colorado.phet.batteryresistorcircuit.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Particle;
import edu.colorado.phet.batteryresistorcircuit.common.phys2d.Propagator;

public class Oscillate
implements Propagator {
    DoublePoint x0;
    double amplitude;
    double freq;
    double amplitudeScale;
    DoublePoint axis;
    double t = 0.0;

    public Oscillate(DoublePoint doublePoint, double d, double d2, double d3, DoublePoint doublePoint2) {
        this.axis = doublePoint2.normalize();
        if (doublePoint2.getX() == 1.0 && doublePoint2.getY() == 1.0) {
            throw new RuntimeException();
        }
        this.amplitude = d;
        this.x0 = doublePoint;
        this.freq = d2;
        this.amplitudeScale = d3;
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public void propagate(double d, Particle particle) {
        this.t += d;
        this.amplitude *= this.amplitudeScale;
        double d2 = this.amplitude * Math.sin(this.t * this.freq);
        DoublePoint doublePoint = this.x0.add(this.axis.multiply(d2));
        particle.setPosition(doublePoint);
    }

    public double getAmplitude() {
        return this.amplitude;
    }
}

