/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryresistorcircuit.oscillator2d;

import edu.colorado.phet.batteryresistorcircuit.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.Core;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.Oscillate;
import edu.colorado.phet.batteryresistorcircuit.oscillator2d.OscillateFactory;
import java.util.Random;

public class DefaultOscillateFactory
implements OscillateFactory {
    Random random;
    double vToAScale;
    double decay;
    double freq;
    double aMax;
    DoublePoint axis;

    public DefaultOscillateFactory(Random random, double d, double d2, double d3, double d4, DoublePoint doublePoint) {
        this.random = random;
        this.axis = doublePoint;
        this.freq = d3;
        this.vToAScale = d;
        this.decay = d2;
        this.aMax = d4;
    }

    public Oscillate newOscillate(double d, Core core) {
        double d2 = this.random.nextDouble() * 3.0 + 0.5;
        if (this.random.nextBoolean()) {
            d2 = -d2;
        }
        this.axis = new DoublePoint(1.0, d2);
        double d3 = Math.abs(d * this.vToAScale);
        double d4 = 0.0;
        d4 = d3 < this.aMax ? d * this.vToAScale : (d < 0.0 ? -this.aMax : this.aMax);
        return new Oscillate(core.getOrigin(), d4, this.freq, this.decay, this.axis);
    }
}

